/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CustomParaName;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.BasebandPoolIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.CellIdentityParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.CellRangeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.HsCodeResourceIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.NuOfTxBranchesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.NumOfRxBranchesParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.TxBranchConfiguredConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.TxBranchConfiguredParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.UseCellParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.CarrierRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.RbsLocalCellRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;

public class SectorAndCellNumber {
    private static final int USECELL_CELLID_CELLRANGE = 3;
    private static final int CELLID_CELLRANGE_HSCODERESOURCEID = 2;
    private int sectorNumber;
    private int cellNumber;
    public final String[] VALUE_NO_STRING = new String[]{"NO"};
    protected boolean carrierRI_isInstalled = false;
    public boolean carrerIsAllocated = false;
    protected boolean unInstallCarrierRINeeded = false;
    public CellIdentityParameter cellIdentityParameter;
    protected CellRangeParameter cellRangeParameter;
    protected BasebandPoolIdParameter basebandPoolIdParameter;
    public UseCellParameter useCellParameter;
    public HsCodeResourceIdParameter hsCodeResourceIdParameter;
    private NuOfTxBranchesParameter nuOfTxBranchesPerCarrierParameter;
    private NumOfRxBranchesParameter numOfRxBranchesPerCarrierParameter;
    public TxBranchConfiguredParameter txBranchConfiguredParameter;
    public TxBranchConfiguredParameter txBranchConfiguredParameter2;
    protected String cellIdentityName;
    protected String cellRangeName;
    private String basebandPoolIdName;
    protected String useCellName;
    protected String hsCodeResourceIdName;
    protected String nuOfTxBranchesName;
    protected String numOfRxBranchesName;
    protected String txBranchConfiguredName;
    protected String txBranchConfigured2Name;
    private CustomParaName customerParameterNames;
    public CarrierRI carrierRI;
    public RbsLocalCellRI rbsLocalCellRI;
    protected ParameterRestriction modifyNotSupportedRestriction;
    protected String modifyNotSupportedRestrictionString = "Modification of already existing carriers is not supported.";
    protected ParameterRestriction notAllowedToAddCellRestriction;
    protected String notAllowedToAddCellRestrictionString = "Existing cells online and there is only one TX branch, cell can not be added.";
    protected ParameterRestriction notEquippedCarrierRestriction;
    protected String notEquippedCarrierRestrictionString = "Hardware equipment is not installed or configured, carrier can not be used.";
    protected ParameterRestriction cellIsNotUsedRestriction;
    protected String cellIsNotUsedRestrictionString = "The cell is not supposed to be used or created";
    private ParameterRestriction cellExistingRestriction;
    private String cellExistingRestrictionRestrictionString = "The cell is not configured to be existing";
    protected ParameterRestriction notEquippedSectorRestriction;
    protected String notEquippedSectorRestrictionString = "Sector deleted or not equipped, parameter access ignored!";
    protected ParameterRestriction deleteCarrierNotSupportedRestriction;
    protected String deleteCarrierNotSupportedRestrictionString = "Delete carrier is not supported.";
    private String[] hsCodeResourceAllowedRange;
    protected ParameterRestriction hsCodeResourceIdRangeRestriction;
    protected String hsCodeResourceIdRangeRestrictionString = "HsCodeResourceId out of range";
    private ParameterRestriction hsCodeResourceIdIgnoredRestriction;
    protected String hsCodeResourceIdIgnoredRestrictionString = "HsCodeResourceId is ignored";

    public SectorAndCellNumber(int n, int n2, CustomParaName customParaName) {
        this.setSectorNumber(n);
        this.setCellNumber(n2);
        this.customerParameterNames = customParaName;
    }

    public void createCustomerParameters(Rbs rbs, RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        this.getPseudoNames();
        this.cellIdentityParameter = new CellIdentityParameter(this.cellIdentityName);
        this.cellRangeParameter = new CellRangeParameter(this.cellRangeName);
        this.useCellParameter = new UseCellParameter(this.useCellName);
        this.basebandPoolIdParameter = new BasebandPoolIdParameter(this.basebandPoolIdName);
        this.nuOfTxBranchesPerCarrierParameter = this.createNuOfTxBranchesPerCarrierParameter(this.nuOfTxBranchesName, this.sectorNumber, rbs);
        this.numOfRxBranchesPerCarrierParameter = this.createNumOfRxBranchesPerCarrierParameter(this.numOfRxBranchesName, this.sectorNumber, rbs);
        this.txBranchConfiguredParameter = new TxBranchConfiguredParameter(this.txBranchConfiguredName);
        TxBranchConfiguredConversion txBranchConfiguredConversion = new TxBranchConfiguredConversion();
        this.txBranchConfiguredParameter.setMomConverter(txBranchConfiguredConversion);
        this.txBranchConfiguredParameter2 = new TxBranchConfiguredParameter(this.txBranchConfigured2Name);
        TxBranchConfiguredConversion txBranchConfiguredConversion2 = new TxBranchConfiguredConversion();
        this.txBranchConfiguredParameter2.setMomConverter(txBranchConfiguredConversion2);
        this.hsCodeResourceIdParameter = new HsCodeResourceIdParameter(this.hsCodeResourceIdName);
        this.useCellParameter.setValue("NO");
        this.hsCodeResourceIdParameter.setValue(MimRbsLocalCell.DEFAULT_HSCODERESOURCEID.toString());
        this.nuOfTxBranchesPerCarrierParameter.setDefaultValue();
        this.numOfRxBranchesPerCarrierParameter.setDefaultValue();
    }

    protected NuOfTxBranchesParameter createNuOfTxBranchesPerCarrierParameter(String string, int n, Rbs rbs) throws BemException {
        NuOfTxBranchesParameter nuOfTxBranchesParameter = new NuOfTxBranchesParameter(string, n, rbs);
        return nuOfTxBranchesParameter;
    }

    protected NumOfRxBranchesParameter createNumOfRxBranchesPerCarrierParameter(String string, int n, Rbs rbs) throws BemException {
        NumOfRxBranchesParameter numOfRxBranchesParameter = new NumOfRxBranchesParameter(string, n, rbs);
        return numOfRxBranchesParameter;
    }

    private void getPseudoNames() {
        this.cellIdentityName = this.customerParameterNames.getCellIdentityName(this.sectorNumber, this.cellNumber);
        this.cellRangeName = this.customerParameterNames.getCellRangePseudoName(this.sectorNumber, this.cellNumber);
        this.useCellName = this.customerParameterNames.getUseCellPseudoName(this.sectorNumber, this.cellNumber);
        this.hsCodeResourceIdName = this.customerParameterNames.getHsCodeResourceIdPseudoName(this.sectorNumber, this.cellNumber);
        this.basebandPoolIdName = this.customerParameterNames.getBasebandPoolIdPseudoName(this.sectorNumber, this.cellNumber);
        this.nuOfTxBranchesName = this.customerParameterNames.getNuOfTxBranchesPseudoName(this.sectorNumber, this.cellNumber);
        this.numOfRxBranchesName = this.customerParameterNames.getNumOfRxBranchesPseudoName(this.sectorNumber, this.cellNumber);
        this.txBranchConfiguredName = this.customerParameterNames.getTxBranchConfiguredPseudoName(this.sectorNumber, this.cellNumber);
        this.txBranchConfigured2Name = this.customerParameterNames.getTxBranchConfigured2PseudoName(this.sectorNumber, this.cellNumber);
    }

    public void initializeCustomerParameterRestrictions() {
        this.hsCodeResourceIdRangeRestriction = new ParameterRestriction(this.hsCodeResourceIdRangeRestrictionString);
        this.hsCodeResourceIdParameter.addRestriction(this.hsCodeResourceIdRangeRestriction);
        this.hsCodeResourceIdRangeRestriction.setActive(true);
        this.hsCodeResourceIdIgnoredRestriction = new ParameterRestriction(this.hsCodeResourceIdIgnoredRestrictionString, 1);
        this.hsCodeResourceIdParameter.addRestriction(this.hsCodeResourceIdIgnoredRestriction);
        this.hsCodeResourceIdIgnoredRestriction.setActive(false);
        this.deleteCarrierNotSupportedRestriction = new ParameterRestriction(this.deleteCarrierNotSupportedRestrictionString);
        this.addCustomerParameterGroupRestrictions(this.deleteCarrierNotSupportedRestriction, 3);
        this.deleteCarrierNotSupportedRestriction.setActive(false);
        this.modifyNotSupportedRestriction = new ParameterRestriction(this.modifyNotSupportedRestrictionString);
        this.modifyNotSupportedRestriction.setAccessLevel(0);
        this.addCustomerParameterGroupRestrictions(this.modifyNotSupportedRestriction, 3);
        this.modifyNotSupportedRestriction.setActive(false);
        this.notAllowedToAddCellRestriction = new ParameterRestriction(this.notAllowedToAddCellRestrictionString);
        this.notAllowedToAddCellRestriction.setRange(YesNoCustomerParameter.newEnumeratedValueRange(this.VALUE_NO_STRING), true);
        this.useCellParameter.addRestriction(this.notAllowedToAddCellRestriction);
        this.notAllowedToAddCellRestriction.setActive(false);
        this.notEquippedCarrierRestriction = new ParameterRestriction(this.notEquippedCarrierRestrictionString);
        this.notEquippedCarrierRestriction.setRange(YesNoCustomerParameter.newEnumeratedValueRange(this.VALUE_NO_STRING), true);
        this.useCellParameter.addRestriction(this.notEquippedCarrierRestriction);
        this.notEquippedCarrierRestriction.setActive(true);
        this.cellIsNotUsedRestriction = new ParameterRestriction(this.cellIsNotUsedRestrictionString);
        this.cellIsNotUsedRestriction.setAccessLevel(1);
        this.addCustomerParameterGroupRestrictions(this.cellIsNotUsedRestriction, 2);
        this.notEquippedSectorRestriction = new ParameterRestriction(this.notEquippedSectorRestrictionString);
        this.notEquippedSectorRestriction.setAccessLevel(1);
        this.useCellParameter.addRestriction(this.notEquippedSectorRestriction);
        this.addCustomerParameterGroupRestrictions(this.notEquippedSectorRestriction, 2);
        this.nuOfTxBranchesPerCarrierParameter.addRestriction(this.notEquippedSectorRestriction);
        this.numOfRxBranchesPerCarrierParameter.addRestriction(this.notEquippedSectorRestriction);
        this.notEquippedSectorRestriction.setActive(false);
        this.cellExistingRestriction = new ParameterRestriction(this.cellExistingRestrictionRestrictionString);
        this.cellExistingRestriction.setAccessLevel(1);
        this.nuOfTxBranchesPerCarrierParameter.addRestriction(this.cellExistingRestriction);
        this.numOfRxBranchesPerCarrierParameter.addRestriction(this.cellExistingRestriction);
        this.setCellExistingRestrictionActive(false);
    }

    public void setCellExistingRestrictionActive(boolean bl) {
        this.cellExistingRestriction.setActive(bl);
    }

    private void addCustomerParameterGroupRestrictions(ParameterRestriction parameterRestriction, int n) {
        switch (n) {
            case 2: {
                this.cellIdentityParameter.addRestriction(parameterRestriction);
                this.cellRangeParameter.addRestriction(parameterRestriction);
                this.hsCodeResourceIdParameter.addRestriction(parameterRestriction);
                break;
            }
            case 3: {
                this.cellIdentityParameter.addRestriction(parameterRestriction);
                this.cellRangeParameter.addRestriction(parameterRestriction);
                this.useCellParameter.addRestriction(parameterRestriction);
                break;
            }
        }
    }

    private void setSectorNumber(int n) {
        this.sectorNumber = n;
    }

    private void setCellNumber(int n) {
        this.cellNumber = n;
    }

    public int getSectorNumber() {
        return this.sectorNumber;
    }

    public int getCellNumber() {
        return this.cellNumber;
    }

    public BasebandPoolIdParameter getBasebandPoolIdRef() {
        return this.basebandPoolIdParameter;
    }

    public void updateBaseBandPoolId() {
        String string = this.carrierRI.getBaseBandPoolId();
        if (string != null) {
            this.basebandPoolIdParameter.setLoadedValue(string);
        }
    }

    public void setHsCodeResourceIdRange(int n) {
        this.hsCodeResourceAllowedRange = new String[n + 1];
        for (int i = 0; i <= n; ++i) {
            this.hsCodeResourceAllowedRange[i] = Integer.toString(i);
        }
    }

    public String[] getHsCodeResourceIdRange() {
        return this.hsCodeResourceAllowedRange;
    }

    public NuOfTxBranchesParameter getNuOfTxBranchesPerCarrierParameter() {
        return this.nuOfTxBranchesPerCarrierParameter;
    }

    public TxBranchConfiguredParameter getTxBranchConfiguredParameter() {
        return this.txBranchConfiguredParameter;
    }

    public TxBranchConfiguredParameter getTxBranchConfiguredParameter2() {
        return this.txBranchConfiguredParameter2;
    }

    public NumOfRxBranchesParameter getNumOfRxBranchesPerCarrierParameter() {
        return this.numOfRxBranchesPerCarrierParameter;
    }

    public void setCarrierIsInSupportedRange(boolean bl) {
        if (bl) {
            this.notEquippedCarrierRestriction.setActive(false);
        } else {
            this.notEquippedCarrierRestriction.setActive(true);
        }
    }

    public void setHsCodeResourceIdIgnoredRestriction(boolean bl) throws BemException {
        this.hsCodeResourceIdIgnoredRestriction.setActive(bl);
    }
}

