/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class NumOfRxBranchesParameter
extends Enumeration {
    public static final String DEFAULT_VALUE_STRING = "2";
    private static final boolean ALLOWED_RANGE = true;
    private int sectorNumber;
    private ParameterRestriction numOfRxBranchRestriction;
    private Rbs rbs;
    private RadioBuildingBlockListener rbbListener;
    private AuUnitTypeListener auUnitTypeListener;
    private static int MAX_NO_RXBRANCHES = 6;

    public NumOfRxBranchesParameter(String string, int n, Rbs rbs) throws BemException {
        super(string, NumOfRxBranchesParameter.createRange(MAX_NO_RXBRANCHES));
        this.sectorNumber = n;
        this.rbs = rbs;
        EnumeratedRange enumeratedRange = NumOfRxBranchesParameter.createRange(MAX_NO_RXBRANCHES);
        this.rbbListener = new RadioBuildingBlockListener();
        this.auUnitTypeListener = new AuUnitTypeListener();
        String string2 = this.getRbbPseudoName();
        String string3 = this.getAuUnitTypePseudoName();
        if (rbs.isParameterSupported(string2)) {
            CustomerParameter customerParameter = rbs.getCustomerParameterObject(string2);
            CustomerParameter customerParameter2 = null;
            if (rbs.isParameterSupported(string3)) {
                customerParameter2 = rbs.getCustomerParameterObject(string3);
            }
            this.createRxBranchRestriction(rbs, customerParameter, customerParameter2, enumeratedRange);
            this.updateRange(string2);
        }
    }

    private String getRbbPseudoName() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        String string2 = string + "radioBuildingBlock";
        return string2;
    }

    private String getAuUnitTypePseudoName() {
        String string = MessageFormat.format("S{0}_", new Integer(this.sectorNumber));
        String string2 = string + "auUnitType";
        return string2;
    }

    private void createRxBranchRestriction(Rbs rbs, CustomerParameter customerParameter, CustomerParameter customerParameter2, EnumeratedRange enumeratedRange) throws BemException {
        String string = "Current configured radio building block for sector=" + this.sectorNumber + " only supports the following number of RX branches " + enumeratedRange;
        this.numOfRxBranchRestriction = new ParameterRestriction(string, enumeratedRange, true);
        this.numOfRxBranchRestriction.setActive(true);
        this.addRbbListener(customerParameter);
        if (customerParameter2 != null) {
            this.addAuUnitTypeListener(customerParameter2);
        }
        this.addRestriction(this.numOfRxBranchRestriction);
    }

    private void updateRange(String string) throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
        if (!customerParameter.getValue().equals("")) {
            this.numOfRxBranchRestriction.setRange(new EnumeratedRange(this.getRxBranchRangeFromRbbName(customerParameter.getValue())), true);
        }
    }

    protected void addRbbListener(CustomerParameter customerParameter) {
        customerParameter.addCustomerParameterListener(this.rbbListener);
    }

    protected void addAuUnitTypeListener(CustomerParameter customerParameter) {
        customerParameter.addCustomerParameterListener(this.auUnitTypeListener);
    }

    private static EnumeratedRange createRange(int n) {
        int n2 = n / 2 + 1;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = "" + i * 2;
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        return enumeratedRange;
    }

    public int getValueAsInt() {
        String string = this.getValue();
        return Integer.parseInt(string);
    }

    public int getLoadedValueAsInt() {
        String string = this.getLoadedValue();
        if (string.equals("##UNDEFINED")) {
            return 2;
        }
        return Integer.parseInt(string);
    }

    public void setDefaultValue() throws BemException {
        int n;
        int n2 = 0;
        if (this.rbs.isPantherHybridRbs() && this.sectorNumber >= 7) {
            n2 = 1;
        }
        if ((n = this.rbs.getRadioEquipmentProvider(n2).getNumberOfSupportedRxBranches(this.sectorNumber)) > 0) {
            super.setDefaultValue(new Integer(n).toString());
        } else {
            super.setDefaultValue(DEFAULT_VALUE_STRING);
        }
    }

    private int getRxBranchNumFromRbbName(String string) {
        if (string.equalsIgnoreCase("RBB24_1A") || string.equalsIgnoreCase("RB2") || string.equalsIgnoreCase("RB5")) {
            return 4;
        }
        return 2;
    }

    private int[] getRxBranchRangeFromRbbName(String string) {
        if (AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber)) {
            if (string.equalsIgnoreCase("RBB24_1A") || string.equalsIgnoreCase("RBB44_1D")) {
                return new int[]{2, 4};
            }
            return new int[]{2};
        }
        if (string.equalsIgnoreCase("RB2") || string.equalsIgnoreCase("RB5")) {
            return new int[]{4};
        }
        if (string.equalsIgnoreCase("RBB12_1A") || string.equalsIgnoreCase("RBB22_1B") || string.equalsIgnoreCase("RBB22_1A")) {
            return new int[]{0, 2, 4, 6};
        }
        if (string.equalsIgnoreCase("RBB24_1A") || string.equalsIgnoreCase("RBB24_1B") || string.equalsIgnoreCase("RBB14_1A") || string.equalsIgnoreCase("RBB14_2A") || string.equalsIgnoreCase("RBB24_2B") || string.equalsIgnoreCase("RBB44_1D") || string.equalsIgnoreCase("RBB44_1B") || string.equalsIgnoreCase("RBB44_2C")) {
            return new int[]{2, 4};
        }
        return new int[]{2};
    }

    private void updateRxBranchRangeByRbb() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(this.getRbbPseudoName());
        this.numOfRxBranchRestriction.setRange(new EnumeratedRange(this.getRxBranchRangeFromRbbName(customerParameter.getValue())), true);
    }

    private class AuUnitTypeListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                try {
                    NumOfRxBranchesParameter.this.updateRxBranchRangeByRbb();
                }
                catch (BemException bemException) {
                    bemException.printStackTrace();
                }
            }
        }
    }

    private class RadioBuildingBlockListener
    implements CustomerParameterListener {
        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                if (parameterEvent.isValueChanged()) {
                    NumOfRxBranchesParameter.this.updateRxBranchRangeByRbb();
                    CustomerParameter customerParameter2 = NumOfRxBranchesParameter.this.rbs.getCustomerParameterObject(NumOfRxBranchesParameter.this.getRbbPseudoName());
                    int n = NumOfRxBranchesParameter.this.getRxBranchNumFromRbbName(customerParameter2.getValue());
                    NumOfRxBranchesParameter.this.setValue(new Integer(n).toString());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

