/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.AlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.SauAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.ScuAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.SupAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SauRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.GenericAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class CommonAlarmCI
extends AbstractConfigurationItem
implements AlarmConfigurationProvider,
CustomerParameterListener {
    public static final String name = "AlarmCI";
    public static final String SCU = "Scu";
    public static final String SAU = "Sau";
    public static final String SUP = "Sup";
    public static final String RRUW = "Rruw";
    private static final int RRUW_MAX_NO_ALMDEVICES = 6;
    private static final int RRUW_MAX_NO_OUTDEVICES = 0;
    private static final int MAX_NO_OF_RRUW_PER_SECTOR = 2;
    private static final String ALREADY_OPEN = "CommonAlarmCI.open(): Already open";
    private static final String ALARMS_ONLY_AT_SITE = "Alarms must be configured at site for this RBS type";
    private static final String ALARMS_DELETE_NOT_SUPPOTED = "Alarms are already installed, and to delete Alarms is not supported";
    private static final String OPEN_EXCEPTION = "CommonAlarmCI.open() got exception=";
    private HashMap sauRI = new HashMap();
    private HashMap sauHwUnitMoi = new HashMap();
    private HashMap scuHwUnitMoi = new HashMap();
    private HashMap supHwUnitMoi = new HashMap();
    private MoInstance[] rruwDeviceGroupMoi;
    private ArrayList cplist;
    private boolean isOpen = false;
    private HashMap configureSauParameter = new HashMap();
    private YesNoCustomerParameter configureScuParameter = null;
    private YesNoCustomerParameter configureSupParameter = null;
    private boolean configureScu = false;
    private boolean configureSup = false;
    private final boolean siteOnly;
    private boolean rbsSupportsSau = false;
    private HashMap scuAlarmManager = new HashMap();
    private HashMap sauAlarmManager = new HashMap();
    private HashMap supAlarmManager = new HashMap();
    private GenericAlarmManager[] rruwAlarmManager = new GenericAlarmManager[0];
    private String[] allowedValueNo = new String[]{"NO"};
    private EnumeratedRange allowedRangeNo = new EnumeratedRange(this.allowedValueNo);
    private ParameterRestriction restSauNoSupport = new ParameterRestriction("Configuration of SAU is not supported, when Support System Control = FALSE", this.allowedRangeNo, true);

    public CommonAlarmCI(Rbs rbs, boolean bl, boolean bl2) {
        super(rbs);
        this.siteOnly = bl;
        this.rbsSupportsSau = bl2;
    }

    public void setAlarmParent(MoInstance moInstance, String string) throws BemException {
        if (SAU.equalsIgnoreCase(string)) {
            this.sauHwUnitMoi.put(new Integer(0), moInstance);
        } else if (SCU.equalsIgnoreCase(string)) {
            this.scuHwUnitMoi.put(new Integer(0), moInstance);
        } else if (SUP.equalsIgnoreCase(string)) {
            this.supHwUnitMoi.put(new Integer(0), moInstance);
        }
    }

    public void setAlarmParent(MoInstance moInstance, String string, int n) throws BemException {
        if (SAU.equalsIgnoreCase(string)) {
            this.sauHwUnitMoi.put(new Integer(n), moInstance);
        } else if (SCU.equalsIgnoreCase(string)) {
            this.scuHwUnitMoi.put(new Integer(n), moInstance);
        } else if (SUP.equalsIgnoreCase(string)) {
            this.supHwUnitMoi.put(new Integer(n), moInstance);
        }
    }

    public void setAlarmParents(MoInstance[] moInstanceArray, int n) {
        for (int i = 0; i < moInstanceArray.length; ++i) {
            if (n != 20) continue;
            this.rruwDeviceGroupMoi[i] = moInstanceArray[i];
        }
    }

    public void setAlarmParents(MoInstance[] moInstanceArray, String string) throws BemException {
        block4: {
            block5: {
                block3: {
                    if (!SAU.equalsIgnoreCase(string)) break block3;
                    for (int i = 0; i < moInstanceArray.length; ++i) {
                        this.sauHwUnitMoi.put(new Integer(i), moInstanceArray[i]);
                    }
                    break block4;
                }
                if (!SCU.equalsIgnoreCase(string)) break block5;
                for (int i = 0; i < moInstanceArray.length; ++i) {
                    this.scuHwUnitMoi.put(new Integer(i), moInstanceArray[i]);
                }
                break block4;
            }
            if (!SUP.equalsIgnoreCase(string)) break block4;
            for (int i = 0; i < moInstanceArray.length; ++i) {
                this.supHwUnitMoi.put(new Integer(i), moInstanceArray[i]);
            }
        }
    }

    public void configureScu(boolean bl) {
        this.configureScu = bl;
    }

    public void configureSup(boolean bl) {
        this.configureSup = bl;
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            int n;
            if (this.isOpen) {
                throw new BemException(ALREADY_OPEN);
            }
            this.isOpen = true;
            this.createCustomerParameters();
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                String string = this.rbs.getCabinetNumberList().get(n).toString();
                this.sauRI.put(new Integer(n), new SauRI(this.rbs, string));
                this.setAlarmParent(this.createSauMoi(string), "SAU", n);
            }
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
                this.sauAlarmManager.put(new Integer(n), new SauAlarmManager(this.rbs, (MoInstance)this.sauHwUnitMoi.get(new Integer(n)), n2));
                this.cplist = ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).getCustomerParameters();
                this.addParametersFromCPList(this.cplist);
                ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).createAlarmPortRIs();
                ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).createControlPortRIs();
            }
            if (this.configureScu) {
                this.createScuManager();
            }
            if (this.configureSup) {
                this.createSupManager();
            }
            this.setRestrictions();
            this.setListeners();
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                super.addParameter((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n)));
            }
            if (this.configureScu) {
                super.addParameter(this.configureScuParameter);
            } else if (this.configureSup) {
                super.addParameter(this.configureSupParameter);
            }
            n = this.rbs.getMaxNumberOfSectors();
            this.rruwAlarmManager = new GenericAlarmManager[2 * n];
            this.rruwDeviceGroupMoi = new MoInstance[2 * n];
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                int n4 = i + 1;
                for (int j = 0; j < 2; ++j) {
                    int n5 = j + 1;
                    this.rruwAlarmManager[n3] = new GenericAlarmManager(this.rbs, this.rruwDeviceGroupMoi[n3], RRUW, 6, 0, n4, n5);
                    this.rruwDeviceGroupMoi[n3] = this.rruwAlarmManager[n3].getDeviceGroupMoi();
                    this.cplist = this.rruwAlarmManager[n3].getCustomerParametersForRruw();
                    this.addParametersFromCPList(this.cplist);
                    this.rruwAlarmManager[n3].createAlmdeviceRIs();
                    ++n3;
                }
            }
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException(OPEN_EXCEPTION + exception.toString());
        }
        return bl;
    }

    private MoInstance createSauMoi(String string) {
        String string2 = "SAU-" + string;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwUnit.MOTYPENAME, string2);
        return fixedRdnMoi;
    }

    private void setRestrictions() throws BemException {
        for (Map.Entry entry : this.sauRI.entrySet()) {
            ParameterRestriction parameterRestriction;
            Object k = entry.getKey();
            Object v = entry.getValue();
            boolean bl = ((SauRI)v).isInstalled();
            if (bl) {
                ((YesNoCustomerParameter)this.configureSauParameter.get(k)).setLoadedValue("YES");
                parameterRestriction = new ParameterRestriction(ALARMS_DELETE_NOT_SUPPOTED, new EnumeratedRange("YES"), true);
                ((YesNoCustomerParameter)this.configureSauParameter.get(k)).addRestriction(parameterRestriction);
            } else {
                ((YesNoCustomerParameter)this.configureSauParameter.get(k)).setLoadedValue("NO");
                if (this.siteOnly && this.getRbs().getRbsStep().equals("STEP_CABINET")) {
                    parameterRestriction = new ParameterRestriction(ALARMS_ONLY_AT_SITE, new EnumeratedRange("YES"), false);
                    ((YesNoCustomerParameter)this.configureSauParameter.get(k)).addRestriction(parameterRestriction);
                }
            }
            ((YesNoCustomerParameter)this.configureSauParameter.get(k)).addRestriction(this.restSauNoSupport);
        }
        this.configureScuParameter.setLoadedValue("NO");
        this.configureSupParameter.setLoadedValue("NO");
        this.restSauNoSupport.setActive(!this.isSauAvailable());
    }

    private boolean isSauAvailable() throws BemException {
        return this.rbsSupportsSau && this.rbs.getCustomerParameter("supportSystemControl").equals("TRUE");
    }

    private void createCustomerParameters() throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            String string = MessageFormat.format("CAB{0}_", new Integer(n));
            this.configureSauParameter.put(new Integer(i), new YesNoCustomerParameter(string + "configureSau"));
            ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(i))).setDefaultValue("NO");
        }
        this.configureScuParameter = new YesNoCustomerParameter("configureScu");
        this.configureScuParameter.setDefaultValue("NO");
        this.configureSupParameter = new YesNoCustomerParameter("configureSup");
        this.configureSupParameter.setDefaultValue("NO");
    }

    private void addParametersFromCPList(ArrayList arrayList) {
        for (Object e : arrayList) {
            CustomerParameter customerParameter = (CustomerParameter)e;
            this.addParameter(customerParameter);
        }
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, BemException, CustomerParameterException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        ArrayList arrayList;
        int n;
        this.findInValidPortIdCustomerParams(serviceValue);
        if (this.configureScu) {
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                if ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(n)) == null) continue;
                ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(n))).createAlarmPortRIs(serviceValue);
                ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(n))).createControlPortRIs(serviceValue);
                arrayList = ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(n))).getAlarmPortCustomerParameters(serviceValue);
                for (Object object62 : arrayList) {
                    object5 = (String[])object62;
                    super.setCustomerParametersFromSV((String[])object5, serviceValue);
                }
                object4 = ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(n))).getControlPortCustomerParameters(serviceValue);
                object62 = ((ArrayList)object4).iterator();
                while (object62.hasNext()) {
                    object5 = object62.next();
                    object3 = (String[])object5;
                    super.setCustomerParametersFromSV((String[])object3, serviceValue);
                }
            }
        }
        if (this.configureSup && this.supAlarmManager != null) {
            for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
                if ((SupAlarmManager)this.supAlarmManager.get(new Integer(n)) == null) continue;
                ((SupAlarmManager)this.supAlarmManager.get(new Integer(n))).createAlarmPortRIs(serviceValue);
                ((SupAlarmManager)this.supAlarmManager.get(new Integer(n))).createControlPortRIs(serviceValue);
                arrayList = ((SupAlarmManager)this.supAlarmManager.get(new Integer(n))).getAlarmPortCustomerParameters(serviceValue);
                for (Object object62 : arrayList) {
                    object5 = (String[])object62;
                    super.setCustomerParametersFromSV((String[])object5, serviceValue);
                }
                object4 = ((SupAlarmManager)this.supAlarmManager.get(new Integer(n))).getControlPortCustomerParameters(serviceValue);
                object62 = ((ArrayList)object4).iterator();
                while (object62.hasNext()) {
                    object5 = object62.next();
                    object3 = (String[])object5;
                    super.setCustomerParametersFromSV((String[])object3, serviceValue);
                }
            }
        }
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
            object4 = MessageFormat.format("CAB{0}_", new Integer(n2));
            object2 = serviceValue.getValue((String)object4 + "configureSau");
            if (object2 != null && ((String)object2).length() > 0) {
                ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n))).setValue((String)object2);
            }
            if ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n)) == null || ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n))).getValue() == null || !((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n))).getValue().equals("YES") || (SauAlarmManager)this.sauAlarmManager.get(new Integer(n)) == null) continue;
            ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).createAlarmPortRIs(serviceValue);
            ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).createControlPortRIs(serviceValue);
            object62 = ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).getAlarmPortCustomerParameters(serviceValue);
            object3 = ((ArrayList)object62).iterator();
            while (object3.hasNext()) {
                object = object3.next();
                stringArray = (String[])object;
                super.setCustomerParametersFromSV(stringArray, serviceValue);
            }
            object5 = ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).getControlPortCustomerParameters(serviceValue);
            object = ((ArrayList)object5).iterator();
            while (object.hasNext()) {
                String[] stringArray2 = stringArray = object.next();
                super.setCustomerParametersFromSV(stringArray2, serviceValue);
            }
        }
        RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
        object4 = radioEquipmentProvider.getRruwMois();
        object2 = new ArrayList();
        if (object4 != null && this.rruwDeviceGroupMoi != null) {
            int n3;
            for (n3 = 0; n3 < object4.size(); ++n3) {
                object5 = (MoInstance[])object4.get(n3);
                if (object5 == null) continue;
                for (int i = 0; i < ((MoInstance[])object5).length; ++i) {
                    object2.add((MoInstance)object5[i]);
                }
            }
            for (n3 = 0; n3 < this.rruwDeviceGroupMoi.length; ++n3) {
                object5 = this.rruwDeviceGroupMoi[n3].getLdn();
                for (int i = 0; i < object2.size(); ++i) {
                    object = (MoInstance)object2.get(i);
                    stringArray = ((MoInstance)object).getLdn();
                    if (!((String)object5).equals(stringArray) || this.getRbs().getRbsStep().equals("STEP_CABINET")) continue;
                    ArrayList arrayList2 = this.rruwAlarmManager[n3].getAlmDeviceCustomerParameters(serviceValue);
                    for (Object e : arrayList2) {
                        String[] stringArray3 = (String[])e;
                        super.setCustomerParametersFromSV(stringArray3, serviceValue);
                    }
                }
            }
        }
    }

    private void findInValidPortIdCustomerParams(ServiceValue serviceValue) {
        Object object;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        Vector vector6 = new Vector();
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            object = MessageFormat.format("CAB{0}_", new Integer(n));
            vector.addAll(serviceValue.getAttributesStartingWith((String)object + SAU + "ExternalAlarm"));
            vector2.addAll(serviceValue.getAttributesStartingWith((String)object + SCU + "ExternalAlarm"));
            vector3.addAll(serviceValue.getAttributesStartingWith((String)object + SUP + "ExternalAlarm"));
            vector4.addAll(serviceValue.getAttributesStartingWith((String)object + SAU + "ControlPort"));
            vector5.addAll(serviceValue.getAttributesStartingWith((String)object + SCU + "ControlPort"));
            vector6.addAll(serviceValue.getAttributesStartingWith((String)object + SUP + "ControlPort"));
        }
        IntegerRange integerRange = new IntegerRange(1, ((SauAlarmManager)this.sauAlarmManager.get(new Integer(0))).getMAX_NO_ALARMPORTS());
        ParameterRestriction parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
        this.addRestrictionsOnPortIds(vector, this.rbs, integerRange, parameterRestriction);
        object = new IntegerRange(1, ((SauAlarmManager)this.sauAlarmManager.get(new Integer(0))).getMAX_NO_CONTROLPORTS());
        ParameterRestriction parameterRestriction2 = new ParameterRestriction("Port Id out of range", (ParameterRange)object, true);
        this.addRestrictionsOnPortIds(vector4, this.rbs, (IntegerRange)object, parameterRestriction2);
        if ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(0)) != null) {
            integerRange = new IntegerRange(1, ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(0))).getMAX_NO_ALARMPORTS());
            parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
            object = new IntegerRange(1, ((ScuAlarmManager)this.scuAlarmManager.get(new Integer(0))).getMAX_NO_CONTROLPORTS());
            parameterRestriction2 = new ParameterRestriction("Port Id out of range", (ParameterRange)object, true);
            this.addRestrictionsOnPortIds(vector2, this.rbs, integerRange, parameterRestriction);
            this.addRestrictionsOnPortIds(vector5, this.rbs, (IntegerRange)object, parameterRestriction2);
        } else if ((SupAlarmManager)this.supAlarmManager.get(new Integer(0)) != null) {
            integerRange = new IntegerRange(1, ((SupAlarmManager)this.supAlarmManager.get(new Integer(0))).getMAX_NO_ALARMPORTS());
            parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
            object = new IntegerRange(1, ((SupAlarmManager)this.supAlarmManager.get(new Integer(0))).getMAX_NO_CONTROLPORTS());
            parameterRestriction2 = new ParameterRestriction("Port Id out of range", (ParameterRange)object, true);
            this.addRestrictionsOnPortIds(vector3, this.rbs, integerRange, parameterRestriction);
            this.addRestrictionsOnPortIds(vector6, this.rbs, (IntegerRange)object, parameterRestriction2);
        }
    }

    private void addRestrictionsOnPortIds(Vector vector, Rbs rbs, IntegerRange integerRange, ParameterRestriction parameterRestriction) {
        for (int i = 0; i < vector.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            boolean bl = rbs.isParameterSupported(name);
            if (bl || !name.endsWith("portId")) continue;
            IntegerParameter integerParameter = new IntegerParameter(name, integerRange);
            integerParameter.setValue(serviceNameValue.getValueAsString());
            integerParameter.addRestriction(parameterRestriction);
            this.addParameter(integerParameter);
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        Object object;
        int n;
        if (this.configureScu) {
            this.configureScuParameter.setValue("YES");
        }
        if (this.configureSup) {
            this.configureSupParameter.setValue("YES");
        }
        ArrayList<SauRI> arrayList = new ArrayList<SauRI>();
        String string = this.configureScuParameter.getValue();
        String string2 = this.configureSupParameter.getValue();
        String string3 = "1";
        String string4 = "1";
        for (n = 0; n < this.rbs.getNoOfCabinets(); ++n) {
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
            Map.Entry entry = ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(n))).getValue();
            if (!this.isSauAvailable() || !((String)((Object)entry)).equals("YES")) continue;
            object = new ArrayList();
            if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, n2)) continue;
            String string5 = MessageFormat.format("CAB{0}_", new Integer(n2));
            if (this.rbs.isParameterSupported(string5 + "cabinetNumber") && this.rbs.isParameterSupported(string5 + "ecBusNumber")) {
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string5 + "cabinetNumber");
                IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string5 + "ecBusNumber");
                if (!integerParameter.getValue().equals("##UNDEFINED")) {
                    if (integerParameter.getValue().equals(string3) && integerParameter2.getValue().equals("##UNDEFINED")) {
                        ((SauRI)this.sauRI.get(new Integer(n))).setEcBusNo4MulCab(string4);
                    } else {
                        ((SauRI)this.sauRI.get(new Integer(n))).setEcBusNo4MulCab(integerParameter2.getValue());
                    }
                    ((SauRI)this.sauRI.get(new Integer(n))).setUnitNumbe4MulCab(integerParameter.getValue());
                }
            }
            arrayList.add((SauRI)this.sauRI.get(new Integer(n)));
            if ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n)) == null) continue;
            object = ((SauAlarmManager)this.sauAlarmManager.get(new Integer(n))).getNeededRIs();
            arrayList.addAll((Collection<SauRI>)object);
        }
        if ("YES".equals(string)) {
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry entry : this.scuAlarmManager.entrySet()) {
                object = entry.getValue();
                if (object == null) continue;
                arrayList2 = ((ScuAlarmManager)object).getNeededRIs();
                arrayList.addAll(arrayList2);
            }
        }
        if ("YES".equals(string2)) {
            ArrayList arrayList3 = new ArrayList();
            for (Map.Entry entry : this.supAlarmManager.entrySet()) {
                object = entry.getValue();
                if (object == null) continue;
                arrayList3 = ((SupAlarmManager)object).getNeededRIs();
                arrayList.addAll(arrayList3);
            }
        }
        for (n = 0; n < this.rruwAlarmManager.length; ++n) {
            ArrayList arrayList4 = new ArrayList();
            if (!this.rruwAlarmManager[n].configureAlarmForRruw()) continue;
            arrayList4 = this.rruwAlarmManager[n].getNeededRIs();
            arrayList.addAll(arrayList4);
        }
        return arrayList;
    }

    public AlarmManager getAlarmManager(String string) {
        if (string.endsWith(SAU)) {
            return (SauAlarmManager)this.sauAlarmManager.get(new Integer(0));
        }
        if (string.endsWith(SCU)) {
            return (ScuAlarmManager)this.scuAlarmManager.get(new Integer(0));
        }
        if (string.endsWith(SUP)) {
            return (SupAlarmManager)this.supAlarmManager.get(new Integer(0));
        }
        return null;
    }

    public AlarmManager getAlarmManager(String string, int n) {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            if (n2 != n) continue;
            if (string.endsWith(SAU)) {
                return (SauAlarmManager)this.sauAlarmManager.get(new Integer(i));
            }
            if (string.endsWith(SCU)) {
                return (ScuAlarmManager)this.scuAlarmManager.get(new Integer(i));
            }
            if (string.endsWith(SUP)) {
                return (SupAlarmManager)this.supAlarmManager.get(new Integer(i));
            }
            return null;
        }
        return null;
    }

    public SauRI getSauRI() {
        return (SauRI)this.sauRI.get(new Integer(0));
    }

    public SauRI getSauRI(int n) {
        return (SauRI)this.sauRI.get(new Integer(n));
    }

    public void updateSupManager() {
        for (Map.Entry entry : this.supAlarmManager.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            ((SupAlarmManager)v).setHwUnitMoi((MoInstance)this.supHwUnitMoi.get(k));
        }
    }

    public void configureScu() {
    }

    public void configureSup() {
    }

    private void createScuManager() {
        try {
            for (Map.Entry entry : this.scuHwUnitMoi.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                this.scuAlarmManager.put(k, new ScuAlarmManager(this.rbs, (MoInstance)v, (Integer)k + 1));
                this.cplist = ((ScuAlarmManager)this.scuAlarmManager.get(k)).getCustomerParameters();
                this.addParametersFromCPList(this.cplist);
                ((ScuAlarmManager)this.scuAlarmManager.get(k)).createAlarmPortRIs();
                ((ScuAlarmManager)this.scuAlarmManager.get(k)).createControlPortRIs();
            }
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
    }

    private void createSupManager() {
        try {
            for (Map.Entry entry : this.supHwUnitMoi.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) continue;
                int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(Integer.parseInt(k.toString())).toString());
                this.supAlarmManager.put(k, new SupAlarmManager(this.rbs, (MoInstance)v, n));
                this.cplist = ((SupAlarmManager)this.supAlarmManager.get(k)).getCustomerParameters();
                this.addParametersFromCPList(this.cplist);
                ((SupAlarmManager)this.supAlarmManager.get(k)).createAlarmPortRIs();
                ((SupAlarmManager)this.supAlarmManager.get(k)).createControlPortRIs();
            }
        }
        catch (BemException bemException) {
            bemException.printStackTrace();
        }
    }

    void createParameters() throws Exception {
        this.createCustomerParameters();
    }

    boolean isConfigureScu() {
        return this.configureScu;
    }

    boolean isConfigureSup() {
        return this.configureSup;
    }

    void setManager(Object object) {
        if (object instanceof SauAlarmManager) {
            this.sauAlarmManager.put(new Integer(0), (SauAlarmManager)object);
        } else if (object instanceof ScuAlarmManager) {
            this.scuAlarmManager.put(new Integer(0), (ScuAlarmManager)object);
        } else if (object instanceof SupAlarmManager) {
            this.supAlarmManager.put(new Integer(0), (SupAlarmManager)object);
        }
    }

    void setConfigureSauParameter(boolean bl) {
        ((YesNoCustomerParameter)this.configureSauParameter.get(new Integer(0))).setValue(bl);
    }

    void setSauRi(SauRI sauRI) {
        this.sauRI.put(new Integer(0), sauRI);
    }

    MoInstance getSauMoi() {
        return (MoInstance)this.sauHwUnitMoi.get(new Integer(0));
    }

    MoInstance getScuMoi() {
        return (MoInstance)this.scuHwUnitMoi.get(new Integer(0));
    }

    MoInstance getSupMoi() {
        return (MoInstance)this.supHwUnitMoi.get(new Integer(0));
    }

    public void setConfigureAlarmForRruw(int n, boolean bl) throws BemException {
        for (int i = 0; i < this.rruwAlarmManager.length; ++i) {
            String string = this.rruwAlarmManager[i].getSectorNumber();
            if (!String.valueOf(n).equals(string)) continue;
            this.rruwAlarmManager[i].setConfigureAlarmForRruw(bl);
        }
    }

    public void requestUnInitAlarms(int n, List list, Object object) throws BemException {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < this.rruwAlarmManager.length; ++j) {
                String string2 = this.rruwAlarmManager[j].getDeviceGroupLdn();
                if (!string.equals(string2)) continue;
                this.rruwAlarmManager[j].saveAttributes();
            }
        }
    }

    private void setListeners() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl");
        customerParameter.addCustomerParameterListener(this);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            String string2 = customerParameter.getValue();
            if (string.equals("supportSystemControl")) {
                this.restSauNoSupport.setActive(!this.rbsSupportsSau || !string2.equals("TRUE"));
            }
        }
    }
}

