/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;

public class ApcHubPortManager {
    Map APC_HUB_PORT_TABLE = new HashMap();
    private int maxNoOfPDU;
    private int maxNoOfPSU;
    private int maxNoOfBFU;
    private static final ApcHubPortManager singleIntance = new ApcHubPortManager();

    private ApcHubPortManager() {
        this.createHwUnitMapTable();
        this.initCountMaxNo4APC();
    }

    public static ApcHubPortManager getInstance() {
        return singleIntance;
    }

    private void createHwUnitMapTable() {
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 1), new ApcHubPort("PDU", 1, "A2"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 2), new ApcHubPort("PDU", 2, "B2"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 3), new ApcHubPort("PDU", 3, "B7"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 4), new ApcHubPort("PDU", 4, "A8"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 5), new ApcHubPort("PDU", 5, "B3"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 6), new ApcHubPort("PDU", 6, "B4"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 7), new ApcHubPort("PDU", 7, "B6"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PDU", 8), new ApcHubPort("PDU", 8, "B5"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 1), new ApcHubPort("PSU", 1, "A3"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 2), new ApcHubPort("PSU", 2, "B3"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 3), new ApcHubPort("PSU", 3, "A4"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 4), new ApcHubPort("PSU", 4, "B4"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 5), new ApcHubPort("PSU", 5, "B6"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 6), new ApcHubPort("PSU", 6, "B2"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("PSU", 7), new ApcHubPort("PSU", 7, "B7"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("BFU", 1), new ApcHubPort("BFU", 1, "B5"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("BFU", 2), new ApcHubPort("BFU", 2, "A5"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("SCU", 1), new ApcHubPort("SCU", 1, "A1"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("CLU", 1), new ApcHubPort("CLU", 1, "B8"));
        this.APC_HUB_PORT_TABLE.put(this.generateKey("SUP", 1), new ApcHubPort("SUP", 1, "NA"));
    }

    private Object generateKey(String string, int n) {
        return string + "_" + Integer.toString(n);
    }

    public ApcHubPort getApcPortValue(String string, int n) {
        Object object = this.generateKey(string, n);
        ApcHubPort apcHubPort = null;
        if (this.APC_HUB_PORT_TABLE.containsKey(object)) {
            apcHubPort = (ApcHubPort)this.APC_HUB_PORT_TABLE.get(object);
        }
        return apcHubPort;
    }

    private void initCountMaxNo4APC() {
        this.maxNoOfPSU = 0;
        this.maxNoOfPDU = 0;
        this.maxNoOfBFU = 0;
        Set set = this.APC_HUB_PORT_TABLE.keySet();
        for (String string : set) {
            if (string.indexOf("PDU") != -1) {
                ++this.maxNoOfPDU;
                continue;
            }
            if (string.indexOf("PSU") != -1) {
                ++this.maxNoOfPSU;
                continue;
            }
            if (string.indexOf("BFU") == -1) continue;
            ++this.maxNoOfBFU;
        }
    }

    public int getMaxNoOfPDU() {
        return this.maxNoOfPDU;
    }

    public int getMaxNoOfPSU() {
        return this.maxNoOfPSU;
    }

    public int getMaxNoOfBFU() {
        return this.maxNoOfBFU;
    }
}

