/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AddDuwBoardSlotCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.CabinetRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ClimateRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.CluRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.EcBusRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ScuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class ClimateManager {
    protected boolean hasClimateUnit;
    protected boolean hasSupportControlUnit;
    protected Rbs rbs;
    protected ArrayList allRIs;
    protected AlarmConfigurationProvider alarmConfigurationProvider;
    protected EnumeratedRange climateSystemRange;
    protected EnumeratedRange climateRegulationSystemRange;
    private CluRI cluRI;
    protected HashMap cabinetRI = new HashMap();
    protected HashMap scuRI = new HashMap();
    protected HashMap climateRI = new HashMap();
    protected EcBusRI[] ecBusRI = new EcBusRI[7];
    protected HashMap supRI = new HashMap();
    private static final int START_INDEX = 0;

    public ClimateManager(Rbs rbs, boolean bl, boolean bl2, EnumeratedRange enumeratedRange, EnumeratedRange enumeratedRange2) {
        this.rbs = rbs;
        this.hasClimateUnit = bl;
        this.hasSupportControlUnit = bl2;
        this.climateSystemRange = enumeratedRange;
        this.climateRegulationSystemRange = enumeratedRange2;
    }

    public void createAllRIs() throws BemException {
        this.cluRI = new CluRI(this.rbs);
        this.allRIs = new ArrayList();
        this.createSupRIs(this.allRIs);
        this.createScuRIs(this.allRIs);
        this.createCabinetAndClimateRI(this.allRIs);
        this.createEcBusRI(this.allRIs);
        this.allRIs.add(this.cluRI);
        this.setAlarmConfigurationInterface();
    }

    private void createSupRIs(ArrayList arrayList) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            String string = this.rbs.getCabinetNumberList().get(i).toString();
            this.supRI.put(new Integer(i), new SupRI(this.rbs, string));
            arrayList.add(this.supRI.get(new Integer(i)));
        }
    }

    private void createScuRIs(ArrayList arrayList) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            this.scuRI.put(new Integer(i), new ScuRI(this.rbs));
            arrayList.add(this.scuRI.get(new Integer(i)));
        }
    }

    private void createCabinetAndClimateRI(ArrayList arrayList) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            this.cabinetRI.put(new Integer(i), new CabinetRI(this.rbs, false, n));
            this.climateRI.put(new Integer(i), new ClimateRI(this.rbs, n));
            arrayList.add(this.cabinetRI.get(new Integer(i)));
            arrayList.add(this.climateRI.get(new Integer(i)));
        }
    }

    private void createEcBusRI(ArrayList arrayList) throws BemException {
        this.ecBusRI[0] = new EcBusRI(this.rbs, 1, "EC");
        arrayList.add(this.ecBusRI[0]);
        for (int i = 1; i < 7; ++i) {
            this.ecBusRI[i] = new EcBusRI(this.rbs, i + 1, "EC", "IRU");
            arrayList.add(this.ecBusRI[i]);
        }
    }

    public boolean hasClimateUnit() {
        return this.hasClimateUnit;
    }

    public boolean hasSupportControlUnit() {
        return this.hasSupportControlUnit;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList arrayList = new ArrayList();
        this.addSupAndCluRI(arrayList);
        this.addCabinetAndClimateRI(arrayList);
        this.addEcBusRI(arrayList);
        return arrayList;
    }

    public ArrayList getRIsToBeUnInstalled() throws BemException {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 1; n < this.rbs.getNoOfCabinets(); ++n) {
            int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
            String string = MessageFormat.format("DCAB{0}_", new Integer(n2));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "cabinetNumber");
            if (integerParameter.getValue().equals("##UNDEFINED")) continue;
            arrayList.add(this.cabinetRI.get(new Integer(n)));
            String string2 = MessageFormat.format("CAB{0}_", new Integer(n2)) + "ecBusNumber";
            IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string2);
            if (integerParameter2.getValue().equals("##UNDEFINED")) continue;
            this.ecBusUninstalledIfNeeded(integerParameter2.getValue(), arrayList);
        }
        if ("FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            for (n = 1; n < 7; ++n) {
                if (this.ecBusRI[n] == null) continue;
                arrayList.add(this.ecBusRI[n]);
            }
        }
        return arrayList;
    }

    protected void ecBusUninstalledIfNeeded(String string, ArrayList arrayList) throws BemException {
        EcBusRI ecBusRI = this.ecBusRI[Integer.valueOf(string) - 1];
        BemMo[] bemMoArray = ecBusRI.getEcBusReservedByObjects();
        if (bemMoArray != null && bemMoArray.length == 1) {
            arrayList.add(ecBusRI);
        }
    }

    public void updateBoards(String string) throws BemException {
        block3: {
            block4: {
                block2: {
                    if (!string.equals("CLU") || this.cluRI == null) break block2;
                    String string2 = this.lookupHubPos(string);
                    this.cluRI.setHubPosition(string2);
                    break block3;
                }
                if (!string.equals("SCU")) break block4;
                String string3 = this.lookupHubPos(string);
                for (Map.Entry entry : this.scuRI.entrySet()) {
                    Object v = entry.getValue();
                    if (v == null) continue;
                    ((ScuRI)v).setHubPosition(string3);
                }
                break block3;
            }
            if (!string.equals("SUP")) break block3;
            String string4 = this.lookupHubPos(string);
            for (Map.Entry entry : this.supRI.entrySet()) {
                Object v = entry.getValue();
                if (v == null) continue;
                ((SupRI)v).setHubPosition(string4);
            }
        }
    }

    protected String lookupHubPos(String string) throws BemException {
        return this.lookupHubPos(string, 0);
    }

    protected String lookupHubPos(String string, int n) {
        ApcHubPort apcHubPort;
        String string2 = "";
        if ((string.equals("SCU") || string.equals("CLU") || string.equals("SUP")) && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(string, 1)) != null) {
            string2 = apcHubPort.getHubPosition();
        }
        return string2;
    }

    private void setAlarmConfigurationInterface() throws BemException {
        this.alarmConfigurationProvider = (AlarmConfigurationProvider)((Object)this.rbs.getConfigItem("AlarmCI"));
        if (this.alarmConfigurationProvider != null) {
            if (this.hasSupportControlUnit) {
                this.alarmConfigurationProvider.configureScu(true);
                this.alarmConfigurationProvider.configureSup(true);
                this.alarmConfigurationProvider.setAlarmParent(((ScuRI)this.scuRI.get(new Integer(0))).getHwUnitMoi(), "SCU", 0);
            }
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                this.alarmConfigurationProvider.setAlarmParent(((SupRI)this.supRI.get(new Integer(i))).getHwUnitMoi(), "SUP", i);
            }
        }
    }

    public EnumeratedRange getClimateSystemRange() {
        return this.climateSystemRange;
    }

    public EnumeratedRange getClimateRegulationSystemRange() {
        return this.climateRegulationSystemRange;
    }

    public void updateLoadedValues() throws BemException {
        for (Map.Entry entry : this.cabinetRI.entrySet()) {
            Object v = entry.getValue();
            if (!((CabinetRI)v).isInstalled()) continue;
            ((CabinetRI)v).updateLoadedValues();
        }
        for (int i = 0; i < 7; ++i) {
            if (!this.ecBusRI[i].isInstalled()) continue;
            this.ecBusRI[i].updateLoadedValues();
        }
    }

    public void setBatteryInfoForClimate(boolean bl, boolean bl2) {
        for (Map.Entry entry : this.climateRI.entrySet()) {
            Object v = entry.getValue();
            ((ClimateRI)v).setBatteryInfoForClimate(bl, bl2);
        }
    }

    private void addSupAndCluRI(ArrayList arrayList) throws BemException {
        if (this.hasSupportControlUnit && "TRUE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            if (this.hasClimateUnit) {
                arrayList.add(this.cluRI);
            }
            if (this.scuRI != null) {
                arrayList.add(this.scuRI.get(new Integer(0)));
                for (Map.Entry entry : this.climateRI.entrySet()) {
                    String string;
                    Object k = entry.getKey();
                    int n = Integer.parseInt(k.toString());
                    int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
                    if (PowerSystemUtil.isContainDelCabinetCp(this.rbs, n2) || !this.rbs.isParameterSupported((string = MessageFormat.format("CAB{0}_", new Integer(n2))) + "ecBusNumber")) continue;
                    IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "cabinetNumber");
                    Enumeration enumeration = (Enumeration)this.rbs.getCustomerParameterObject(string + "cabinetType");
                    if (integerParameter.getValue().equals("##UNDEFINED") || !this.checkCabinetType4DIRU(enumeration.getValue()) || !enumeration.getValue().equals("RBS6601W")) continue;
                    IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "ecBusNumber");
                    if (!((SupRI)this.supRI.get(new Integer(n))).isInstalled()) {
                        ((SupRI)this.supRI.get(new Integer(n))).setEcBusNo4MulCab(integerParameter2.getValue());
                        ((SupRI)this.supRI.get(new Integer(n))).setUnitNumbe4MulCab(integerParameter.getValue());
                        ((SupRI)this.supRI.get(new Integer(n))).setIgnoreEcportInfo(true);
                        arrayList.add(this.supRI.get(new Integer(n)));
                        continue;
                    }
                    if (!integerParameter2.hasValueChanged()) continue;
                    ((SupRI)this.supRI.get(new Integer(n))).setEcBusNo4MulCab(integerParameter2.getValue());
                    ((SupRI)this.supRI.get(new Integer(n))).setIgnoreEcportInfo(true);
                    arrayList.add((SupRI)this.supRI.get(new Integer(n)));
                }
            }
        }
    }

    private void addCabinetAndClimateRI(ArrayList arrayList) throws BemException {
        if (this.rbs.isCabinetWiz()) {
            arrayList.add(this.cabinetRI.get(new Integer(0)));
            arrayList.add(this.climateRI.get(new Integer(0)));
        } else {
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                Object object;
                IntegerParameter integerParameter;
                int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
                if (n != 1 && !(integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject((String)(object = MessageFormat.format("DCAB{0}_", new Integer(n))) + "cabinetNumber")).getValue().equals("##UNDEFINED")) continue;
                if (n == 2 && this.rbs.getRbsType().equals(RbsInfo.RBS_6302W.NAME) && DuwUtil.hasDualDuws() && null != (object = (AddDuwBoardSlotCustomerParameter)this.rbs.getCustomerParameterObject("AddDuwBoardslot")) && !((CustomerParameterImpl)object).getValue().equals("##UNDEFINED")) {
                    arrayList.add(this.cabinetRI.get(new Integer(1)));
                    arrayList.add(this.climateRI.get(new Integer(1)));
                    continue;
                }
                object = MessageFormat.format("CAB{0}_", new Integer(n));
                integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject((String)object + "cabinetNumber");
                if (integerParameter.getValue().equals("##UNDEFINED")) continue;
                arrayList.add(this.cabinetRI.get(new Integer(i)));
                arrayList.add(this.climateRI.get(new Integer(i)));
            }
        }
    }

    private void addEcBusRI(ArrayList arrayList) throws BemException {
        arrayList.add(this.ecBusRI[0]);
        RbbManager rbbManager = (RbbManager)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class);
        for (int i = 2; i <= 7; ++i) {
            AbstractRuRI[] abstractRuRIArray;
            Object object;
            int n;
            IntegerParameter integerParameter;
            int n2 = i;
            String string = MessageFormat.format("EcBus{0}_", new Integer(n2));
            String string2 = MessageFormat.format("ModEcBus{0}_", new Integer(n2));
            if (!this.rbs.isParameterSupported(string + "ecBusNumber") && !this.rbs.isParameterSupported(string2 + "connectorUnitNumber")) continue;
            IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
            IntegerParameter integerParameter3 = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
            if (!integerParameter3.getValue().equals("##UNDEFINED")) {
                integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
                n = Integer.valueOf(integerParameter.getValue());
                if (rbbManager.getRadioBuildingBlock(n) == null) {
                    throw new BemException("ECBus connectorUnitNumber = " + integerParameter.getValue() + " has not existed,  can not be modified!");
                }
                object = rbbManager.getSectorRadioUnits(n);
                abstractRuRIArray = (AbstractRuRI[])this.rbs.getMoHandler().getMo(this.ecBusRI[i - 1].getLdn()).getAttribute("ecBusConnectorRef");
                BemMo bemMo = (BemMo)abstractRuRIArray.getAttribute("positionRef");
                String string3 = bemMo.getDN();
                BemMo bemMo2 = this.rbs.getMoHandler().getMo(object[0].getAuxPiuLdn());
                BemMo bemMo3 = (BemMo)bemMo2.getAttribute("positionRef");
                String string4 = bemMo3.getDN();
                if (!string4.equals(string3)) {
                    throw new BemException("Modify ECBus connectorUnitNumber, AuxPlugInUnit " + abstractRuRIArray.getDN() + " \nand " + bemMo2.getDN() + " should be in the same cabinet!");
                }
                this.ecBusRI[i - 1].setConnectionRefLdn(object[0].getAuxPiuLdn());
                arrayList.add(this.ecBusRI[i - 1]);
                continue;
            }
            if (integerParameter2.getValue().equals("##UNDEFINED") || !integerParameter2.hasValueChanged()) continue;
            integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
            n = Integer.valueOf(integerParameter.getValue());
            if (rbbManager.getRadioBuildingBlock(n) == null) {
                throw new BemException("ECBus connectorUnitNumber = " + integerParameter.getValue() + " has not existed,  can not be added!");
            }
            object = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl");
            if (!((BooleanCustomerParameter)object).getBooleanValue()) {
                return;
            }
            abstractRuRIArray = rbbManager.getSectorRadioUnits(n);
            this.ecBusRI[i - 1].setConnectionRefLdn(abstractRuRIArray[0].getAuxPiuLdn());
            arrayList.add(this.ecBusRI[i - 1]);
        }
    }

    protected boolean checkCabinetType4DIRU(String string) {
        return PowerSystemUtil.cabinetTypeList4DIRU.contains(string);
    }

    public boolean isIruInCabinet(int n, String string) {
        boolean bl = false;
        List list = ((CabinetRI)this.cabinetRI.get(new Integer(n))).getIruList();
        String string2 = this.getSectorNumber(string);
        for (int i = 0; i < list.size(); ++i) {
            String string3 = (String)list.get(i);
            if (!this.getSectorNumber(string3).equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public String getSectorNumber(String string) {
        if (string.indexOf("-") != -1) {
            string = string.substring(string.indexOf("-") + 1);
            string = string.substring(0, string.indexOf("-"));
        }
        return string;
    }

    public boolean isIruInCabinet(int n, int n2) throws BemException {
        if (this.ecBusRI[n2].isInstalled()) {
            BemMo bemMo = (BemMo)this.rbs.getMoHandler().getMo(this.ecBusRI[n2].getLdn()).getAttribute("ecBusConnectorRef");
            return this.isIruInCabinet(n, bemMo.getId());
        }
        return false;
    }
}

