/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AddDuwBoardSlotCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ClimateManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.CabinetRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ClimateRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.EcBusRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class ClimateManagerBox
extends ClimateManager {
    public ClimateManagerBox(Rbs rbs, boolean bl, boolean bl2, EnumeratedRange enumeratedRange, EnumeratedRange enumeratedRange2) {
        super(rbs, bl, bl2, enumeratedRange, enumeratedRange2);
    }

    public void createAllRIs() throws BemException {
        this.allRIs = new ArrayList();
        this.createSupRI(this.allRIs);
        this.createCabinetAndClimateRI(this.allRIs);
        this.createEcBusRI(this.allRIs);
        this.setAlarmConfigurationInterface();
    }

    private void createSupRI(ArrayList arrayList) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            String string = this.rbs.getCabinetNumberList().get(i).toString();
            this.supRI.put(new Integer(i), new SupRI(this.rbs, string));
            arrayList.add(this.supRI.get(new Integer(i)));
        }
    }

    private void createEcBusRI(ArrayList arrayList) throws BemException {
        this.ecBusRI[0] = new EcBusRI(this.rbs, 1, "EC");
        arrayList.add(this.ecBusRI[0]);
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            this.ecBusRI[1] = new EcBusRI(this.rbs, 2, "AUX");
        } else {
            for (int i = 1; i < 7; ++i) {
                this.ecBusRI[i] = new EcBusRI(this.rbs, i + 1, "EC", "IRU");
                arrayList.add(this.ecBusRI[i]);
            }
        }
    }

    private void createCabinetAndClimateRI(ArrayList arrayList) throws BemException {
        for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
            int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
            this.cabinetRI.put(new Integer(i), new CabinetRI(this.rbs, true, n));
            this.climateRI.put(new Integer(i), new ClimateRI(this.rbs, n));
            arrayList.add(this.cabinetRI.get(new Integer(i)));
            arrayList.add(this.climateRI.get(new Integer(i)));
        }
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList arrayList = new ArrayList();
        if ("TRUE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
            this.addRIsForPrimaryNode(arrayList);
        }
        this.addCabinetAndClimateRI(arrayList, false);
        this.addEcBusRI(arrayList);
        return arrayList;
    }

    public ArrayList getRIsToBeUnInstalled() throws BemException {
        ArrayList<EcBusRI> arrayList = new ArrayList<EcBusRI>();
        String string = this.rbs.getRbsStep();
        if (string.equals("STEP_EXPANSION")) {
            int n;
            ControlSystemProvider controlSystemProvider = (ControlSystemProvider)this.rbs.getProvider(ControlSystemProvider.class);
            CustomerParameter customerParameter = controlSystemProvider.getAddDuwBoardSlotCustomerParameter();
            if (customerParameter.hasValueChanged()) {
                this.addCabinetAndClimateRI(arrayList, true);
                this.addEcBusRI(arrayList);
            }
            if ("FALSE".equals(this.rbs.getCustomerParameter("supportSystemControl"))) {
                for (int i = 1; i < 7; ++i) {
                    if (this.ecBusRI[i] == null) continue;
                    arrayList.add(this.ecBusRI[i]);
                }
            }
            EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
            EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
            for (n = 0; n < ecPortInfoArray.length; ++n) {
                EcPortInfo ecPortInfo = ecPortInfoArray[n];
                if (!ecPortInfo.getUnitTypeValue().equals("DUW") || !ecPortInfo.getcascadingOrderParameter().hasValueChanged()) continue;
                if (ecPortInfo.getUnitNumberValue().equals(String.valueOf(1))) {
                    arrayList.add((EcBusRI)this.supRI.get(new Integer(0)));
                    this.addSupRIsForPrimaryNode(arrayList, 2, true);
                    continue;
                }
                if (this.supRI.get(new Integer(1)) == null) continue;
                arrayList.add((EcBusRI)this.supRI.get(new Integer(1)));
            }
            for (n = 1; n < this.rbs.getNoOfCabinets(); ++n) {
                int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(n).toString());
                String string2 = MessageFormat.format("DCAB{0}_", new Integer(n2));
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "cabinetNumber");
                if (integerParameter.getValue().equals("##UNDEFINED")) continue;
                arrayList.add((EcBusRI)this.cabinetRI.get(new Integer(n)));
                String string3 = MessageFormat.format("CAB{0}_", new Integer(n2)) + "ecBusNumber";
                IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string3);
                if (integerParameter2.getValue().equals("##UNDEFINED")) continue;
                this.ecBusUninstalledIfNeeded(integerParameter2.getValue(), arrayList);
            }
        }
        return arrayList;
    }

    public void updateBoards(String string) throws BemException {
        super.updateBoards(string);
        if (string.equals("SUP")) {
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                if (this.supRI.get(new Integer(i)) == null) continue;
                String string2 = this.lookupHubPos(string, 1);
                ((SupRI)this.supRI.get(new Integer(i))).setHubPosition(string2);
            }
        }
    }

    private void setAlarmConfigurationInterface() throws BemException {
        this.alarmConfigurationProvider = (AlarmConfigurationProvider)((Object)this.rbs.getConfigItem("AlarmCI"));
        if (this.alarmConfigurationProvider != null) {
            if (this.hasSupportControlUnit) {
                this.alarmConfigurationProvider.configureSup(true);
            }
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                this.alarmConfigurationProvider.setAlarmParent(((SupRI)this.supRI.get(new Integer(i))).getHwUnitMoi(), "SUP", i);
            }
        }
    }

    public void updateLoadedValues() throws BemException {
        for (Object k : this.cabinetRI.keySet()) {
            Object v = this.cabinetRI.get(k);
            if (((CabinetRI)v).isInstalled()) {
                ((CabinetRI)v).updateLoadedValues();
            }
            ((SupRI)this.supRI.get(k)).updateLoadedValues();
            int n = Integer.parseInt(k.toString());
            if (null == this.ecBusRI[n]) continue;
            this.ecBusRI[n].updateLoadedValues();
        }
        this.updateCascadingOrderForDuwEcPortCP();
        for (int i = 0; i < 7; ++i) {
            if (this.ecBusRI[i] == null || !this.ecBusRI[i].isInstalled()) continue;
            this.ecBusRI[i].updateLoadedValues();
        }
    }

    private void updateCascadingOrderForDuwEcPortCP() {
        BemMo bemMo = this.rbs.getMoHandler().getMo(BemLdn.LDN_CABINET);
        BemMo bemMo2 = this.rbs.getMoHandler().getMo(BemLdn.LDN_CABINET2);
        if (!(DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && bemMo.isExisting() && bemMo2.isExisting())) {
            return;
        }
        int[] nArray = new int[]{0, 0};
        int n = 0;
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            String string = ecPortInfo.getUnitTypeValue();
            Enumeration enumeration = ecPortInfo.getcascadingOrderParameter();
            if (!string.equals("DUW")) continue;
            Integer n2 = (Integer)enumeration.getValueMom();
            if (n2 > Integer.parseInt("0")) {
                nArray[n++] = n2;
                continue;
            }
            if (1 != n) continue;
            enumeration.setLoadedValue(new Integer(3 - nArray[0]));
        }
    }

    private boolean isCascadingMode(int n) throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Integer n2 = ecPortInfo.getCascadingOrderValueMom();
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private void addEcBusRI(ArrayList arrayList) throws BemException {
        arrayList.add(this.ecBusRI[0]);
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            arrayList.add(this.ecBusRI[1]);
        } else {
            RbbManager rbbManager = (RbbManager)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class);
            for (int i = 2; i <= 7; ++i) {
                AbstractRuRI[] abstractRuRIArray;
                Object object;
                int n;
                IntegerParameter integerParameter;
                int n2 = i;
                String string = MessageFormat.format("EcBus{0}_", new Integer(n2));
                String string2 = MessageFormat.format("ModEcBus{0}_", new Integer(n2));
                if (!this.rbs.isParameterSupported(string + "ecBusNumber") && !this.rbs.isParameterSupported(string2 + "connectorUnitNumber")) continue;
                IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
                IntegerParameter integerParameter3 = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
                if (!integerParameter3.getValue().equals("##UNDEFINED")) {
                    integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
                    n = Integer.valueOf(integerParameter.getValue());
                    if (rbbManager.getRadioBuildingBlock(n) == null) {
                        throw new BemException("ECBus connectorUnitNumber = " + integerParameter.getValue() + " has not existed,  can not be modified!");
                    }
                    object = rbbManager.getSectorRadioUnits(n);
                    abstractRuRIArray = (AbstractRuRI[])this.rbs.getMoHandler().getMo(this.ecBusRI[i - 1].getLdn()).getAttribute("ecBusConnectorRef");
                    BemMo bemMo = (BemMo)abstractRuRIArray.getAttribute("positionRef");
                    String string3 = bemMo.getDN();
                    BemMo bemMo2 = this.rbs.getMoHandler().getMo(object[0].getAuxPiuLdn());
                    BemMo bemMo3 = (BemMo)bemMo2.getAttribute("positionRef");
                    String string4 = bemMo3.getDN();
                    if (!string4.equals(string3)) {
                        throw new BemException("Modify ECBus connectorUnitNumber, AuxPlugInUnit " + abstractRuRIArray.getDN() + " \nand " + bemMo2.getDN() + " should be in the same cabinet!");
                    }
                    this.ecBusRI[i - 1].setConnectionRefLdn(object[0].getAuxPiuLdn());
                    arrayList.add(this.ecBusRI[i - 1]);
                    continue;
                }
                if (integerParameter2.getValue().equals("##UNDEFINED") || !integerParameter2.hasValueChanged()) continue;
                integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
                n = Integer.valueOf(integerParameter.getValue());
                if (rbbManager.getRadioBuildingBlock(n) == null) {
                    throw new BemException("ECBus connectorUnitNumber = " + integerParameter.getValue() + " has not existed,  can not be added!");
                }
                object = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl");
                if (!((BooleanCustomerParameter)object).getBooleanValue()) {
                    return;
                }
                abstractRuRIArray = rbbManager.getSectorRadioUnits(n);
                this.ecBusRI[i - 1].setConnectionRefLdn(abstractRuRIArray[0].getAuxPiuLdn());
                arrayList.add(this.ecBusRI[i - 1]);
            }
        }
    }

    private void addRIsForPrimaryNode(ArrayList arrayList) throws BemException {
        arrayList.add(this.supRI.get(new Integer(0)));
        int n = 2;
        if (DuwUtil.hasDualDuws()) {
            if (!this.isSup6601InOneCabinet()) {
                ((SupRI)this.supRI.get(new Integer(1))).setUnitNumbe4MulCab(String.valueOf(2));
                arrayList.add(this.supRI.get(new Integer(1)));
                ++n;
            }
        } else {
            this.addSupRIsForPrimaryNode(arrayList, n, true);
        }
        if (this.isCascadingMode(n)) {
            this.addSupRIsForPrimaryNode(arrayList, n, false);
        }
    }

    private void addSupRIsForPrimaryNode(ArrayList arrayList, int n, boolean bl) throws BemException {
        for (int i = n; i <= Integer.parseInt(this.rbs.getCabinetNumberList().get(this.rbs.getNoOfCabinets() - 1).toString()); ++i) {
            String string;
            String string2;
            int n2 = this.rbs.getCabinetNumberList().indexOf(new Integer(i));
            if (n2 == -1 || PowerSystemUtil.isContainDelCabinetCp(this.rbs, i) || !this.rbs.isParameterSupported((string2 = MessageFormat.format("CAB{0}_", new Integer(i))) + "ecBusNumber")) continue;
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "cabinetNumber");
            Enumeration enumeration = (Enumeration)this.rbs.getCustomerParameterObject(string2 + "cabinetType");
            if ((enumeration.getValue().equals("##UNDEFINED") || !this.checkCabinetType4DIRU(enumeration.getValue())) && !this.isCascadingMode(i)) continue;
            IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "ecBusNumber");
            String string3 = integerParameter2.getValue().equals("##UNDEFINED") ? (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType()) ? String.valueOf(2) : String.valueOf(1)) : integerParameter2.getValue();
            String string4 = string = integerParameter.getValue().equals("##UNDEFINED") ? String.valueOf(i) : integerParameter.getValue();
            if (!((SupRI)this.supRI.get(new Integer(n2))).isInstalled() || this.isCascadingMode(i)) {
                ((SupRI)this.supRI.get(new Integer(n2))).setEcBusNo4MulCab(string3);
                ((SupRI)this.supRI.get(new Integer(n2))).setUnitNumbe4MulCab(string);
                ((SupRI)this.supRI.get(new Integer(n2))).setIgnoreEcportInfo(bl);
                arrayList.add(this.supRI.get(new Integer(n2)));
                continue;
            }
            if (!integerParameter2.hasValueChanged()) continue;
            ((SupRI)this.supRI.get(new Integer(n2))).setEcBusNo4MulCab(string3);
            ((SupRI)this.supRI.get(new Integer(n2))).setIgnoreEcportInfo(bl);
            arrayList.add(this.supRI.get(new Integer(n2)));
        }
    }

    private boolean isSup6601InOneCabinet() throws BemException {
        boolean bl = false;
        if (DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && !this.isCascadingMode(1)) {
            bl = true;
        }
        return bl;
    }

    private void addCabinetAndClimateRI(ArrayList arrayList, boolean bl) throws BemException {
        if (this.rbs.isCabinetWiz()) {
            int n = 1;
            arrayList.add(this.cabinetRI.get(new Integer(0)));
            arrayList.add(this.climateRI.get(new Integer(0)));
            if (DuwUtil.hasDualDuws() && !this.isSup6601InOneCabinet()) {
                arrayList.add(this.cabinetRI.get(new Integer(1)));
                arrayList.add(this.climateRI.get(new Integer(1)));
                ++n;
            }
            for (int i = this.rbs.getCabinetNumberList().indexOf(new Integer(n)); i < this.rbs.getNoOfCabinets(); ++i) {
                int n2 = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
                if (!this.isCascadingMode(n2)) continue;
                arrayList.add(this.cabinetRI.get(new Integer(i)));
                arrayList.add(this.climateRI.get(new Integer(i)));
            }
        } else {
            for (int i = 0; i < this.rbs.getNoOfCabinets(); ++i) {
                Object object;
                IntegerParameter integerParameter;
                int n = Integer.parseInt(this.rbs.getCabinetNumberList().get(i).toString());
                if (!bl && n != 1 && !(integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject((String)(object = MessageFormat.format("DCAB{0}_", new Integer(n))) + "cabinetNumber")).getValue().equals("##UNDEFINED")) continue;
                if (n == 2 && DuwUtil.hasDualDuws() && null != (object = (AddDuwBoardSlotCustomerParameter)this.rbs.getCustomerParameterObject("AddDuwBoardslot")) && !((CustomerParameterImpl)object).getValue().equals("##UNDEFINED") && !this.isSup6601InOneCabinet()) {
                    arrayList.add(this.cabinetRI.get(new Integer(1)));
                    arrayList.add(this.climateRI.get(new Integer(1)));
                    continue;
                }
                object = MessageFormat.format("CAB{0}_", new Integer(n));
                integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject((String)object + "cabinetNumber");
                if (!integerParameter.getValue().equals("##UNDEFINED")) {
                    arrayList.add(this.cabinetRI.get(new Integer(i)));
                    arrayList.add(this.climateRI.get(new Integer(i)));
                    continue;
                }
                if (!this.isCascadingMode(n)) continue;
                arrayList.add(this.cabinetRI.get(new Integer(i)));
                arrayList.add(this.climateRI.get(new Integer(i)));
            }
        }
    }
}

