/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.PowerSupplyRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.PsuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class PowerSupplyManager {
    private static final String HW_UNIT_TYPE = "PSU";
    private Rbs rbs;
    private MoInstance equipmentMoi;
    private MoInstance equipmentSupportFunctionMoi;
    private int[] psuPositions = new int[0];
    private IntegerRange psuRange;
    private TreeMap psuRIs = new TreeMap();
    private PowerSupplyRI powerSupplyRI;
    private boolean powerSupplySupported;
    private int cabinetNumber;

    public PowerSupplyManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl) {
        this.rbs = rbs;
        this.psuRange = integerRange;
        this.psuPositions = nArray;
        this.powerSupplySupported = bl;
        this.cabinetNumber = 1;
        this.equipmentMoi = rbs.getEquipmentMoi();
        this.equipmentSupportFunctionMoi = new SingleChildMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "1");
    }

    public PowerSupplyManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl, int n) {
        this(rbs, nArray, integerRange, bl);
        this.cabinetNumber = n;
    }

    public int[] getPsuPositions() {
        return this.psuPositions;
    }

    public IntegerRange getPsuRange() {
        return this.psuRange;
    }

    public void updateBoards(String string) throws BemException {
        for (int i = 0; i < this.psuPositions.length; ++i) {
            PsuRI psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuPositions[i]));
            if (psuRI == null) continue;
            String string2 = psuRI.getHubPosition();
            String string3 = this.lookupHubPos(string, string2, i + 1);
            psuRI.setHubPosition(string3);
        }
        this.updateMoi();
    }

    public String lookupHubPos(String string, String string2, int n) {
        ApcHubPort apcHubPort;
        String string3 = string2;
        if (string.equals(HW_UNIT_TYPE) && n > 0 && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(HW_UNIT_TYPE, n)) != null) {
            string3 = apcHubPort.getHubPosition();
        }
        return string3;
    }

    public void createAllRIs() throws BemException {
        this.createPowerSupplyRI(this.equipmentSupportFunctionMoi);
    }

    public ArrayList getRIsToBeInstalled(boolean bl, int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = Integer.valueOf((String)object);
                int n2 = Integer.valueOf((String)object2);
                return n - n2;
            }
        });
        if (this.isPowerSupplySupported()) {
            ArrayList arrayList2 = this.getNeededPowerSupplyRI(bl);
            arrayList.addAll(arrayList2);
            if (bl && this.psuRange.getMaxValue() > 0) {
                arrayList2 = this.getNeededPsuRIs(bl, n, list);
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public ArrayList getRIsToUninstall(int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = Integer.valueOf((String)object);
                int n2 = Integer.valueOf((String)object2);
                return n - n2;
            }
        });
        int n2 = list.size();
        int n3 = n2 - n;
        if (n3 > 0) {
            arrayList = this.getPsuRIsToBeUnInstalled(n3, list);
        }
        return arrayList;
    }

    public boolean isPowerSupplySupported() {
        return this.powerSupplySupported;
    }

    public int getNumberOfPsus() {
        return this.psuPositions.length;
    }

    public int getNumberOfInstalledPsus() throws BemException {
        return this.countInstalledPsus(this.psuRIs);
    }

    protected ArrayList getNeededPowerSupplyRI(boolean bl) {
        ArrayList<PowerSupplyRI> arrayList = new ArrayList<PowerSupplyRI>();
        arrayList.add(this.powerSupplyRI);
        return arrayList;
    }

    protected ArrayList getNeededPsuRIs(boolean bl, int n, List list) throws BemException {
        ArrayList<PsuRI> arrayList = new ArrayList<PsuRI>();
        TreeMap treeMap = null;
        if (bl) {
            this.createPsuRIs(n, list);
            treeMap = this.psuRIs;
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                PsuRI psuRI = (PsuRI)entry.getValue();
                arrayList.add(psuRI);
            }
        }
        return arrayList;
    }

    protected boolean isPowerSupplyInstalled() throws BemException {
        return this.powerSupplyRI.isInstalled();
    }

    protected void updateMoi() throws BemException {
        for (int i = 0; i < this.psuPositions.length; ++i) {
            PsuRI psuRI = (PsuRI)this.psuRIs.get(new Integer(this.psuPositions[i]));
            if (psuRI == null) continue;
            psuRI.updateMoi(this.equipmentMoi);
        }
    }

    private int countInstalledPsus(TreeMap treeMap) throws BemException {
        int n = 0;
        Set set = treeMap.entrySet();
        for (Map.Entry entry : set) {
            PsuRI psuRI = (PsuRI)entry.getValue();
            boolean bl = psuRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    private void createPowerSupplyRI(MoInstance moInstance) throws BemException {
        this.powerSupplyRI = new PowerSupplyRI(this.rbs, moInstance, this.cabinetNumber);
    }

    private void createPsuRIs(int n, List list) throws BemException {
        RDNHelper rDNHelper = RDNHelper.getInstance();
        if (n > list.size()) {
            String string;
            String string2;
            Integer n2;
            PsuRI psuRI;
            int n3;
            for (n3 = 0; n3 < list.size(); ++n3) {
                psuRI = new PsuRI(this.rbs, Integer.valueOf(list.get(n3).toString()), this.equipmentMoi);
                n2 = new Integer(this.psuPositions[n3]);
                string2 = psuRI.getHubPosition();
                string = this.lookupHubPos(HW_UNIT_TYPE, string2, n3 + 1);
                psuRI.setHubPosition(string);
                this.psuRIs.put(n2, psuRI);
            }
            for (n3 = 0; n3 < n - list.size(); ++n3) {
                psuRI = new PsuRI(this.rbs, rDNHelper.getPostfix(rDNHelper.getPsuRdnList()), this.equipmentMoi);
                n2 = new Integer(this.psuPositions[list.size() + n3]);
                string2 = psuRI.getHubPosition();
                string = this.lookupHubPos(HW_UNIT_TYPE, string2, list.size() + n3 + 1);
                psuRI.setHubPosition(string);
                this.psuRIs.put(n2, psuRI);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                PsuRI psuRI = new PsuRI(this.rbs, Integer.valueOf(list.get(i).toString()), this.equipmentMoi);
                Integer n4 = new Integer(this.psuPositions[i]);
                String string = psuRI.getHubPosition();
                String string3 = this.lookupHubPos(HW_UNIT_TYPE, string, i + 1);
                psuRI.setHubPosition(string3);
                this.psuRIs.put(n4, psuRI);
            }
        }
    }

    private ArrayList getPsuRIsToBeUnInstalled(int n, List list) throws BemException {
        int n2;
        ArrayList<PsuRI> arrayList = new ArrayList<PsuRI>();
        this.createPsuRIs(n, list);
        Set set = this.psuRIs.keySet();
        Object[] objectArray = set.toArray();
        for (int i = n2 = objectArray.length - 1; i > 0; --i) {
            PsuRI psuRI = (PsuRI)this.psuRIs.get(objectArray[i]);
            if (n <= 0 || !psuRI.isInstalled()) continue;
            arrayList.add(psuRI);
            --n;
        }
        return arrayList;
    }

    void setPsuRi(TreeMap treeMap) throws BemException {
        this.psuRIs.putAll(treeMap);
    }

    void setPowerSupplyRi(PowerSupplyRI powerSupplyRI) {
        this.powerSupplyRI = powerSupplyRI;
    }

    void setPowerSupplySupported(boolean bl) {
        this.powerSupplySupported = bl;
    }

    Object getAttributeValue(String string) throws BemException {
        return this.powerSupplyRI.getAttributeValue(string);
    }
}

