/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class PowerSystemUtil {
    public static final String CABINET_TYPE_6601W = "RBS6601W";
    public static final List cabinetTypeList4DIRU = new ArrayList(){
        {
            this.add(PowerSystemUtil.CABINET_TYPE_6601W);
        }
    };
    public static final int maxNumberOfEcBus = 7;
    public static final String CONNECTION_TYPE_EC = "EC";
    public static final String CONNECTION_TYPE_AUX = "AUX";
    public static final int MINLEN_CONNECTION_TYPE = 2;
    public static final int MAXLEN_CONNECTION_TYPE = 3;
    public static final String CONNECTION_UNIT_IRU = "IRU";
    public static final String CONNECTION_UNIT_DUW = "DUW";
    public static final String PDU_TYPE_NAME = "PDU";
    public static final String PSU_TYPE_NAME = "PSU";
    public static final String BFU_TYPE_NAME = "BFU";
    public static final int FIRST_SUP_NO = 1;
    public static final int SECOND_SUP_NO = 2;
    public static final int FIRST_CAB_NO = 1;
    public static final int SECOND_CAB_NO = 2;
    public static final int FIRST_CLIMATE_NO = 1;
    public static final int SECOND_CLIMATE_NO = 2;
    public static final int FIRST_ECBUS_NO = 1;
    public static final int SECOND_ECBUS_NO = 2;
    public static final int ADD_CABINET = 1;
    public static final int MODIFY_CABINET = 2;
    public static final int DELETE_CABINET = 3;

    public static void addControlDomainRef(Vector vector, String string, int n, Rbs rbs) throws BemException {
        MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimCabinet.MOTYPENAME, String.valueOf(n));
        String string2 = fixedRdnMoi.getLdn();
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        BemMo bemMo = rbs.getMoHandler().getMo(string2);
        arrayList.add(bemMo);
        BemMo[] bemMoArray = arrayList.toArray(new BemMo[0]);
        NalNameValue nalNameValue = Nal.getFactory().getNameValue(string, bemMoArray);
        vector.add(nalNameValue);
    }

    public static IntegerRange getNoOfAPCRange(String string, String string2) {
        IntegerRange integerRange = null;
        if (string.equals(PSU_TYPE_NAME)) {
            if (string2.equals(CABINET_TYPE_6601W)) {
                int[] nArray = new int[]{2, 3, 4, 5, 6};
                int n = nArray.length;
                integerRange = new IntegerRange(new Integer(1), new Integer(n));
            }
        } else if (string.equals(PDU_TYPE_NAME)) {
            if (string2.equals(CABINET_TYPE_6601W)) {
                int[] nArray = new int[]{7, 8, 9, 10};
                int n = nArray.length;
                integerRange = new IntegerRange(new Integer(1), new Integer(n));
            }
        } else if (string.equals(BFU_TYPE_NAME) && string2.equals(CABINET_TYPE_6601W)) {
            int[] nArray = new int[]{1};
            int n = nArray.length;
            integerRange = new IntegerRange(new Integer(1), new Integer(n));
        }
        return integerRange;
    }

    public static boolean isContainDelCabinetCp(Rbs rbs, int n) throws BemException {
        String string = MessageFormat.format("DCAB{0}_", new Integer(n));
        return rbs.isParameterSupported(string + "cabinetNumber") && !rbs.getCustomerParameter(string + "cabinetNumber").equals("##UNDEFINED");
    }
}

