/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ExternalNodeRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemAvailableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemControlRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SupportSystemManager {
    private final Rbs rbs;
    private final MoInstance equipmentSupportFunctionMoi;
    private SupportSystemAvailableRI supportSystemAvailableRI;
    private SupportSystemControlRI supportSystemControlRI;
    private final boolean supportSystemAvailable;
    private final boolean configureSupportSystemMandatory;
    private final int defaultNumberOfExternalNodesIfSecondary;
    private List externalNodeRis = new ArrayList();

    public SupportSystemManager(Rbs rbs, boolean bl, boolean bl2, int n) {
        this.rbs = rbs;
        this.supportSystemAvailable = bl;
        this.configureSupportSystemMandatory = bl2;
        this.equipmentSupportFunctionMoi = new SingleChildMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "1");
        this.defaultNumberOfExternalNodesIfSecondary = n;
    }

    public void createAllRIs() throws BemException {
        this.supportSystemAvailableRI = new SupportSystemAvailableRI(this.rbs, this.supportSystemAvailable);
        this.supportSystemControlRI = new SupportSystemControlRI(this.rbs, this.equipmentSupportFunctionMoi);
        for (int i = 0; i < this.defaultNumberOfExternalNodesIfSecondary; ++i) {
            ExternalNodeRI externalNodeRI = new ExternalNodeRI(this.rbs, i + 1);
            this.externalNodeRis.add(externalNodeRI);
        }
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.supportSystemAvailableRI);
        arrayList.add(this.supportSystemControlRI);
        this.addExternalNodeRisIfNeeded(arrayList);
        return arrayList;
    }

    public ArrayList getRIsToUninstall() throws BemException {
        ArrayList<SupportSystemControlRI> arrayList = new ArrayList<SupportSystemControlRI>();
        this.addExternalNodeRisToDelete(arrayList);
        if (this.supportSystemControlRI != null) {
            arrayList.add(this.supportSystemControlRI);
        }
        return arrayList;
    }

    public String getLoadedValue() throws BemException {
        String string = "TRUE";
        String string2 = this.equipmentSupportFunctionMoi.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        try {
            Boolean bl;
            if (bemMo.isExisting() && (bl = (Boolean)moHandler.getAttribute(bemMo, "supportSystemControl")) != null) {
                string = bl.booleanValue() ? "TRUE" : "FALSE";
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return string;
    }

    public boolean isConfigureSupportSystemMandatory() {
        return this.configureSupportSystemMandatory;
    }

    protected boolean isSupportSystemControlInstalled() throws BemException {
        return this.supportSystemControlRI.isInstalled();
    }

    public boolean isSupportSystemAvailable() {
        return this.supportSystemAvailable;
    }

    private void addExternalNodeRisIfNeeded(List list) throws BemException {
        if (this.defaultNumberOfExternalNodesIfSecondary > 0 && this.supportSystemControlRI.getConfiguredSupportSystemControlValue().equals("FALSE") && (this.rbs.getRbsStep().equals("STEP_CABINET") || this.rbs.getRbsStep().equals("STEP_EXPANSION"))) {
            list.addAll(this.externalNodeRis);
        }
    }

    private void addExternalNodeRisToDelete(List list) throws BemException {
        CustomerParameter customerParameter;
        if (this.defaultNumberOfExternalNodesIfSecondary > 0 && this.rbs.getRbsStep().equals("STEP_EXPANSION") && (customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl")).hasValueChanged() && customerParameter.getValue().equals("TRUE")) {
            list.addAll(this.externalNodeRis);
        }
    }
}

