/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class EcBusRI
extends AbstractResourceItem {
    private static final String NAME = "EcBus";
    private static final String[] myInstallationPhases = new String[]{"CommonPowerSystemCreationPhase", "HwUnitDbControlledDeletionPhase"};
    private static final String CONNECTION_UNIT_IRU = "IRU";
    private String ecBusLdn;
    private String connectionType;
    private String connectorUnitType;
    private String connectionRefLdn;
    private String ecBusNo = "##UNDEFINED";
    private int ecBusNumber;

    public EcBusRI(Rbs rbs, int n, String string) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.ecBusNumber = n;
        MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(n));
        this.ecBusNumber = n;
        this.ecBusLdn = fixedRdnMoi.getLdn();
        this.connectionType = string;
    }

    public EcBusRI(Rbs rbs, int n, String string, String string2) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(n));
        this.ecBusLdn = fixedRdnMoi.getLdn();
        this.ecBusNumber = n;
        this.connectionType = string;
        this.connectorUnitType = string2;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            NalObject nalObject;
            Object object;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            if (!this.getEcBusNo().equals("##UNDEFINED")) {
                object = this.rbs.getMoiRefs().getEquipmentMoi();
                FixedRdnMoi fixedRdnMoi = new FixedRdnMoi((MoInstance)object, MimEcBus.MOTYPENAME, String.valueOf(this.getEcBusNo()));
                this.ecBusLdn = fixedRdnMoi.getLdn();
            }
            object = super.getMo(this.ecBusLdn);
            boolean bl = object.isExisting();
            if (null != this.getConnectorUnitType() && this.getConnectorUnitType().equals(CONNECTION_UNIT_IRU)) {
                nalObject = Nal.getFactory().getNameValue("ecBusConnectorRef", this.getEcBusConnectorRef4IRU());
                vector.add((NalNameValue)nalObject);
            } else {
                nalObject = Nal.getFactory().getNameValue("ecBusConnectorRef", this.getEcBusConnectorRef());
                vector.add((NalNameValue)nalObject);
            }
            vector.add(Nal.getFactory().getNameValue("connectionType", this.getConnectionType()));
            if (!bl) {
                super.create((BemMo)object, vector);
            } else if (!(null != this.getConnectorUnitType() && this.getConnectorUnitType().equals(CONNECTION_UNIT_IRU) || this.getEcBusConnectorRef() == null || this.getEcBusConnectorRef().getDN().indexOf(MimAuxPlugInUnit.MOTYPENAME) == -1)) {
                nalObject = this.rbs.getMoHandler().getMo(this.getEcBusConnectorRef().getDN());
                this.setAttribute((BemMo)object, "ecBusConnectorRef", (Object)nalObject);
            } else {
                super.setAttributes((BemMo)object, vector);
            }
        }
    }

    public void updateLoadedValues() throws BemException {
        String string;
        BemMo bemMo = super.getMo(this.ecBusLdn);
        boolean bl = super.isExisting(bemMo);
        if (bl && (string = (String)bemMo.getAttribute("connectionType")).equals("EC")) {
            String string2 = MessageFormat.format("EcBus{0}_", new Integer(this.ecBusNumber));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "ecBusNumber");
            integerParameter.setLoadedValue(new Integer(this.ecBusNumber));
            IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber");
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("ecBusConnectorRef");
            if (bemMo2.getType().equals(MimAuxPlugInUnit.MOTYPENAME)) {
                String string3 = bemMo2.getLastRDN();
                String string4 = string3.substring(string3.indexOf("-") + 1, string3.indexOf("-", string3.indexOf("-") + 1));
                integerParameter2.setLoadedValue(string4);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            BemMo[] bemMoArray = this.getEcBusReservedByObjects();
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    super.deleteMoIfExisting(bemMoArray[i].getDN());
                }
            }
            super.deleteMoIfExisting(this.ecBusLdn);
        }
    }

    private BemMo getEcBusConnectorRef() {
        String string = DuwUtil.getPrimaryDuwPiuLdn();
        BemMo bemMo = super.getMo(string);
        return bemMo;
    }

    public BemMo getEcBusConnectorRef4IRU() throws BemException {
        BemMo bemMo = super.getMo(this.getConnectionRefLdn());
        return bemMo;
    }

    public BemMo[] getEcBusReservedByObjects() throws BemException {
        BemMo bemMo = super.getMo(this.ecBusLdn);
        if (!bemMo.isExisting()) {
            return null;
        }
        return (BemMo[])super.getAttribute(bemMo, "reservedBy");
    }

    private String getConnectionType() {
        return this.connectionType;
    }

    private String getConnectorUnitType() {
        return this.connectorUnitType;
    }

    public String getDisplayName() {
        return "EcBus: " + this.getLdn();
    }

    public String getLdn() {
        return this.ecBusLdn;
    }

    public String getConnectionRefLdn() {
        return this.connectionRefLdn;
    }

    public void setConnectionRefLdn(String string) {
        this.connectionRefLdn = string;
    }

    public String getEcBusNo() {
        return this.ecBusNo;
    }

    public void setEcBusNo(String string) {
        this.ecBusNo = string;
    }
}

