/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPowerSupply;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class PowerSupplyRI
extends AbstractResourceItem {
    private static final String NAME = "PowerSupply";
    private static final String[] myInstallationPhases = new String[]{"CommonPowerSystemCreationPhase"};
    private int cabinetNumber;
    private String ldn = null;
    private String equipmentSupportFunctionLdn;
    private static final NalLog log = Nal.getLog();

    public PowerSupplyRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.equipmentSupportFunctionLdn = moInstance.getLdn();
        this.cabinetNumber = n;
        this.setupMoi(moInstance);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            this.waitForEquipmentSupportFunction();
            MoHandler moHandler = this.rbs.getMoHandler();
            BemMo bemMo = moHandler.getMo(this.equipmentSupportFunctionLdn);
            if (this.isExisting(bemMo)) {
                Vector vector = new Vector();
                this.addCustomerParameterValueToAttrList("multiplePowerSystem", vector);
                PowerSystemUtil.addControlDomainRef(vector, "controlDomainRef", this.cabinetNumber, this.rbs);
                if (this.isExisting(this.ldn)) {
                    String string2 = MessageFormat.format("CAB{0}_", String.valueOf(this.cabinetNumber));
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + "multiplePowerSystem");
                    if (null != customerParameterServer && customerParameterServer.hasValueChanged()) {
                        this.setAttribute(this.ldn, "multiplePowerSystem", customerParameterServer.getValueMom());
                    }
                } else {
                    super.createMoIfNotExisting(this.ldn, vector);
                    super.createMoIfNotExisting(this.ldn);
                }
            } else {
                throw new BemException("", "install()", this.ldn, "Trying to create powersupply, but MO EquipmentSupportFunction does not exist.", null);
            }
        }
    }

    private void addCustomerParameterValueToAttrList(String string, Vector vector) throws BemException {
        String string2 = MessageFormat.format("CAB{0}_", String.valueOf(this.cabinetNumber));
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2 + string);
        if (customerParameterServer != null && customerParameterServer.hasValueChanged()) {
            NalNameValue nalNameValue = null;
            nalNameValue = Nal.getFactory().getNameValue(string, customerParameterServer.getValueMom());
            vector.add(nalNameValue);
        }
    }

    public String getDisplayName() {
        return "PowerSupply: " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }

    private void setupMoi(MoInstance moInstance) throws BemException {
        String string = String.valueOf(this.cabinetNumber);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimPowerSupply.MOTYPENAME, string);
        this.ldn = fixedRdnMoi.getLdn();
    }

    public Object getAttributeValue(String string) throws BemException {
        String string2 = this.getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        Object object = null;
        try {
            object = moHandler.getAttribute(bemMo, string);
        }
        catch (Exception exception) {
            throw new BemException("PowerSupplyManager.getAttribute()", "getAttribute()", string2, null, exception);
        }
        return object;
    }

    private void waitForEquipmentSupportFunction() throws BemException {
        block2: {
            String string = "MO EquipmentSupportFunction: " + this.equipmentSupportFunctionLdn;
            BemMo bemMo = this.getMo(this.equipmentSupportFunctionLdn);
            long l = System.currentTimeMillis() + 240000L;
            do {
                log.nalTrace(6, this.getClass(), string + " Wait until created.");
                boolean bl = this.isExisting(bemMo);
                if (bl) break block2;
                if (l < System.currentTimeMillis()) {
                    log.nalTrace(2, this.getClass(), string + " Timed out before existing!");
                    String string2 = "creating powersupply failed, MO EquipmentSupportFunction does not exist ldn=" + this.equipmentSupportFunctionLdn;
                    throw new BemException(this.getClass() + string2);
                }
                super.delay_ms(500);
            } while (!Thread.currentThread().isInterrupted());
            log.nalTrace(2, this.getClass(), string + " Interupted by user before existing!");
            String string3 = "creating powersupply failed, user interrupted creation of MO ldn=" + this.equipmentSupportFunctionLdn;
            throw new BemException(this.getClass() + string3);
        }
    }
}

