/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractHwUnitWithEcPortRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class SupRI
extends AbstractHwUnitWithEcPortRI {
    public static final String NAME = "SUP";
    private static final String piuTypeProductName = "SUP";
    private static final String piuTypeProductNumber = "SUPSS000";
    static final String[] myInstallationPhases = new String[]{"HwUnitDbControlledCreationPhase", "HwUnitReconfigureProgramPreparePhase", "UnlockAllUnitsPhase", "HwUnitDbControlledDeletionPhase", "LockPhase", "UnlockPhase"};
    private String supNumber;
    private String hwUnitLdn;
    protected FixedRdnMoi hwUnitMoi;

    public SupRI(Rbs rbs, String string) throws BemException {
        super("SUP", rbs, "SUP", piuTypeProductNumber, myInstallationPhases);
        this.supNumber = string;
        this.setSwLoadable(false);
        this.setupMoi();
    }

    public String getDisplayName() {
        return "SUP: " + this.getLdn();
    }

    public String getLdn() {
        return this.hwUnitLdn;
    }

    public String getUnitNumber() {
        return this.supNumber;
    }

    public MoInstance getHwUnitMoi() {
        return this.hwUnitMoi;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            super.install(string);
        }
    }

    protected void createEcPort(String string, String string2, Integer n) throws BemException {
        BemMo bemMo = this.getMo(string);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("hubPosition", string2));
        vector.add(Nal.getFactory().getNameValue("cascadingOrder", n));
        if (DuwUtil.isDualBoxConfiguration(this.rbs.getRbsType())) {
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getMoiRefs().getEquipmentMoi(), MimEcBus.MOTYPENAME, this.supNumber);
            BemMo bemMo2 = this.rbs.getMoHandler().getMo(fixedRdnMoi.getLdn());
            vector.add(Nal.getFactory().getNameValue("ecBusRef", bemMo2));
            if (!this.isExisting(bemMo)) {
                super.createMoIfNotExisting(string, vector);
            } else {
                this.setAttributes(bemMo, vector);
            }
        } else {
            super.createEcPort(string, string2, n);
        }
    }

    private void setupMoi() throws BemException {
        String string = "SUP-" + this.supNumber;
        this.hwUnitMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwUnit.MOTYPENAME, string);
        this.hwUnitLdn = this.hwUnitMoi.getLdn();
    }

    private boolean isCascadingMode() throws BemException {
        BemMo bemMo = this.rbs.getMoHandler().getMo(BemLdn.LDN_CABINET);
        BemMo bemMo2 = this.rbs.getMoHandler().getMo(BemLdn.LDN_CABINET2);
        return DuwUtil.isCascadingSupport(this.rbs.getRbsType()) && bemMo.isExisting() && bemMo2.isExisting();
    }

    public void updateLoadedValues() throws BemException {
        Comparable comparable;
        Object object;
        SingleChildMoi singleChildMoi = new SingleChildMoi(this.getHwUnitMoi(), MimEcPort.MOTYPENAME, "1");
        BemMo bemMo = this.rbs.getMoHandler().getMo(singleChildMoi.getLdn());
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
        CustomerParameterImpl customerParameterImpl = null;
        if (ecPortInfoArray != null && ecPortInfoArray.length > 0 && ecPortInfoArray.length >= Integer.valueOf(this.supNumber)) {
            object = ecPortInfoArray[Integer.valueOf(this.supNumber) - 1];
            customerParameterImpl = ((EcPortInfo)object).getcascadingOrderParameter();
            comparable = ((EcPortInfo)object).getUnitTypeParameter();
            if (!((CustomerParameterImpl)comparable).getValue().equals("DUW")) {
                return;
            }
        }
        if (bemMo.isExisting()) {
            if (null != customerParameterImpl) {
                customerParameterImpl.setLoadedValue((Integer)bemMo.getAttribute("cascadingOrder"));
            }
        } else if (null != customerParameterImpl && this.isCascadingMode()) {
            BemMo[] bemMoArray;
            object = DuwUtil.getDuwPiuLdn(String.valueOf(this.supNumber));
            comparable = this.rbs.getMoHandler().getMo((String)object);
            if (null != comparable && comparable.isExisting() && null != (bemMoArray = comparable.getChildren(1, MimEcPort.MOTYPENAME, "")) && bemMoArray.length != 0) {
                BemMo bemMo2 = bemMoArray[0];
                Integer n = (Integer)bemMo2.getAttribute("cascadingOrder");
                customerParameterImpl.setLoadedValue(n);
            }
        }
    }
}

