/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchPortAdminStateConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchPortPortNoConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchPortPriorityConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchPortSystemPortConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchPortVidConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.LagRefConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.AccessLevel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitchPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOperatingMode;
import se.ericsson.wcdma.rbs.bem.common.moi.ChildWithAttributeValues;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class EthernetSwitchPortRI
extends AbstractResourceItem {
    public static final String name = "EthernetSwitchPortRI";
    private static final String[] phases = new String[]{"EthernetSwitchPortCreationPhase"};
    private MoInstance ethernetSwitchPortMoi;
    private int rdnId = -1;
    private final List pseudoList = new ArrayList();
    private final List vlanMembershipPseudoList = new ArrayList();
    private final EthernetSwitchProvider ethernetSwitchProvider;
    private boolean confOamVlan = false;

    public EthernetSwitchPortRI(Rbs rbs, int n) {
        super(name, rbs, phases);
        this.rdnId = n;
        this.ethernetSwitchProvider = (EthernetSwitchProvider)this.rbs.getProvider(EthernetSwitchProvider.class);
    }

    public List createCustomerParameters() throws BemException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = MessageFormat.format("EthernetSwitchPort_{0}_administrativeState", new Integer(this.rdnId));
        this.pseudoList.add(string);
        Object object = new String[]{"LOCKED", "UNLOCKED"};
        Object object2 = new Enumeration(string, (String[])object);
        Object object3 = new EthernetSwitchPortAdminStateConversion();
        ((CustomerParameterImpl)object2).setMomConverter((MomConverter)object3);
        String string2 = object3.convertToParameterValue(String.valueOf(0));
        ((CustomerParameterImpl)object2).setDefaultValue(string2);
        arrayList.add(object2);
        this.registerCustomerParameter((CustomerParameter)object2);
        string = MessageFormat.format("EthernetSwitchPort_{0}_systemPort", new Integer(this.rdnId));
        this.pseudoList.add(string);
        object = new TrueFalseCustomerParameter(string);
        object2 = new EthernetSwitchPortSystemPortConversion();
        ((CustomerParameterImpl)object).setMomConverter((MomConverter)object2);
        ((CustomerParameterImpl)object).setDefaultValue(MimEthernetSwitchPort.DEFAULT_SYSTEMPORT.toString().toUpperCase());
        arrayList.add(object);
        this.registerCustomerParameter((CustomerParameter)object);
        string = MessageFormat.format("EthernetSwitchPort_{0}_portNo", new Integer(this.rdnId));
        this.pseudoList.add(string);
        object = new IntegerParameter(string, new IntegerRange(MimEthernetSwitchPort.MIN_PORTNO, MimEthernetSwitchPort.MAX_PORTNO));
        object2 = new EthernetSwitchPortPortNoConversion();
        ((CustomerParameterImpl)object).setMomConverter((MomConverter)object2);
        object3 = String.valueOf(this.rdnId);
        ((CustomerParameterImpl)object).setDefaultValue((String)object3);
        arrayList.add(object);
        this.registerCustomerParameter((CustomerParameter)object);
        if (this.confOamVlan) {
            this.createCustomerParametersForVlanMembership();
        }
        string = MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressVid", new Integer(this.rdnId));
        this.pseudoList.add(string);
        object = new IntegerParameter(string, new IntegerRange(MimEthernetSwitchPort.MIN_UNTAGGEDINGRESSVID, MimEthernetSwitchPort.MAX_UNTAGGEDINGRESSVID));
        object2 = new EthernetSwitchPortVidConversion();
        ((CustomerParameterImpl)object).setMomConverter((MomConverter)object2);
        object3 = MimEthernetSwitchPort.DEFAULT_UNTAGGEDINGRESSVID.toString();
        if (this.confOamVlan) {
            object3 = "900";
        }
        ((CustomerParameterImpl)object).setDefaultValue((String)object3);
        arrayList.add(object);
        this.registerCustomerParameter((CustomerParameter)object);
        string = MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressPriority", new Integer(this.rdnId));
        this.pseudoList.add(string);
        object = new IntegerParameter(string, new IntegerRange(MimEthernetSwitchPort.MIN_UNTAGGEDINGRESSPRIORITY, MimEthernetSwitchPort.MAX_UNTAGGEDINGRESSPRIORITY));
        object2 = new EthernetSwitchPortPriorityConversion();
        ((CustomerParameterImpl)object).setMomConverter((MomConverter)object2);
        object3 = MimEthernetSwitchPort.DEFAULT_UNTAGGEDINGRESSPRIORITY.toString();
        ((CustomerParameterImpl)object).setDefaultValue((String)object3);
        arrayList.add(object);
        this.registerCustomerParameter((CustomerParameter)object);
        string = MessageFormat.format("EthernetSwitchPort_{0}_lagId", new Integer(this.rdnId));
        this.pseudoList.add(string);
        object = this.ethernetSwitchProvider.getLagIdRestriction();
        object2 = new Enumeration(string, new EnumeratedRange(""));
        ((CustomerParameterImpl)object2).addRestriction((ParameterRestriction)object);
        object3 = new LagRefConversion(this.ethernetSwitchProvider);
        ((CustomerParameterImpl)object2).setMomConverter((MomConverter)object3);
        arrayList.add(object2);
        ((CustomerParameterImpl)object2).setDefaultValue("##UNDEFINED");
        this.registerCustomerParameter((CustomerParameter)object2);
        return arrayList;
    }

    private void createCustomerParametersForVlanMembership() throws BemException {
        String string = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_action", new Integer(this.rdnId), "900");
        this.ethernetSwitchProvider.createCP(string, "ADD_MODIFY");
        string = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_vid", new Integer(this.rdnId), "900");
        this.ethernetSwitchProvider.createCP(string, "900");
        string = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_egressUntag", new Integer(this.rdnId), "900");
        this.ethernetSwitchProvider.createCP(string, "TRUE");
    }

    public void initiateCPWithNodeValues() throws BemException {
        boolean bl = this.isExisting(this.ethernetSwitchPortMoi.getLdn());
        if (bl) {
            BemMo bemMo = this.getMo(this.ethernetSwitchPortMoi.getLdn());
            String[] stringArray = new String[this.pseudoList.size() + 1];
            CustomerParameterServer[] customerParameterServerArray = new CustomerParameterServer[this.pseudoList.size()];
            Iterator iterator = this.pseudoList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameterServer customerParameterServer = this.getCustomerParameterServer(string);
                stringArray[n] = customerParameterServer.getAttributeName();
                customerParameterServerArray[n] = customerParameterServer;
                ++n;
            }
            stringArray[customerParameterServerArray.length] = "vlanMembership";
            Object[] objectArray = this.getAttributes(bemMo, stringArray);
            for (int i = 0; customerParameterServerArray.length > i; ++i) {
                customerParameterServerArray[i].setLoadedValue(objectArray[i]);
            }
            NalStruct[] nalStructArray = (NalStruct[])objectArray[customerParameterServerArray.length];
            for (int i = 0; i < nalStructArray.length && nalStructArray[0] != null; ++i) {
                NalStruct nalStruct = nalStructArray[i];
                NalNameValue nalNameValue = nalStruct.getMember("egressUntag");
                NalNameValue nalNameValue2 = nalStruct.getMember("vid");
                String string = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", new Integer(this.rdnId));
                Integer n2 = (Integer)nalNameValue2.getValue();
                Boolean bl2 = (Boolean)nalNameValue.getValue();
                if (n2 == 0) break;
                CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP(string + "_" + n2 + "_vid", n2.toString());
                customerParameterImpl.setLoadedValue(n2);
                CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP(string + "_" + n2 + "_egressUntag", bl2.toString().toUpperCase());
                customerParameterImpl2.setLoadedValue(bl2);
                CustomerParameterImpl customerParameterImpl3 = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP(string + "_" + n2 + "_action", "ADD_MODIFY");
                customerParameterImpl3.setLoadedValue("ADD_MODIFY");
            }
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("EthernetSwitchPortCreationPhase")) {
            this.installEthernetSwitchPort();
        }
    }

    private void installEthernetSwitchPort() throws BemException {
        BemMo bemMo = this.getMo(this.ethernetSwitchPortMoi.getLdn());
        boolean bl = this.isExisting(bemMo);
        if (!bl) {
            Object object;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            Object object2 = "operatingMode";
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("autoNegotiation", MimOperatingMode.DEFAULT_AUTONEGOTIATION), Nal.getFactory().getNameValue("configuredSpeedDuplex", MimOperatingMode.DEFAULT_CONFIGUREDSPEEDDUPLEX)};
            Object object3 = Nal.getFactory().getStruct(nalNameValueArray);
            vector.add(Nal.getFactory().getNameValue((String)object2, object3));
            for (String string : this.pseudoList) {
                object = this.rbs.getCustomerParameterServerObject(string);
                boolean bl2 = object.hasValueChanged();
                if (!bl2) continue;
                object2 = object.getAttributeName();
                object3 = object.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object2, object3));
            }
            if (this.vlanMembershipPseudoList.size() > 0) {
                Collections.sort(this.vlanMembershipPseudoList);
                object2 = this.vlanMembershipPseudoList.iterator();
                object3 = new ArrayList();
                while (object2.hasNext()) {
                    AccessLevel accessLevel;
                    NalNameValue[] nalNameValueArray2 = new NalNameValue[2];
                    boolean bl3 = false;
                    if (object2.hasNext()) {
                        object = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterObject((String)object);
                        bl3 = accessLevel.getValue().equals("DELETE");
                    }
                    if (object2.hasNext()) {
                        object = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject((String)object);
                        nalNameValueArray2[0] = Nal.getFactory().getNameValue("egressUntag", accessLevel.getValueMom());
                    }
                    if (object2.hasNext()) {
                        object = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject((String)object);
                        nalNameValueArray2[1] = Nal.getFactory().getNameValue("vid", accessLevel.getValueMom());
                    }
                    if (bl3) continue;
                    object3.add(Nal.getFactory().getStruct(nalNameValueArray2));
                }
                vector.add(Nal.getFactory().getNameValue("vlanMembership", object3.toArray(new NalStruct[1])));
            }
            this.create(bemMo, vector);
        } else if (!this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            NalNameValue[] nalNameValueArray;
            Object object;
            Object object4;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string : this.pseudoList) {
                object4 = this.rbs.getCustomerParameterServerObject(string);
                boolean bl4 = object4.hasValueChanged();
                if (!bl4) continue;
                object = object4.getAttributeName();
                nalNameValueArray = object4.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object, nalNameValueArray));
            }
            boolean bl5 = false;
            if (this.vlanMembershipPseudoList.size() > 0) {
                Collections.sort(this.vlanMembershipPseudoList);
                object4 = this.vlanMembershipPseudoList.iterator();
                object = new ArrayList();
                while (object4.hasNext()) {
                    boolean bl6;
                    AccessLevel accessLevel;
                    String string;
                    nalNameValueArray = new NalNameValue[2];
                    boolean bl7 = false;
                    if (object4.hasNext()) {
                        string = (String)object4.next();
                        accessLevel = this.rbs.getCustomerParameterObject(string);
                        bl6 = accessLevel.hasValueChanged();
                        if (bl6) {
                            bl5 = bl6;
                        }
                        bl7 = accessLevel.getValue().equals("DELETE");
                    }
                    if (object4.hasNext()) {
                        string = (String)object4.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        nalNameValueArray[0] = Nal.getFactory().getNameValue("egressUntag", accessLevel.getValueMom());
                        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                        boolean bl8 = customerParameter.hasValueChanged();
                        if (bl8) {
                            bl5 = bl8;
                        }
                    }
                    if (object4.hasNext()) {
                        string = (String)object4.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        bl6 = accessLevel.hasValueChanged();
                        if (bl6) {
                            bl5 = bl6;
                        }
                        nalNameValueArray[1] = Nal.getFactory().getNameValue("vid", accessLevel.getValueMom());
                    }
                    if (bl7) continue;
                    object.add(Nal.getFactory().getStruct(nalNameValueArray));
                }
                if (object.size() > 0) {
                    if (bl5) {
                        vector.add(Nal.getFactory().getNameValue("vlanMembership", object.toArray(new NalStruct[1])));
                    }
                } else {
                    nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("egressUntag", false), Nal.getFactory().getNameValue("vid", new Integer(0))};
                    object.add(Nal.getFactory().getStruct(nalNameValueArray));
                    vector.add(Nal.getFactory().getNameValue("vlanMembership", object.toArray(new NalStruct[1])));
                }
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        if (this.ethernetSwitchPortMoi == null) {
            return null;
        }
        try {
            return this.ethernetSwitchPortMoi.getLdn();
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + "getLdn()");
            return null;
        }
    }

    public String getDisplayName() {
        return name;
    }

    public void checkConsistency() throws BemException {
        Iterator iterator = this.pseudoList.iterator();
        Iterator iterator2 = this.vlanMembershipPseudoList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = (String)e;
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            String string2 = customerParameter.getName();
            String string3 = customerParameter.getValue();
            if (!string2.endsWith("untaggedIngressVid")) continue;
            if (string3.equals(MimEthernetSwitchPort.DEFAULT_UNTAGGEDINGRESSVID.toString())) {
                bl = true;
                break;
            }
            CustomerParameter customerParameter2 = null;
            CustomerParameter customerParameter3 = null;
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                String string4 = (String)e2;
                CustomerParameter customerParameter4 = this.rbs.getCustomerParameterObject(string4);
                String string5 = customerParameter4.getName();
                if (string5.endsWith(string3 + "_action")) {
                    customerParameter3 = customerParameter4;
                }
                if (!string5.endsWith(string3 + "_vid")) continue;
                customerParameter2 = customerParameter4;
            }
            if (customerParameter2 != null && string3.equals(customerParameter2.getValue())) {
                if (customerParameter3 == null) {
                    bl = true;
                } else if (!customerParameter3.getValue().equals("DELETE")) {
                    bl = true;
                }
            }
            if (bl) continue;
            throw new BemException(this.getName(), "Check consistency of Untagged VID:" + string3 + ". The untaggedIngressVid has no VLAN membership", this.getLdn(), string, new IllegalArgumentException("The untaggedIngressVid has no VLAN membership"));
        }
    }

    public void addPseudo(String string) {
        this.vlanMembershipPseudoList.add(string);
    }

    public void removePseudo(String string) {
        this.vlanMembershipPseudoList.remove(string);
    }

    public void setEthernetSwitch(MoInstance moInstance) {
        this.ethernetSwitchPortMoi = new ChildWithAttributeValues(moInstance, MimEthernetSwitchPort.MOTYPENAME, "portNo", new Integer(this.rdnId), String.valueOf(this.rdnId));
    }

    public boolean pseudoIsExisting(String string) {
        boolean bl = false;
        for (String string2 : this.vlanMembershipPseudoList) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setConfOamVlan(boolean bl) {
        this.confOamVlan = bl;
    }
}

