/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class VpMcrParameter
extends IntegerParameter
implements CustomerParameterListener {
    private static final String RESTRICTION_REASON = "Not allowed VP MCR value";
    private static final String DEFAULT = "0";
    private static final int MIN_VALUE = 20;
    private ParameterRestriction aRestriction = null;

    public VpMcrParameter(String string) throws BemException {
        this(string, new IntegerRange(0, Integer.MAX_VALUE));
    }

    public VpMcrParameter(String string, IntegerRange integerRange) throws BemException {
        super(string, integerRange);
        this.createDefaultRestriction();
        this.setDefaultValue(DEFAULT);
    }

    private void createDefaultRestriction() {
        this.aRestriction = new ParameterRestriction(RESTRICTION_REASON, super.getSupportedValueRange(), true);
        super.addRestriction(this.aRestriction);
    }

    public ParameterRestriction getRestriction() {
        return this.aRestriction;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if ((parameterEvent.isValueChanged() || parameterEvent.isRangeChanged()) && customerParameter instanceof VpMcrParameter) {
            ParameterRange parameterRange = customerParameter.getEnabledValueRange();
            String string = customerParameter.getValue();
            this.aRestriction.setRange(parameterRange, true);
            this.setValue(string);
        }
    }

    public int getMinValue() {
        return 20;
    }
}

