/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.CpriBasedSyncAdminStateConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.networksync.SyncRiPortCandidateConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeGroupSyncMember;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class CpriBasedSyncRI
extends AbstractResourceItem {
    public static final String name = "CpriBasedSyncRI";
    private static final String[] phases = new String[]{"CpriBasedSyncCreationPhase"};
    private final String ldn;
    private static final String[] ADMINISTRATIVE_STATE_RANGE = new String[]{"LOCKED", "UNLOCKED"};
    private static final String[] SYNC_NODE_PRIORITY_RANGE = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"};
    private static String[] allowedPortRangeSingleDuw = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU1_F"};
    private static String[] allowedPortRangeDualDuw = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E"};
    private static String[] allowedPortRangeDBB22 = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU2_A", "BU2_B", "BU2_C", "BU2_D"};
    private static final int SYNC_RI_PORT_CANDIDATE_LENGTH_SINGLE_DUW = 9;
    private static final int SYNC_RI_PORT_CANDIDATE_LENGTH_DUAL_DUW = 16;
    protected YesNoCustomerParameter confCpriBasedSyncParam;
    private DbbManager dbbManager;

    public CpriBasedSyncRI(Rbs rbs) throws BemException {
        super(name, rbs, phases);
        MoInstance moInstance = this.rbs.getMoiRefs().getSynchronizationMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimNodeGroupSyncMember.MOTYPENAME, "1");
        this.ldn = singleChildMoi.getLdn();
    }

    public List createCustomerParameters() throws BemException {
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        this.confCpriBasedSyncParam = new YesNoCustomerParameter("configureCpriBasedSync");
        this.confCpriBasedSyncParam.setDefaultValue("YES");
        arrayList.add(this.confCpriBasedSyncParam);
        this.registerCustomerParameter(this.confCpriBasedSyncParam);
        Enumeration enumeration = new Enumeration("administrativeState", ADMINISTRATIVE_STATE_RANGE);
        String[] stringArray = new CpriBasedSyncAdminStateConversion();
        enumeration.setMomConverter((MomConverter)stringArray);
        String string = stringArray.convertToParameterValue(new Integer(0));
        enumeration.setDefaultValue(string);
        arrayList.add(enumeration);
        this.registerCustomerParameter(enumeration);
        enumeration = new Enumeration("syncNodePriority", SYNC_NODE_PRIORITY_RANGE);
        arrayList.add(enumeration);
        this.registerCustomerParameter(enumeration);
        SyncRiPortCandidateConversion syncRiPortCandidateConversion = new SyncRiPortCandidateConversion();
        stringArray = allowedPortRangeSingleDuw;
        int n = 9;
        this.dbbManager = new DbbManager(this.rbs);
        boolean bl = this.dbbManager.isTwoCpriLinkInstalled();
        if (DuwUtil.hasDualDuws()) {
            stringArray = allowedPortRangeDualDuw;
            n = 16;
        }
        if (bl) {
            stringArray = allowedPortRangeDBB22;
            n = 16;
        }
        EnumeratedRange enumeratedRange = new EnumeratedRange(stringArray);
        ListRange listRange = new ListRange(enumeratedRange);
        ListParameter listParameter = new ListParameter("syncRiPortCandidate", listRange, 1, n, false, true);
        listParameter.setMomConverter(syncRiPortCandidateConversion);
        arrayList.add(listParameter);
        this.registerCustomerParameter(listParameter);
        return arrayList;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.ldn;
    }

    public void install(String string) throws BemException {
        if (string.equals("CpriBasedSyncCreationPhase")) {
            this.updateNodeGroupSyncMemberMoIfNeeded();
        }
    }

    private void updateNodeGroupSyncMemberMoIfNeeded() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        boolean bl = this.isExisting(bemMo);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        if (this.confCpriBasedSyncParam.getValue().equals("YES")) {
            Object object;
            Object object2;
            Object object3 = this.rbs.getCustomerParameterServerObject("administrativeState");
            boolean bl2 = object3.hasValueChanged();
            if (bl2) {
                object2 = object3.getAttributeName();
                object = object3.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object2, object));
            }
            if (bl2 = (object3 = this.rbs.getCustomerParameterServerObject("syncNodePriority")).hasValueChanged()) {
                object2 = "syncNodePriority";
                object = (String)object3.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object2, Integer.valueOf((String)object)));
            }
            object3 = "syncRiPortCandidate";
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("syncRiPortCandidate");
            object2 = customerParameterServer.getValueMom();
            boolean bl3 = customerParameterServer.hasValueChanged();
            if (bl3) {
                vector.add(Nal.getFactory().getNameValue((String)object3, ((ArrayList)object2).toArray(new NalStruct[1])));
            }
            if (!bl) {
                this.create(bemMo, vector);
            } else if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        } else if (bl) {
            this.delete(bemMo);
        }
    }

    public void initiateCPWithNodeValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            if (this.confCpriBasedSyncParam != null) {
                this.confCpriBasedSyncParam.setLoadedValue("YES");
            }
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("administrativeState");
            Integer n = (Integer)this.getAttribute(bemMo, "administrativeState");
            if (customerParameterServer != null) {
                customerParameterServer.setLoadedValue(n);
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject("syncNodePriority");
            Integer n2 = (Integer)this.getAttribute(bemMo, "syncNodePriority");
            customerParameterServer.setLoadedValue(n2);
            customerParameterServer = this.rbs.getCustomerParameterServerObject("syncRiPortCandidate");
            Object object = this.getAttribute(bemMo, "syncRiPortCandidate");
            customerParameterServer.setLoadedValue(object);
        } else if (this.confCpriBasedSyncParam != null) {
            this.confCpriBasedSyncParam.setLoadedValue("NO");
        }
    }

    boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        String string = this.rbs.getRbsStep();
        if (string.equals("STEP_OAM") || string.equals("STEP_EXPANSION")) {
            CustomerParameter customerParameter = this.getCustomerParameter("administrativeState");
            CustomerParameter customerParameter2 = this.getCustomerParameter("syncNodePriority");
            CustomerParameter customerParameter3 = this.getCustomerParameter("syncRiPortCandidate");
            if (!customerParameter2.getValue().equals("##UNDEFINED") && !customerParameter3.getValue().equals("##UNDEFINED")) {
                if (this.confCpriBasedSyncParam.hasValueChanged()) {
                    bl = true;
                } else if (this.confCpriBasedSyncParam.getValue().equals("YES") && (customerParameter.hasValueChanged() || customerParameter2.hasValueChanged() || customerParameter3.hasValueChanged())) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    void checkConsistency() throws BemException {
        CustomerParameter customerParameter = this.getCustomerParameter("syncNodePriority");
        CustomerParameter customerParameter2 = this.getCustomerParameter("syncRiPortCandidate");
        if (this.confCpriBasedSyncParam.getValue() != null && this.confCpriBasedSyncParam.getValue().equals("YES")) {
            if (customerParameter.getValue() == null || customerParameter.getValue().equals("") || customerParameter.getValue().equals("##UNDEFINED")) {
                throw new BemException("No SyncNodePriority is set! ");
            }
            if (customerParameter2.getValue() == null || customerParameter2.getValue().equals("") || customerParameter2.getValue().equals("##UNDEFINED")) {
                throw new BemException("No SyncRiPortCandidate is set!");
            }
        }
    }
}

