/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AbstractConfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.AtfProviderInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationCableData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.AbstractRadioEquipmentCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.AiuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.BbSubrackFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.BbifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.GammaCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.HiPowTxCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.IntJumperCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.InterSubTimingCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.IntraCabTimingCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.LoPowTxCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.RfSubrackFanRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.RfifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.TrxRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.TrxRfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConnectionField;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTrxRfCable;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractRbs3Configuration
extends AbstractConfiguration {
    private static final int FIRST = 0;
    private static final int SECOND = 1;
    private static final String LEFT_TO_RIGHT_ERROR = "Equipment within a sector must be installed from left to right.";
    private AiuRI aiu;
    private TrxRI[] trx = new TrxRI[2];
    private McpaRI[] mcpa = new McpaRI[2];
    private RfifRI[] rfif = new RfifRI[2];
    private BbifRI[] bbif = new BbifRI[2];
    private McpaSubrackRI mcpaSubrack;
    private McpaFanRI mcpaFan;
    private BbSubrackFanRI bbFan;
    private RfSubrackFanRI rfFan;
    private String connectionFieldLdn;
    private ConfigurationData configurationData;
    private ConfigurationCableData configurationCableData;
    AtfProviderInfo[] atfReferences = null;
    Rbs rbs;

    public AbstractRbs3Configuration(String string, Rbs rbs, int n, int n2, String string2, int n3, ConfigurationData configurationData, ConfigurationCableData configurationCableData) throws BemException {
        super(string, n, n2, string2, n3);
        this.rbs = rbs;
        this.configurationData = configurationData;
        this.configurationCableData = configurationCableData;
        this.createResourceItems(configurationData);
        this.getConnectionFieldLdn();
    }

    public List getResourceItems() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getSubrackResourceItems());
        arrayList.addAll(this.getBoardResourceItems());
        arrayList.addAll(this.getCableResourceItems());
        return arrayList;
    }

    public List getResourceItemsToUninstall() throws BemException {
        ArrayList<ResourceItem> arrayList = new ArrayList<ResourceItem>();
        List list = this.getResourceItems();
        for (ResourceItem resourceItem : list) {
            if (resourceItem instanceof BbifRI || resourceItem instanceof RfifRI || resourceItem instanceof GammaCableRI || resourceItem instanceof IntraCabTimingCableRI || resourceItem instanceof InterSubTimingCableRI || resourceItem instanceof McpaSubrackRI || resourceItem instanceof McpaFanRI || resourceItem instanceof BbSubrackFanRI || resourceItem instanceof RfSubrackFanRI) continue;
            arrayList.add(resourceItem);
        }
        return arrayList;
    }

    protected List getRfif_BbifCables1() throws BemException {
        ArrayList<AbstractRadioEquipmentCableRI> arrayList = new ArrayList<AbstractRadioEquipmentCableRI>();
        RfifRI rfifRI = this.getRfif1();
        BbifRI bbifRI = this.getBbif1();
        GammaCableRI gammaCableRI = new GammaCableRI(this.rbs, bbifRI.getLdn(), this.getGammaCable1Connector(), rfifRI.getPiuLdn(), this.getGammaCable1Connector(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(gammaCableRI);
        GammaCableRI gammaCableRI2 = new GammaCableRI(this.rbs, bbifRI.getLdn(), this.getGammaCable2Connector(), rfifRI.getPiuLdn(), this.getGammaCable2Connector(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(gammaCableRI2);
        InterSubTimingCableRI interSubTimingCableRI = new InterSubTimingCableRI(this.rbs, rfifRI.getPiuLdn(), this.getInterSubTimingCableRfifConnector(), bbifRI.getLdn(), this.getInterSubTimingCableBbifConnector(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(interSubTimingCableRI);
        IntraCabTimingCableRI intraCabTimingCableRI = new IntraCabTimingCableRI(this.rbs, rfifRI.getPiuLdn(), this.getIntraCabTimingCableRfifConnector(), bbifRI.getLdn(), this.getIntraCabTimingCableBbifConnector(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(intraCabTimingCableRI);
        return arrayList;
    }

    protected List getRfif_BbifCables2() throws BemException {
        ArrayList<AbstractRadioEquipmentCableRI> arrayList = new ArrayList<AbstractRadioEquipmentCableRI>();
        RfifRI rfifRI = this.getRfif2();
        BbifRI bbifRI = this.getBbif2();
        GammaCableRI gammaCableRI = new GammaCableRI(this.rbs, bbifRI.getLdn(), this.getGammaCable1Connector(), rfifRI.getPiuLdn(), this.getGammaCable1Connector(), 3, this.configurationCableData, this.getOutputPower());
        arrayList.add(gammaCableRI);
        GammaCableRI gammaCableRI2 = new GammaCableRI(this.rbs, bbifRI.getLdn(), this.getGammaCable2Connector(), rfifRI.getPiuLdn(), this.getGammaCable2Connector(), 4, this.configurationCableData, this.getOutputPower());
        arrayList.add(gammaCableRI2);
        InterSubTimingCableRI interSubTimingCableRI = new InterSubTimingCableRI(this.rbs, rfifRI.getPiuLdn(), this.getInterSubTimingCableRfifConnector(), bbifRI.getLdn(), this.getInterSubTimingCableBbifConnector(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(interSubTimingCableRI);
        IntraCabTimingCableRI intraCabTimingCableRI = new IntraCabTimingCableRI(this.rbs, rfifRI.getPiuLdn(), this.getIntraCabTimingCableRfifConnector(), bbifRI.getLdn(), this.getIntraCabTimingCableBbifConnector(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(intraCabTimingCableRI);
        return arrayList;
    }

    protected List getLoHiPowTxCables1() throws BemException {
        ArrayList<AbstractRadioEquipmentCableRI> arrayList = new ArrayList<AbstractRadioEquipmentCableRI>();
        McpaRI mcpaRI = this.getMcpa1();
        LoPowTxCableRI loPowTxCableRI = new LoPowTxCableRI(this.rbs, this.aiu.getPiuLdn(), this.getLoPowTxCable1AiuConnector(), mcpaRI.getAuxPiuLdn(), this.getLoPowTxCable1McpaConnector(), this.getSectorNo(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(loPowTxCableRI);
        HiPowTxCableRI hiPowTxCableRI = new HiPowTxCableRI(this.rbs, this.aiu.getPiuLdn(), this.getHiPowTxCable1AiuConnector(), mcpaRI.getAuxPiuLdn(), this.getHiPowTxCable1McpaConnector(), this.getSectorNo(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(hiPowTxCableRI);
        return arrayList;
    }

    protected List getLoHiPowTxCables2() throws BemException {
        ArrayList<AbstractRadioEquipmentCableRI> arrayList = new ArrayList<AbstractRadioEquipmentCableRI>();
        McpaRI mcpaRI = this.getMcpa2();
        LoPowTxCableRI loPowTxCableRI = new LoPowTxCableRI(this.rbs, this.aiu.getPiuLdn(), this.getLoPowTxCable2AiuConnector(), mcpaRI.getAuxPiuLdn(), this.getLoPowTxCable2McpaConnector(), this.getSectorNo(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(loPowTxCableRI);
        HiPowTxCableRI hiPowTxCableRI = new HiPowTxCableRI(this.rbs, this.aiu.getPiuLdn(), this.getHiPowTxCable2AiuConnector(), mcpaRI.getAuxPiuLdn(), this.getHiPowTxCable2McpaConnector(), this.getSectorNo(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(hiPowTxCableRI);
        return arrayList;
    }

    protected List getTrxRfCable1() throws BemException {
        ArrayList<TrxRfCableRI> arrayList = new ArrayList<TrxRfCableRI>();
        TrxRI trxRI = this.getTrx1();
        TrxRfCableRI trxRfCableRI = new TrxRfCableRI(this.rbs, this.aiu.getPiuLdn(), this.getTrxRfCable1AiuConnector(), trxRI.getPiuLdn(), this.getTrxRfCable1TrxConnector(), this.getSectorNo(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(trxRfCableRI);
        return arrayList;
    }

    protected List getTrxRfCable2() throws BemException {
        ArrayList<TrxRfCableRI> arrayList = new ArrayList<TrxRfCableRI>();
        TrxRI trxRI = this.getTrx2();
        TrxRfCableRI trxRfCableRI = new TrxRfCableRI(this.rbs, this.aiu.getPiuLdn(), this.getTrxRfCable2AiuConnector(), trxRI.getPiuLdn(), this.getTrxRfCable2TrxConnector(), this.getSectorNo(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(trxRfCableRI);
        return arrayList;
    }

    protected List getTrxRfCable3() throws BemException {
        ArrayList<TrxRfCableRI> arrayList = new ArrayList<TrxRfCableRI>();
        TrxRI trxRI = this.getTrx1();
        TrxRfCableRI trxRfCableRI = new TrxRfCableRI(this.rbs, this.aiu.getPiuLdn(), this.getTrxRfCable3AiuConnector(), trxRI.getPiuLdn(), this.getTrxRfCable3TrxConnector(), this.getSectorNo(), 1, this.configurationCableData, this.getOutputPower());
        arrayList.add(trxRfCableRI);
        return arrayList;
    }

    protected List getTrxRfCable4() throws BemException {
        ArrayList<TrxRfCableRI> arrayList = new ArrayList<TrxRfCableRI>();
        TrxRI trxRI = this.getTrx2();
        TrxRfCableRI trxRfCableRI = new TrxRfCableRI(this.rbs, this.aiu.getPiuLdn(), this.getTrxRfCable4AiuConnector(), trxRI.getPiuLdn(), this.getTrxRfCable4TrxConnector(), this.getSectorNo(), 2, this.configurationCableData, this.getOutputPower());
        arrayList.add(trxRfCableRI);
        return arrayList;
    }

    protected List getIntJumperCables() throws BemException {
        ArrayList<IntJumperCableRI> arrayList = new ArrayList<IntJumperCableRI>();
        String string = this.getTerminationObject(null);
        IntJumperCableRI intJumperCableRI = new IntJumperCableRI(this.rbs, this.aiu.getPiuLdn(), this.getIntJumperCable1AiuConnector(), string, this.getConnectionFieldConnector(this.getSectorNo(), MimAntennaBranchDef.BRANCH_A), this.getSectorNo(), MimAntennaBranchDef.BRANCH_A, this.configurationCableData, this.getOutputPower());
        arrayList.add(intJumperCableRI);
        IntJumperCableRI intJumperCableRI2 = new IntJumperCableRI(this.rbs, this.aiu.getPiuLdn(), this.getIntJumperCable2AiuConnector(), string, this.getConnectionFieldConnector(this.getSectorNo(), MimAntennaBranchDef.BRANCH_B), this.getSectorNo(), MimAntennaBranchDef.BRANCH_B, this.configurationCableData, this.getOutputPower());
        arrayList.add(intJumperCableRI2);
        return arrayList;
    }

    protected List getIntJumperCables(boolean bl) throws BemException {
        ArrayList<IntJumperCableRI> arrayList = new ArrayList<IntJumperCableRI>();
        String string = this.getTerminationObject(null);
        IntJumperCableRI intJumperCableRI = new IntJumperCableRI(this.rbs, this.aiu.getPiuLdn(), this.getIntJumperCable1AiuConnector(), string, this.getConnectionFieldConnector(this.getSectorNo(), MimAntennaBranchDef.BRANCH_A), this.getSectorNo(), MimAntennaBranchDef.BRANCH_A, this.configurationCableData, this.getOutputPower());
        if (bl) {
            intJumperCableRI.setBranchForExternalOutputPower();
        }
        arrayList.add(intJumperCableRI);
        IntJumperCableRI intJumperCableRI2 = new IntJumperCableRI(this.rbs, this.aiu.getPiuLdn(), this.getIntJumperCable2AiuConnector(), string, this.getConnectionFieldConnector(this.getSectorNo(), MimAntennaBranchDef.BRANCH_B), this.getSectorNo(), MimAntennaBranchDef.BRANCH_B, this.configurationCableData, this.getOutputPower());
        if (bl) {
            intJumperCableRI2.setBranchForExternalOutputPower();
        }
        arrayList.add(intJumperCableRI2);
        return arrayList;
    }

    private void createResourceItems(ConfigurationData configurationData) throws BemException {
        this.aiu = new AiuRI(this.rbs, configurationData.getAiuSlot(), configurationData.getSubrackForAiu());
        this.trx[0] = new TrxRI(this.rbs, configurationData.getTrxSlot1(), configurationData.getSubrackForTrx());
        int n = configurationData.getTrxSlot2();
        if (n > 0) {
            this.trx[1] = new TrxRI(this.rbs, n, configurationData.getSubrackForTrx());
        }
        this.mcpaSubrack = configurationData.getSubrackForMcpa();
        if (this.mcpaSubrack != null) {
            this.mcpa[0] = this.mcpaSubrack.getSlot(configurationData.getMcpaSlot1());
            n = configurationData.getMcpaSlot2();
            if (n > 0) {
                this.mcpa[1] = this.mcpaSubrack.getSlot(n);
            }
            this.mcpaFan = configurationData.getMcpaFan();
        }
        this.rfif[0] = new RfifRI(this.rbs, configurationData.getRfifSlot1(), configurationData.getSubrackForRfif());
        n = configurationData.getRfifSlot2();
        if (n > 0) {
            this.rfif[1] = new RfifRI(this.rbs, n, configurationData.getSubrackForRfif());
        }
        this.bbif[0] = new BbifRI(this.rbs, configurationData.getBbifSlot1(), configurationData.getSubrackForBbif(), this.rfif[0]);
        n = configurationData.getBbifSlot2();
        if (n > 0) {
            this.bbif[1] = new BbifRI(this.rbs, n, configurationData.getSubrackForBbif(), this.rfif[1]);
        }
        this.bbFan = configurationData.getBbFan();
        this.rfFan = configurationData.getRfFan();
    }

    private void getConnectionFieldLdn() throws BemException {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimConnectionField.MOTYPENAME, "1");
        this.connectionFieldLdn = singleChildMoi.getLdn();
    }

    protected AiuRI getAiu() {
        return this.aiu;
    }

    protected TrxRI getTrx1() {
        return this.trx[0];
    }

    protected TrxRI getTrx2() {
        return this.trx[1];
    }

    protected McpaRI getMcpa1() {
        return this.mcpa[0];
    }

    protected McpaRI getMcpa2() {
        return this.mcpa[1];
    }

    protected RfifRI getRfif1() {
        return this.rfif[0];
    }

    protected RfifRI getRfif2() {
        return this.rfif[1];
    }

    protected BbifRI getBbif1() {
        return this.bbif[0];
    }

    protected BbifRI getBbif2() {
        return this.bbif[1];
    }

    protected McpaSubrackRI getMcpaSubrack() {
        return this.mcpaSubrack;
    }

    public McpaFanRI getMcpaFan() {
        return this.mcpaFan;
    }

    public BbSubrackFanRI getBbFan() {
        return this.bbFan;
    }

    public RfSubrackFanRI getRfFan() {
        return this.rfFan;
    }

    protected boolean isMcpaSubrackInstalled() throws BemException {
        if (this.mcpaSubrack != null) {
            return this.mcpaSubrack.isInstalled();
        }
        return false;
    }

    protected boolean isAiuInstalled() throws BemException {
        if (this.aiu != null) {
            return this.aiu.isInstalled();
        }
        return false;
    }

    protected boolean isAnyRfifInstalled() throws BemException {
        return this.isAnyBoardInstalled(this.rfif[0], this.rfif[1]);
    }

    protected boolean isAnyBbifInstalled() throws BemException {
        return this.isAnyBoardInstalled(this.bbif[0], this.bbif[1]);
    }

    protected boolean isAnyMcpaInstalled() throws BemException {
        return this.isAnyBoardInstalled(this.mcpa[0], this.mcpa[1]);
    }

    protected boolean isBothRfifInstalled() throws BemException {
        return this.isBothBoardsInstalled(this.rfif[0], this.rfif[1]);
    }

    protected boolean isBothBbifInstalled() throws BemException {
        return this.isBothBoardsInstalled(this.bbif[0], this.bbif[1]);
    }

    protected boolean isOneTrxInstalled() throws BemException {
        return this.isOneBoardInstalled(this.trx[0], this.trx[1]);
    }

    protected boolean isOneMcpaInstalled() throws BemException {
        return this.isOneBoardInstalled(this.mcpa[0], this.mcpa[1]);
    }

    protected boolean isBothTrxInstalled() throws BemException {
        return this.isBothBoardsInstalled(this.trx[0], this.trx[1]);
    }

    protected boolean isBothMcpaInstalled() throws BemException {
        return this.isBothBoardsInstalled(this.mcpa[0], this.mcpa[1]);
    }

    private boolean isAnyBoardInstalled(ResourceItem resourceItem, ResourceItem resourceItem2) throws BemException {
        boolean bl = false;
        if (resourceItem != null) {
            bl = resourceItem.isInstalled();
        }
        boolean bl2 = false;
        if (resourceItem2 != null) {
            bl2 = resourceItem2.isInstalled();
        }
        return bl || bl2;
    }

    private boolean isOneBoardInstalled(ResourceItem resourceItem, ResourceItem resourceItem2) throws BemException {
        boolean bl = false;
        if (resourceItem != null) {
            bl = resourceItem.isInstalled();
        }
        boolean bl2 = false;
        if (resourceItem2 != null) {
            bl2 = resourceItem2.isInstalled();
        }
        return BemUtil.xor(bl, bl2);
    }

    private boolean isBothBoardsInstalled(ResourceItem resourceItem, ResourceItem resourceItem2) throws BemException {
        boolean bl = false;
        if (resourceItem != null) {
            bl = resourceItem.isInstalled();
        }
        boolean bl2 = false;
        if (resourceItem2 != null) {
            bl2 = resourceItem2.isInstalled();
        }
        return bl && bl2;
    }

    protected boolean isThirdTrxRfCableInstalled() throws BemException {
        List list = this.getTrxRfCable3();
        Iterator iterator = list.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            String string = resourceItem.getName();
            if (!string.equals(MimTrxRfCable.MOTYPENAME) || !resourceItem.isInstalled()) continue;
            bl = true;
        }
        return bl;
    }

    protected abstract Integer getTrxRfCable1AiuConnector();

    protected Integer getTrxRfCable1TrxConnector() {
        return new Integer(1);
    }

    protected abstract Integer getTrxRfCable2AiuConnector();

    protected abstract Integer getTrxRfCable2TrxConnector();

    protected Integer getTrxRfCable3AiuConnector() {
        return new Integer(3);
    }

    protected Integer getTrxRfCable3TrxConnector() {
        return new Integer(2);
    }

    protected Integer getTrxRfCable4AiuConnector() {
        return new Integer(2);
    }

    protected Integer getTrxRfCable4TrxConnector() {
        return new Integer(1);
    }

    protected Integer getLoPowTxCable1AiuConnector() {
        return new Integer(1);
    }

    protected Integer getLoPowTxCable1McpaConnector() {
        return new Integer(1);
    }

    protected Integer getLoPowTxCable2AiuConnector() {
        return new Integer(2);
    }

    protected Integer getLoPowTxCable2McpaConnector() {
        return new Integer(1);
    }

    protected abstract Integer getHiPowTxCable1AiuConnector();

    protected Integer getHiPowTxCable1McpaConnector() {
        return new Integer(1);
    }

    protected abstract Integer getHiPowTxCable2AiuConnector();

    protected Integer getHiPowTxCable2McpaConnector() {
        return new Integer(1);
    }

    protected Integer getInterSubTimingCableRfifConnector() {
        return new Integer(1);
    }

    protected Integer getInterSubTimingCableBbifConnector() {
        return new Integer(1);
    }

    protected Integer getIntraCabTimingCableRfifConnector() {
        return new Integer(1);
    }

    protected Integer getIntraCabTimingCableBbifConnector() {
        return new Integer(1);
    }

    protected Integer getGammaCable1Connector() {
        return new Integer(1);
    }

    protected Integer getGammaCable2Connector() {
        return new Integer(2);
    }

    protected Integer getIntJumperCable1AiuConnector() {
        return new Integer(1);
    }

    protected Integer getIntJumperCable2AiuConnector() {
        return new Integer(2);
    }

    public String getTerminationObject(String string) throws BemException {
        return this.connectionFieldLdn;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        List list = this.checkBoards();
        list.addAll(this.checkCables());
        return new ConfigurationCheckReport(list);
    }

    private List checkBoards() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.checkLeftToRight(this.bbif[0], this.bbif[1], "BBIF"));
        arrayList.addAll(this.checkLeftToRight(this.rfif[0], this.rfif[1], "RFIF"));
        arrayList.addAll(this.checkLeftToRight(this.trx[0], this.trx[1], "TRX"));
        arrayList.addAll(this.checkLeftToRight(this.mcpa[0], this.mcpa[1], "MCPA"));
        return arrayList;
    }

    private List checkLeftToRight(ResourceItem resourceItem, ResourceItem resourceItem2, String string) throws BemException {
        ArrayList<ReportEntry> arrayList = new ArrayList<ReportEntry>();
        boolean bl = this.isFirstBoardInstalledBeforeSecond(resourceItem, resourceItem2);
        if (!bl) {
            arrayList.add(new ReportEntry("Error", "", string + " in position 2", string + " in position 1", LEFT_TO_RIGHT_ERROR));
        }
        return arrayList;
    }

    private boolean isFirstBoardInstalledBeforeSecond(ResourceItem resourceItem, ResourceItem resourceItem2) throws BemException {
        boolean bl = true;
        boolean bl2 = false;
        if (resourceItem2 != null) {
            bl2 = resourceItem2.isInstalled();
        }
        if (bl2 && resourceItem != null) {
            bl = resourceItem.isInstalled();
        }
        return bl;
    }

    private List checkCables() throws BemException {
        ArrayList<ReportEntry> arrayList = new ArrayList<ReportEntry>();
        List list = this.getCableResourceItems();
        for (ResourceItem resourceItem : list) {
            if (resourceItem.isInstalled()) continue;
            arrayList.add(new ReportEntry("Warning", "", "", "", "Cannot find cable, " + ((Object)resourceItem).toString() + ". "));
        }
        return arrayList;
    }

    protected List getSubrackResourceItems() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        McpaSubrackRI mcpaSubrackRI = this.getMcpaSubrack();
        McpaFanRI mcpaFanRI = this.getMcpaFan();
        BbSubrackFanRI bbSubrackFanRI = this.getBbFan();
        RfSubrackFanRI rfSubrackFanRI = this.getRfFan();
        if (mcpaSubrackRI != null) {
            arrayList.add(mcpaSubrackRI);
        }
        if (mcpaFanRI != null) {
            arrayList.add(mcpaFanRI);
        }
        if (bbSubrackFanRI != null) {
            arrayList.add(bbSubrackFanRI);
        }
        if (rfSubrackFanRI != null) {
            arrayList.add(rfSubrackFanRI);
        }
        return arrayList;
    }

    protected abstract List getBoardResourceItems() throws BemException;

    protected abstract List getCableResourceItems() throws BemException;

    public AtfProviderInfo[] getAtfProviderInfo() {
        if (this.atfReferences != null) {
            return this.atfReferences;
        }
        String string = this.getRfif1().getPiuLdn();
        String string2 = null;
        if (this.getRfif2() != null) {
            string2 = this.getRfif2().getPiuLdn();
        }
        this.atfReferences = new AtfProviderInfo[]{new AtfProviderInfo(AtfProvider.ALL_CONTROLLERS_OF_ASC_INDEXED_BY_SECTOR[this.getSectorNo()], this.aiu.getPiuLdn()), new AtfProviderInfo(AtfProvider.ALL_CONTROLLERS_OF_RET_INDEXED_BY_SECTOR[this.getSectorNo()], this.aiu.getPiuLdn()), new AtfProviderInfo("CONTROLLER_OF_MCPA", string, string2), new AtfProviderInfo("CONTROLLER_OF_FAN_MCPA", string, string2)};
        return this.atfReferences;
    }

    public String getConnectionFieldConnector(int n, String string) throws BemException {
        return this.configurationData.getConnectionFieldConnector(n, string);
    }
}

