/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class RuwRI
extends AbstractRuRI {
    public static final String name = "RUW";
    private static final String PIU_TYPE_PRODUCT_NAME = "RUW";
    private boolean lockSecondAiDevice = false;
    private String auxPiuLdn;
    private String deviceGroupLdn;
    private int slotNumber;
    public static final String AU_TYPE_RUW = "RUW";
    public static final String RUW_RDN_PREFIX = "RUW-";
    private String auxPiuId;
    private int internalCascadeNumber;

    public RuwRI(Rbs rbs, int n, int n2, String string, int n3) {
        super("RUW", rbs, 19, "RUW", string, n3);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RUW");
        this.addRepertoiresToInstall("RBS_RUW");
        this.internalCascadeNumber = n2;
        this.auxPiuId = RUW_RDN_PREFIX + n2;
        this.auxPiuLdn = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + "RUW" + "-" + n + "-" + this.internalCascadeNumber;
        this.deviceGroupLdn = this.auxPiuLdn + "," + MimDeviceGroup.MOTYPENAME + "=" + "RUW";
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("LockPhase") || string.equals("UnlockPhase")) {
            this.lockOrUnlockSecondAiDevice();
        }
    }

    public void setSecondAiLocked(boolean bl) {
        this.lockSecondAiDevice = bl;
    }

    private void lockOrUnlockSecondAiDevice() throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            String string = this.deviceGroupLdn + "," + MimAiDeviceSet.MOTYPENAME + "=1," + MimAiDevice.MOTYPENAME + "=2";
            BemMo bemMo = moHandler.getMo(string);
            Integer n = (Integer)moHandler.getAttribute(bemMo, "administrativeState");
            if (this.lockSecondAiDevice) {
                if (n != null && n == 1) {
                    moHandler.setAttribute(bemMo, "administrativeState", new Integer(0));
                }
            } else if (n != null && n == 0) {
                moHandler.setAttribute(bemMo, "administrativeState", new Integer(1));
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.auxPiuLdn, (Throwable)moHandlerException);
        }
    }

    public String getLdn() {
        return this.deviceGroupLdn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    protected BemMo getAuxPiuMo() throws BemException {
        return this.getMo(this.auxPiuLdn);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getDisplayName() {
        return "RUW:" + this.deviceGroupLdn;
    }

    public void setSlotNumber(String string, int n, int n2, boolean bl) {
        if (bl) {
            this.auxPiuLdn = string + "," + MimRbsSlot.MOTYPENAME + "=" + n + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + this.auxPiuId;
            this.slotNumber = n;
        } else {
            this.auxPiuLdn = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + "RUW" + "-" + n2 + "-" + this.internalCascadeNumber;
        }
        this.deviceGroupLdn = this.auxPiuLdn + "," + MimDeviceGroup.MOTYPENAME + "=" + "RUW";
    }
}

