/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameters;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.DuwPortUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class SectorCustomerParameterManager {
    private SectorCustomerParameters[] scps;
    private int maxSectorNumber;
    private int startingSectorNumber;
    private Rbs rbs;
    private RbbManager rbbmanager;

    public SectorCustomerParameterManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, int n) throws BemException {
        this(rbs, abstractDuwRadioEquipmentCI, rbbManager, n, 1);
    }

    public SectorCustomerParameterManager(Rbs rbs, AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, int n, int n2) throws BemException {
        this.maxSectorNumber = n;
        this.startingSectorNumber = n2;
        this.rbs = rbs;
        this.rbbmanager = rbbManager;
        ArrayList<SectorCustomerParameters> arrayList = new ArrayList<SectorCustomerParameters>();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
            arrayList.add(new SectorCustomerParameters(rbs, abstractDuwRadioEquipmentCI, rbbManager, this, n3));
        }
        this.scps = arrayList.toArray(new SectorCustomerParameters[0]);
    }

    public ArrayList getAllCpPseudoNames() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            ArrayList arrayList2 = this.scps[i].getAllCpPseudoNames();
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    void clearRbbDependentCPs(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n2].clearRbbDependentCPs();
    }

    public void clearSectorDependentCPs(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getRbbNameForSector(n);
        AbstractRbb abstractRbb = this.rbbmanager.getRadioBuildingBlock(n);
        String string2 = abstractRbb.getRadioSharedBySector();
        if ((string.equals("RBB22_1F") || string.equals("RBB22_1G")) && string2 != "") {
            int n3 = Integer.parseInt(string2);
            if (!this.isRRUS32SharedSector(string, n)) {
                AbstractRbb abstractRbb2 = this.rbbmanager.getRadioBuildingBlock(n3);
                abstractRbb2.setResourcItems(abstractRbb.getRadioUnitResourceItems());
            }
            this.clearRadioSharedBySectorValue(n3);
        }
        this.scps[n2].clearSectorDependentCPs();
    }

    public void clearSecondaryPortIdValue(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n2].clearSecondaryPortIdValue();
    }

    public void clearRadioSharedBySectorValue(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n2].clearRadioSharedBySectorValue();
    }

    public void setRadioSharedBySectorValue(int n, String string) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n2].setRadioSharedBySectorValue(string);
    }

    public void clearCabinetNumberValue(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n2].clearCabinetNumberValue();
    }

    public void checkForSectorNumberWithoutLineRate() throws BemException {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            String string;
            String string2 = this.scps[i].getRbbValue();
            if (string2.equals("") || !(string = this.scps[i].getLineRateValue()).equals("")) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            throw new BemException("Sector number " + n + " does not have line rate set.");
        }
    }

    public void setLoadedValues(int n, String string, Integer n2, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws BemException {
        int n3 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        this.scps[n3].setLoadedValues(string, n2, string2, string3, string4, string5, string6, string7, string8);
    }

    public void disableListeners() {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            this.scps[i].disableListeners();
        }
    }

    public void enableListeners() {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            this.scps[i].enableListeners();
        }
    }

    public String getRbbNameForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.scps[n2].getRbbValue();
    }

    public boolean isRbbNameForSectorSet(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.scps[n2].getRbbValue();
        return !string.equals("");
    }

    public String getUntranslatedSectorSequenceForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.scps[n2].getSectorSequenceValue();
    }

    public String getSectorSequenceForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = null;
        string = this.scps[n2].getSectorSequenceValue();
        if (string.equals("")) {
            string = "1";
        }
        return string;
    }

    public String getLineRateForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.scps[n2].getLineRateValue();
    }

    public String getPrimaryPortIdForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = null;
        string = this.needRuPositionAllocation(n) ? DuwPortUtil.getPrimaryPortIdForRuw(n, this.rbs.getRbsType()) : this.scps[n2].getPrimaryPortIdValue();
        return string;
    }

    public String getSecondaryPortIdForSector(int n) {
        return this.getSecondaryPortIdForSectorwithrbb(n, this.getRbbNameForSector(n));
    }

    public String getSecondaryPortIdForSectorwithrbb(int n, String string) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string2 = null;
        string2 = this.needRuPositionAllocation(n) ? DuwPortUtil.getSecondaryPortIdForRuw(n, string, DbbManager.getDbbValue(this.rbs)) : this.scps[n2].getSecondaryPortIdValue();
        return string2;
    }

    public String getAuUnitTypeForSector(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].getAuUnitTypeValue();
    }

    public String getLoadedAuUnitTypeForSector(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].getAuUnitTypeLoadedValue();
    }

    public String getRadioSharedBySectorForSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.needRuPositionAllocation(n) ? "" : this.scps[n2].getRadioSharedBySectorValue();
    }

    public String getCabinetNumberForSector(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].getCabinetNumberValue();
    }

    public boolean isCabinetNumberConfigured(int n) throws BemException {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].isCabinetNumberSet();
    }

    public void checkPortIdAndSectorSeq() throws BemException {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            SectorCustomerParameters sectorCustomerParameters = this.scps[i];
            if (sectorCustomerParameters.isIgnored()) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            if (this.isRRUS32SharedSector(sectorCustomerParameters.getRbbValue(), n)) continue;
            if (sectorCustomerParameters.needRuPositionAllocation()) {
                if (!sectorCustomerParameters.isPrimaryPortIdSet()) continue;
                String string = sectorCustomerParameters.getPrimaryPortIdValue();
                String string2 = this.getSectorSequenceForSector(n);
                this.isPortIdAndSectorSeqUnique(i, string, string2, true);
                continue;
            }
            this.checkPortIdAndSectorSeqAreUnique(i, sectorCustomerParameters);
        }
    }

    public void checkPortIdAndSectorSeqAreUnique(int n, SectorCustomerParameters sectorCustomerParameters) throws BemException {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        if (sectorCustomerParameters.isRbbNameSet() && sectorCustomerParameters.isLineRateSet() && !sectorCustomerParameters.isPrimaryPortIdSet()) {
            throw new BemException("Sector number " + n2 + " does not have a valid primary port id configured.");
        }
        String string = this.getSectorSequenceForSector(n2);
        String string2 = sectorCustomerParameters.getPrimaryPortIdValue();
        String string3 = sectorCustomerParameters.getSecondaryPortIdValue();
        this.isPortIdAndSectorSeqUnique(n, string2, string, true);
        this.isPortIdAndSectorSeqUnique(n, string3, string, false);
    }

    private void isPortIdAndSectorSeqUnique(int n, String string, String string2, boolean bl) throws BemException {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            String string3;
            int n2;
            if (i == n || "".equals(string)) continue;
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
            String string4 = this.getRadioSharedBySectorForSector(n4);
            if (string4 != "" && this.isRRUS32SharedSector(this.getRbbNameForSector(n2 = Integer.parseInt(string4)), n2) && n2 == n3) continue;
            String string5 = this.getSectorSequenceForSector(n3);
            String string6 = string3 = bl ? this.getPrimaryPortIdForSector(n3) : this.getSecondaryPortIdForSector(n3);
            if (!this.scps[i].isPrimaryPortIdSet() || !string3.equals(string) || !string5.equals(string2)) continue;
            String string7 = bl ? "Primary" : "Secondary";
            throw new BemException("Combination of " + string7 + " port id and Sector sequence used for sector number " + n3 + " is already used. Port id=" + string3 + " Sequence=" + string5 + ".");
        }
    }

    public void checkThatNoCpsAreSetForNotConfiguredSector() throws BemException {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            int n;
            AbstractRbb abstractRbb;
            boolean bl;
            SectorCustomerParameters sectorCustomerParameters = this.scps[i];
            boolean bl2 = bl = sectorCustomerParameters.isLineRateSet() || sectorCustomerParameters.isRbbNameSet() || sectorCustomerParameters.isPrimaryPortIdSet() || sectorCustomerParameters.isAuUnitTypeSet();
            if (!bl || (abstractRbb = this.rbbmanager.getRadioBuildingBlock(n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber))) != null) continue;
            String string = null;
            if (!sectorCustomerParameters.isAuUnitTypeSet()) {
                string = "AuUnitType";
            } else if (!sectorCustomerParameters.isPrimaryPortIdSet()) {
                string = "PrimaryPortId";
            } else if (!sectorCustomerParameters.isRbbNameSet()) {
                string = "RadioBuildingBlock";
            } else if (!sectorCustomerParameters.isLineRateSet()) {
                string = "LineRate";
            }
            String string2 = "The combination of input parameters entered for sector " + n + " is not valid.\n" + "Please check the input parameters. The parameter " + string + " is mandatory for creating one RBB but it was not set.";
            throw new BemException(string2);
        }
    }

    public boolean isSecondaryPortIdConfigured(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.scps[n2].isSecondaryPortIdSet();
    }

    public boolean isAir32Configured(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        boolean bl = this.scps[n2].isAir32Set();
        return bl;
    }

    public boolean isRRUS32SharedSector(String string, int n) {
        String string2 = this.getRadioSharedBySectorForSector(n);
        return string2 != "" && (string.equals("RBB22_1F") || string.equals("RBB22_1G")) && n > Integer.parseInt(string2);
    }

    public boolean isRruInstalledConfigured(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.scps[n2].isRruInstalledSet();
    }

    public Integer getLineRateMomValue(int n) throws BemException {
        return this.scps[n].getLineRateMomValue();
    }

    public void checkThatAtLeastOneSectorIsConfigured() throws BemException {
        boolean bl = false;
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            String string = this.scps[i].getRbbValue();
            if (string.equals("")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new BemException("At least one sector needs to be configured.");
        }
    }

    public void checkThatOnlyOneSectorIsConfigured() throws BemException {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            String string = this.scps[i].getRbbValue();
            if (string.equals("")) continue;
            bl = true;
            ++n;
        }
        if (!bl || n > 1) {
            throw new BemException("There must be one and only one macro sector to be configured for Micro RBS.");
        }
    }

    public void setCustomerParameterRestrictions() throws BemException {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            this.scps[i].setCustomerParameterRestrictions();
        }
    }

    public void setCustomerParameterRestrictions(int n) throws BemException {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        this.scps[n2].setCustomerParameterRestrictions();
    }

    public void markAsNeedRuPositionAllocationForSector(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        this.scps[n2].setNeedRuPositionAllocation("YES");
    }

    public void markAsNeedRuPositionAllocationForSector(int n, String string) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        if ("YES".equals(string)) {
            this.scps[n2].setNeedRuPositionAllocation("YES");
        } else {
            this.scps[n2].setNeedRuPositionAllocation("NO");
        }
    }

    private boolean isAuUnitTypeExistingInAllSectors(String string) {
        for (int i = 0; i < this.scps.length; ++i) {
            if (!this.scps[i].getAuUnitTypeValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMacroRadio() {
        boolean bl = false;
        String[] stringArray = AuUnitType.MACRO_RADIO_AUUNITTYPE;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isAuUnitTypeExistingInAllSectors(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasMainRemoteRadio() {
        String[] stringArray = AuUnitType.MAIN_REMOTE_RADIO_AUUNITTYPE;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isAuUnitTypeExistingInAllSectors(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean hasHybridRadio() {
        return this.hasMacroRadio() && this.hasMainRemoteRadio();
    }

    public boolean hasAnySectorNeedRuPositionAllocation() {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            SectorCustomerParameters sectorCustomerParameters = this.scps[i];
            if ("".equals(sectorCustomerParameters.getRbbValue()) || !sectorCustomerParameters.needRuPositionAllocation()) continue;
            return true;
        }
        return false;
    }

    public boolean needRuPositionAllocation(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].needRuPositionAllocation();
    }

    public boolean getNeedRuPositionAllocationLoadedValue(int n) {
        int n2 = n - 1;
        if (n >= this.startingSectorNumber) {
            n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        }
        return this.scps[n2].getNeedRuPositionAllocationLoadedValue();
    }
}

