/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDeviceBoardRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimObifDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class ObifRI
extends AbstractDeviceBoardRI
implements RadioInterfaceBoard {
    public static final String name = "OBIF";
    public static final String SWALLOC_ROLE = "RBS_OBIFB";
    public static final String REPERTOIRE = "RBS_OBIFB";
    private int configurationGroup = 0;
    private boolean isObifRestarted = false;

    public ObifRI(Rbs rbs, int n, MoInstance moInstance) {
        super(name, rbs, n, MimObifDeviceGroup.MOTYPENAME, moInstance, true);
        super.setRoleForSwAllocation("RBS_OBIFB");
        super.addRepertoiresToInstall("RBS_OBIFB");
        super.createPiuAndBoard(true);
    }

    public String getPiuLdn() {
        String string = BemUtil.extractLdn(this.getLdn(), MimPlugInUnit.MOTYPENAME);
        return string;
    }

    public String getType() {
        return name;
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("OilOperationModeSettingPhase")) {
            this.setConfigurationGroup();
        }
        if (string.equals("WaitForObifToBecomeEnabledPhase")) {
            this.waitForObifToBecomeEnabled();
        }
    }

    public void setConfigurationGroup() throws BemException {
        block4: {
            String string = this.getLdn();
            if (!super.isExisting(string)) {
                return;
            }
            BemMo bemMo = this.getMo(string);
            Integer n = (Integer)this.getAttribute(bemMo, "configurationGroup");
            if (n == this.configurationGroup) break block4;
            this.setAttribute(bemMo, "configurationGroup", (Object)new Integer(this.configurationGroup));
            int n2 = 0;
            do {
                if ((n = (Integer)this.getAttribute(bemMo, "configurationGroup")) == this.configurationGroup) {
                    BemMo bemMo2 = bemMo.getParent();
                    super.unlockDeviceBoard();
                    this.restart(bemMo2);
                    this.isObifRestarted = true;
                    break block4;
                }
                if (super.isInterrupted()) {
                    return;
                }
                Nal.getLog().nalTrace(6, this.getClass(), "Configuration group not updated, waiting 15sec. loadedConfigurationGroup=" + n + " configurationGroup=" + this.configurationGroup);
                int n3 = 15000;
                this.delay(n3);
            } while (++n2 <= 4);
            Nal.getLog().nalTrace(1, this.getClass(), "Timed out, failed to update. loadedConfigurationGroup=" + n + " configurationGroup=" + this.configurationGroup);
        }
    }

    private void waitForObifToBecomeEnabled() throws BemException {
        block4: {
            if (this.isObifRestarted) {
                String string = this.getLdn();
                if (!super.isExisting(string)) {
                    return;
                }
                BemMo bemMo = this.getMo(string);
                int n = 0;
                while (true) {
                    Integer n2 = (Integer)bemMo.getAttribute("operationalState");
                    Integer n3 = (Integer)bemMo.getAttribute("availabilityStatus");
                    if (n2 == 1 && n3 == 0) break block4;
                    if (n >= 6) break;
                    if (super.isInterrupted()) {
                        return;
                    }
                    ++n;
                    int n4 = 10000;
                    this.delay(n4);
                }
                Nal.getLog().nalTrace(1, this.getClass(), "Timed out, OBIF not operational after 60 seconds, so perform rollback.");
                throw new BemException("Timed out, OBIF not operational after 60 seconds, so perform rollback.");
            }
        }
    }

    private void restart(BemMo bemMo) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", new Integer(2)), Nal.getFactory().getNameValue("restartReason", new Integer(0)), Nal.getFactory().getNameValue("restartInfo", "Restarting board after change of Configuration Group attribute")};
        this.action(bemMo, "manualRestart", nalNameValueArray);
    }

    private void delay(long l) {
        try {
            NalFactory nalFactory = Nal.getFactory();
            nalFactory.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConfigurationGroup(Integer n) {
        this.configurationGroup = n;
    }

    public Integer getConfigurationGroup() throws BemException {
        BemMo bemMo = this.getMo(super.getLdn());
        Integer n = (Integer)this.getAttribute(bemMo, "configurationGroup");
        return n;
    }
}

