/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.util;

import java.util.ArrayList;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DuwUtil {
    private static boolean isSetup;
    private static final String PRIMARY_DUW_PIU_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1";
    private static final String SECONDARY_DUW_PIU_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1";
    private static final int PRIMARY_DUW_PIU_ID = 1;
    private static final int SECONDARY_DUW_PIU_ID = 2;
    private static final String PRIMARY_DUW_1STBBP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=1";
    private static final String PRIMARY_DUW_2NDBBP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=3";
    private static final String SECONDARY_DUW_1STBBP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=2";
    private static final String SECONDARY_DUW_2NDBBP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,DownlinkBaseBandPool=4";
    private static final String PRIMARY_DUW_EXCHANGE_TERMINAL_IP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminalIp=1";
    private static final String SECONDARY_DUW_EXCHANGE_TERMINAL_IP_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,ExchangeTerminalIp=1";
    private static final String PRIMARY_DUW_EXCHANGE_TERMINAL_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,ExchangeTerminal=1";
    private static final String SECONDARY_DUW_EXCHANGE_TERMINAL_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,ExchangeTerminal=1";
    private static final String PRIMARY_DUW_DUI_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1,PiuDevice=1,DeviceGroup=DUI";
    private static final String SECONDARY_DUW_DUI_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=2,PlugInUnit=1,PiuDevice=1,DeviceGroup=DUI";
    private static final String WIZARD_SWALLOC_ROLE_DUW = "Main_DUW";
    private static final String INTERPIULINK_LDN = "ManagedElement=1,Equipment=1,InterPiuLink=1";
    private static final String WIZARD_REPERTOIRE_REDUNDANCY = "CPP_Control_Common_Redundancy_R6K";
    private static final int PIUGROUP_START_NUMBER = 1;
    private static final String RBS_DUW_10 = "DUW10";
    private static final String RBS_DUW_20 = "DUW20";
    private static final String RBS_DUW_30 = "DUW30";
    private static final String RBS_DUW_11 = "DUW11";
    private static final String RBS_DUW_31 = "DUW31";
    private static final String RBS_DUW_41 = "DUW41";
    private static BemMo[] duwPius;
    private static boolean hasDuw;
    private static boolean hasDualDuw;
    private static String primaryDuwType;
    private static String secondaryDuwType;
    private static final String[] numHsResourcesDuw10;
    private static final String[] numHsResourcesDuw20;
    private static final String[] numHsResourcesDuw30;
    private static boolean isPrimaryDuwV2;
    private static boolean isMicroRbsDuw;
    private static boolean isPrimaryDuwV1;
    private static boolean isPriDuwSupport12CC;
    private static boolean isSecDuwSupport12CC;
    private static boolean isSecDuwV2;

    public static void unSetup() {
        isSetup = false;
    }

    public static void setup() {
        hasDuw = false;
        hasDualDuw = false;
        isPrimaryDuwV2 = false;
        isMicroRbsDuw = false;
        isPriDuwSupport12CC = false;
        isSecDuwSupport12CC = false;
        isSecDuwV2 = false;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(PRIMARY_DUW_PIU_LDN);
        if (bemMo.isExisting()) {
            try {
                Object object;
                Object object2;
                duwPius = new BemMo[]{bemMo};
                BemMo bemMo2 = (BemMo)moHandlerImpl.getAttribute(bemMo, "piuType");
                NalStruct nalStruct = (NalStruct)moHandlerImpl.getAttribute(bemMo2, "productData");
                String string = (String)nalStruct.getMemberValue("productName");
                if (string.startsWith("DUW") || string.startsWith("ODW") || string.startsWith("ODS")) {
                    hasDuw = true;
                    object2 = (String)nalStruct.getMemberValue("productName");
                    object = (String)nalStruct.getMemberValue("productNumber");
                    primaryDuwType = DuwUtil.getDuwType((String)object2, (String)object);
                    isPrimaryDuwV2 = DuwUtil.isDuwV2(primaryDuwType);
                    isPrimaryDuwV1 = DuwUtil.isDuwV1(primaryDuwType);
                    if (string.startsWith("ODS")) {
                        isMicroRbsDuw = true;
                    }
                    isPriDuwSupport12CC = DuwUtil.isDuwSupport12CC(primaryDuwType);
                }
                if ((object2 = moHandlerImpl.getMo(SECONDARY_DUW_PIU_LDN)).isExisting()) {
                    duwPius = new BemMo[]{bemMo, object2};
                    object = (BemMo)moHandlerImpl.getAttribute((BemMo)object2, "piuType");
                    NalStruct nalStruct2 = (NalStruct)moHandlerImpl.getAttribute((BemMo)object, "productData");
                    String string2 = (String)nalStruct2.getMemberValue("productName");
                    if (string2.startsWith("DUW") || string2.startsWith("ODW")) {
                        hasDualDuw = true;
                        String string3 = (String)nalStruct2.getMemberValue("productName");
                        String string4 = (String)nalStruct2.getMemberValue("productNumber");
                        secondaryDuwType = DuwUtil.getDuwType(string3, string4);
                        isSecDuwV2 = DuwUtil.isDuwV2(secondaryDuwType);
                        isSecDuwSupport12CC = DuwUtil.isDuwSupport12CC(secondaryDuwType);
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("Retrieving DUW type from RBS", exception);
            }
        }
        isSetup = true;
    }

    private static boolean isDuwV2(String string) {
        boolean bl = false;
        if (string.equals(RBS_DUW_11) || string.equals(RBS_DUW_31) || string.equals(RBS_DUW_41)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isDuwV1(String string) {
        boolean bl = false;
        if (string.equals(RBS_DUW_10) || string.equals(RBS_DUW_20) || string.equals(RBS_DUW_30)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isDuwSupport12CC(String string) {
        boolean bl = false;
        if (string.equals(RBS_DUW_30) || string.equals(RBS_DUW_31) || string.equals(RBS_DUW_41)) {
            bl = true;
        }
        return bl;
    }

    public static String getPrimaryDuwPiuLdn() {
        return PRIMARY_DUW_PIU_LDN;
    }

    public static String getSecondaryDuwPiuLdn() {
        return SECONDARY_DUW_PIU_LDN;
    }

    public static String getPrimaryDuw1stBBPLdn() {
        return PRIMARY_DUW_1STBBP_LDN;
    }

    public static String getPrimaryDuw2ndBBPLdn() {
        return PRIMARY_DUW_2NDBBP_LDN;
    }

    public static String getSecondaryDuw1stBBPLdn() {
        return SECONDARY_DUW_1STBBP_LDN;
    }

    public static String getSecondaryDuw2ndBBPLdn() {
        return SECONDARY_DUW_2NDBBP_LDN;
    }

    public static String getDuwPiuLdn(String string) {
        String string2 = null;
        if (string.equals("1")) {
            string2 = DuwUtil.getPrimaryDuwPiuLdn();
        } else if (string.equals("2")) {
            string2 = DuwUtil.getSecondaryDuwPiuLdn();
        } else {
            throw new IllegalArgumentException("DuwUtil.getDuwPiuLdn() can not interprete duwSlotNumber=" + string);
        }
        return string2;
    }

    public static String getPrimaryDuwSlotLdn() {
        String string = DuwUtil.getSlotLdnFromPiuLdn(PRIMARY_DUW_PIU_LDN);
        return string;
    }

    public static String getSecondaryDuwSlotLdn() {
        String string = DuwUtil.getSlotLdnFromPiuLdn(SECONDARY_DUW_PIU_LDN);
        return string;
    }

    public static int getPrimaryDuwID() {
        return 1;
    }

    public static int getSecondaryDuwID() {
        return 2;
    }

    public static void setDuwPius(BemMo[] bemMoArray) {
        if (!isSetup) {
            DuwUtil.setup();
        }
        BemMo[] bemMoArray2 = bemMoArray;
        duwPius = bemMoArray2;
    }

    public static boolean hasDuw() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return hasDuw;
    }

    public static boolean hasSingleDuw() {
        return !DuwUtil.hasDualDuws();
    }

    public static boolean hasDualDuws() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return hasDualDuw;
    }

    public static boolean isPantherHybridRbs() throws BemException {
        boolean bl = false;
        boolean bl2 = false;
        if (DuwUtil.hasDualDuws()) {
            int n = 0;
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            try {
                Object object;
                int n2;
                BemMo bemMo = moHandlerImpl.getRoot();
                BemMo[] bemMoArray = moHandlerImpl.getChildren(bemMo, 1, MimEquipment.MOTYPENAME, "");
                BemMo[] bemMoArray2 = moHandlerImpl.getChildren(bemMoArray[0], 2, MimAuxPlugInUnit.MOTYPENAME, "");
                BemMo[] bemMoArray3 = moHandlerImpl.getChildren(bemMo, 2, MimSector.MOTYPENAME, "");
                for (n2 = 0; n2 < bemMoArray3.length; ++n2) {
                    object = bemMoArray3[n2].getDN();
                    String string = ((String)object).substring(((String)object).lastIndexOf("=") + 1);
                    if (Integer.valueOf(string) < 7) continue;
                    bl2 = true;
                    break;
                }
                for (n2 = 0; n2 < bemMoArray2.length; ++n2) {
                    object = (Integer)bemMoArray2[n2].getAttribute("auType");
                    if ((Integer)object != 24) continue;
                    ++n;
                }
            }
            catch (MoHandlerException moHandlerException) {
                moHandlerException.printStackTrace();
            }
            if (n == 1 && bl2) {
                bl = true;
            }
        }
        return bl;
    }

    public static String[] getDuwPiuLdns() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < duwPius.length; ++i) {
            String string = duwPius[i].getDN();
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    public static String[] getDuwSlotLdns() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < duwPius.length; ++i) {
            String string = duwPius[i].getDN();
            String string2 = DuwUtil.getSlotLdnFromPiuLdn(string);
            arrayList.add(string2);
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        return stringArray;
    }

    private static String getSlotLdnFromPiuLdn(String string) {
        int n = string.lastIndexOf(",");
        String string2 = string.substring(0, n);
        return string2;
    }

    public static String getDuwType(String string) {
        if (!isSetup) {
            DuwUtil.setup();
        }
        if ("1".equals(string)) {
            return primaryDuwType;
        }
        if ("2".equals(string) && DuwUtil.hasDualDuws()) {
            return secondaryDuwType;
        }
        return null;
    }

    private static String getDuwType(String string, String string2) throws BemException {
        String string3;
        String string4 = BemUtil.getTrimString(string != null ? string : "");
        String string5 = BemUtil.getTrimString(string2 != null ? string2 : "");
        if (string5.equals("KDU127161/1")) {
            string3 = RBS_DUW_10;
        } else if (string5.equals("KDU127161/2")) {
            string3 = RBS_DUW_20;
        } else if (string5.equals("KDU127161/3")) {
            string3 = RBS_DUW_30;
        } else if ((string4.startsWith("DUW") || string4.startsWith("ODW") || string4.startsWith("ODS")) && string4.length() >= 5) {
            string3 = "DUW" + string4.substring(3, 5);
        } else {
            throw new BemException("Can not get correct DUW type from productName=" + string + " or productNumber=" + string2);
        }
        return string3;
    }

    public static String[] getAllSupportedRbsTypes() {
        String[] stringArray = new String[]{RbsInfo.RBS_3018.NAME, RbsInfo.RBS_3106.NAME, RbsInfo.RBS_3116.NAME, RbsInfo.RBS_3206.NAME, RbsInfo.RBS_3206M.NAME, RbsInfo.RBS_3216.NAME, RbsInfo.RBS_6101W.NAME, RbsInfo.RBS_6102W.NAME, RbsInfo.RBS_6110W.NAME, RbsInfo.RBS_6120W.NAME, RbsInfo.RBS_6131W.NAME, RbsInfo.RBS_6201W.NAME, RbsInfo.RBS_6201V2W.NAME, RbsInfo.RBS_6202W.NAME, RbsInfo.RBS_6301W.NAME, RbsInfo.RBS_6302W.NAME, RbsInfo.RBS_6320W.NAME, RbsInfo.RBS_6501W.NAME, RbsInfo.RBS_6601W.NAME};
        return stringArray;
    }

    public static String getPrimaryExchangeTerminalIpLdn() {
        return PRIMARY_DUW_EXCHANGE_TERMINAL_IP_LDN;
    }

    public static String getSecondaryExchangeTerminalIpLdn() {
        return SECONDARY_DUW_EXCHANGE_TERMINAL_IP_LDN;
    }

    public static String getPrimaryExchangeTerminalLdn() {
        return PRIMARY_DUW_EXCHANGE_TERMINAL_LDN;
    }

    public static String getSecondaryExchangeTerminalLdn() {
        return SECONDARY_DUW_EXCHANGE_TERMINAL_LDN;
    }

    public static String getPrimaryDuiLdn() {
        return PRIMARY_DUW_DUI_LDN;
    }

    public static String getSecondaryDuiLdn() {
        return SECONDARY_DUW_DUI_LDN;
    }

    public static String getInterPiuLinkLdn() {
        return INTERPIULINK_LDN;
    }

    public static String getWizardRepertoireRedundancy() {
        return WIZARD_REPERTOIRE_REDUNDANCY;
    }

    public static String getWizardSwAllocationRoleDuw() {
        return WIZARD_SWALLOC_ROLE_DUW;
    }

    public static int getPiugroupStartNumber() {
        return 1;
    }

    public static String getSlotNumberForPrimaryDuw() {
        return "1";
    }

    public static String getSlotNumberForSecondaryDuw() {
        return "2";
    }

    public static String[] getStaticNumHsResoucesRange() {
        return DuwUtil.getEnumeratedRange(MimTxDeviceGroup.MIN_STATICNUMHSCODERESOURCES, MimTxDeviceGroup.MAX_STATICNUMHSCODERESOURCES);
    }

    public static String[] getNumHsResoucesRangePrimaryDuw() {
        return DuwUtil.getNumHsResourcesRange(primaryDuwType);
    }

    public static String[] getNumHsResoucesRangeSecondaryDuw() {
        return DuwUtil.getNumHsResourcesRange(secondaryDuwType);
    }

    public static String[] getNumHsResourcesPerBasebandPoolRange() {
        return DuwUtil.getEnumeratedRange(MimDownlinkBaseBandPool.MIN_NUMHSCODERESOURCES, MimDownlinkBaseBandPool.MAX_NUMHSCODERESOURCES);
    }

    private static String[] getNumHsResourcesRange(String string) {
        if (!isSetup) {
            DuwUtil.setup();
        }
        String[] stringArray = string.equals(RBS_DUW_10) ? numHsResourcesDuw10 : (string.equals(RBS_DUW_20) ? numHsResourcesDuw20 : (string.equals(RBS_DUW_30) ? numHsResourcesDuw30 : new String[]{"0"}));
        return stringArray;
    }

    public static String[] getNumEulResourcesRange() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        String[] stringArray = DuwUtil.getEnumeratedRange(MimTxDeviceGroup.MIN_NUMEULRESOURCES, MimTxDeviceGroup.MAX_NUMEULRESOURCES);
        return stringArray;
    }

    public static String[] getStaticNumEulResourcesRange() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        String[] stringArray = DuwUtil.getEnumeratedRange(MimTxDeviceGroup.MIN_STATICNUMEULRESOURCES, MimTxDeviceGroup.MAX_STATICNUMEULRESOURCES);
        return stringArray;
    }

    private static String[] getEnumeratedRange(Integer n, Integer n2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = n.intValue(); i <= n2; ++i) {
            treeSet.add(String.valueOf(i));
        }
        String[] stringArray = treeSet.toArray(new String[0]);
        return stringArray;
    }

    public static String[] getSlotArrayForTxDevices(int n) {
        String[] stringArray = new String[]{DuwUtil.getSlotNumberForPrimaryDuw()};
        String[] stringArray2 = new String[]{DuwUtil.getSlotNumberForSecondaryDuw()};
        String[] stringArray3 = stringArray;
        if (n == 1) {
            stringArray3 = stringArray2;
        }
        return stringArray3;
    }

    public static boolean isAtmSupported() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        boolean bl = false;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(PRIMARY_DUW_EXCHANGE_TERMINAL_LDN);
        try {
            if (moHandlerImpl.isExisting(bemMo)) {
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed to check if ExchangeTerminal MO is existing", (Throwable)moHandlerException);
        }
        return bl;
    }

    public static boolean isPrimaryDuwV2() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return isPrimaryDuwV2;
    }

    public static boolean isDualDuwAndPrimaryIsV2() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return hasDualDuw && isPrimaryDuwV2;
    }

    public static boolean isDualDuwAndPrimaryIsV1() {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return hasDualDuw && isPrimaryDuwV1;
    }

    public static boolean isMicroRbsDuw() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return isMicroRbsDuw;
    }

    public static boolean isPriDuwSupport12CC() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return isPriDuwSupport12CC;
    }

    public static boolean isSecDuwSupport12CC() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return hasDualDuw && isSecDuwSupport12CC;
    }

    public static boolean isPrimaryDuw30() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        return primaryDuwType.equals(RBS_DUW_30);
    }

    public static boolean isDualBoxConfiguration(String string) {
        if (!isSetup) {
            DuwUtil.setup();
        }
        if (!hasDualDuw) {
            return false;
        }
        boolean bl = false;
        if (string.equals(RbsInfo.RBS_6302W.NAME)) {
            bl = true;
        } else if (string.equals(RbsInfo.RBS_6601W.NAME) && isPrimaryDuwV1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isCascadingSupport(String string) {
        if (!isSetup) {
            DuwUtil.setup();
        }
        if (!hasDualDuw) {
            return false;
        }
        boolean bl = false;
        if (string.equals(RbsInfo.RBS_6601W.NAME) && isPrimaryDuwV2) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPrimaryDuwV1() {
        return isPrimaryDuwV1;
    }

    public static boolean isPureDuwV2() throws BemException {
        if (!isSetup) {
            DuwUtil.setup();
        }
        boolean bl = false;
        if (hasDualDuw && isPrimaryDuwV2 && isSecDuwV2) {
            bl = true;
        } else if (!hasDualDuw && isPrimaryDuwV2) {
            bl = true;
        }
        return bl;
    }

    static {
        hasDuw = false;
        hasDualDuw = false;
        secondaryDuwType = RBS_DUW_10;
        numHsResourcesDuw10 = new String[]{"0", "1"};
        numHsResourcesDuw20 = new String[]{"0", "1", "2", "3"};
        numHsResourcesDuw30 = new String[]{"0", "1", "2", "3", "4"};
        isPrimaryDuwV2 = false;
        isMicroRbsDuw = false;
        isPrimaryDuwV1 = false;
        isPriDuwSupport12CC = false;
        isSecDuwSupport12CC = false;
        isSecDuwV2 = false;
    }
}

