/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSector;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SectorUtil {
    private static final String[] SECTOR_RDN = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    private static final String AUTO_CREATED_RDNID_1 = "1";
    public static final int startingSectorNumberOnPDuw = 1;
    public static final int startingSectorNumberOnSDuw = 7;

    public static String[] getSectorRdn() {
        return SECTOR_RDN;
    }

    public static String getSectorLdn(int n) throws BemException {
        MoInstance moInstance = SectorUtil.getNodeBFunctionMoi();
        String string = SectorUtil.getSectorLdn(n, moInstance);
        return string;
    }

    public static String getSectorLdn(int n, MoInstance moInstance) throws BemException {
        String string = moInstance.getLdn() + "," + MimSector.MOTYPENAME + "=" + SECTOR_RDN[n - 1];
        return string;
    }

    private static MoInstance getNodeBFunctionMoi() throws BemException {
        try {
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimNodeBFunction.MOTYPENAME, AUTO_CREATED_RDNID_1);
            return singleChildMoi;
        }
        catch (Exception exception) {
            throw new BemException("Can not read NodeBFunction MO", (Throwable)exception);
        }
    }

    public static int getSectorNumberFromSectorIndex(int n, int n2) {
        return n + n2;
    }

    public static int getSectorIndexFromSectorNumber(int n, int n2) {
        return n - n2;
    }

    public static int getSectorNumFromLdn(String string) {
        String string2 = "Sector=";
        int n = string.indexOf(string2);
        if (n == -1) {
            return -1;
        }
        int n2 = string.indexOf(",", n);
        if (n2 == -1) {
            return Integer.parseInt(string.substring(n + string2.length()));
        }
        return Integer.parseInt(string.substring(n + string2.length(), n2));
    }

    public static int getCarrierNumFromLdn(String string) {
        String string2 = "Carrier=";
        int n = string.indexOf(string2);
        if (n == -1) {
            return -1;
        }
        int n2 = string.indexOf(",", n);
        if (n2 == -1) {
            return Integer.parseInt(string.substring(n + string2.length()));
        }
        return Integer.parseInt(string.substring(n + string2.length(), n2));
    }

    public static String getLoadedRrus32AuxPiuLdnBySector(Rbs rbs, int n) {
        String string = null;
        BemMo bemMo = null;
        MoHandler moHandler = rbs.getMoHandler();
        try {
            BemMo bemMo2 = moHandler.getMo(SectorUtil.getSectorLdn(n));
            BemMo[] bemMoArray = (BemMo[])bemMo2.getAttribute("sectorAntennasRef");
            if (bemMoArray[0] != null) {
                BemMo bemMo3;
                String string2;
                BemMo[] bemMoArray2;
                BemMo[] bemMoArray3 = bemMoArray[0].getChildren();
                for (int i = 0; i < bemMoArray3.length; ++i) {
                    if (!bemMoArray3[i].getLastRDN().endsWith("AntennaBranch=A")) continue;
                    bemMo = bemMoArray3[i];
                    break;
                }
                if (bemMo != null && (bemMoArray2 = (BemMo[])bemMo.getAttribute("reservedBy"))[0] != null && (string2 = bemMoArray2[0].getId()).endsWith(MimAntennaBranchDef.BRANCH_A) && (bemMo3 = (BemMo)bemMoArray2[0].getAttribute("connectedToObjectARef")) != null) {
                    Integer n2 = (Integer)bemMo3.getAttribute("auType");
                    if (bemMo3.getParent().getType().equals(MimEquipment.MOTYPENAME) && n2 == 20) {
                        string = bemMo3.getDN();
                    }
                }
            }
        }
        catch (Exception exception) {
            BemLog.log(2, "getLoadedRrus32AuxPiuLdnBySector(), Get AuxPiu MO failed :");
        }
        return string;
    }

    public static String[] getAllLoadedRrus32AuxPiuLdn(Rbs rbs) {
        MoHandler moHandler = rbs.getMoHandler();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BemMo bemMo = moHandler.getMo(rbs.getEquipmentMoi().getLdn());
            BemMo[] bemMoArray = null;
            String string = "auType==20";
            bemMoArray = moHandler.getChildren(bemMo, 1, MimAuxPlugInUnit.MOTYPENAME, string);
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    arrayList.add(bemMoArray[i].getDN());
                }
            }
        }
        catch (Exception exception) {
            BemLog.log(2, "getAllLoadedRrus32AuxPiuLdn()");
        }
        int n = arrayList.size();
        return arrayList.toArray(new String[n]);
    }

    public static int getExistingSectorMoNumber(Rbs rbs) throws BemException {
        int n = 0;
        MoHandler moHandler = rbs.getMoHandler();
        try {
            BemMo bemMo = moHandler.getMo(rbs.getNodeBFunctionMoi().getLdn());
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimSector.MOTYPENAME, "");
            if (bemMoArray != null) {
                n = bemMoArray.length;
            }
        }
        catch (Exception exception) {
            throw new BemException("Get existing Sector Mo Number failed:", (Throwable)exception);
        }
        return n;
    }

    private static boolean isRbbSupportDualSector(AbstractRbb abstractRbb) {
        List<String> list = Arrays.asList("RBB22_1F", "RBB22_1G");
        return list.contains(abstractRbb.getName());
    }

    public static boolean isPositionConfigurationSupported(Rbs rbs, int n) throws BemException {
        RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
        if (!(radioEquipmentProvider instanceof RbbManager)) {
            return true;
        }
        RbbManager rbbManager = (RbbManager)rbs.getRadioEquipmentProvider();
        AbstractRbb abstractRbb = rbbManager.getRadioBuildingBlock(n);
        String string = abstractRbb.getRadioSharedBySector();
        if (!SectorUtil.isRbbSupportDualSector(abstractRbb) || string.equals("")) {
            return true;
        }
        int n2 = Integer.parseInt(string);
        return n <= n2;
    }

    public static boolean isRrus32WithRbb441d(Rbs rbs, int n) {
        boolean bl = false;
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)rbs.getProvider(RadioEquipmentProviderWithRbb.class);
        if (radioEquipmentProviderWithRbb != null && radioEquipmentProviderWithRbb.getAuUnitType(n) != null && radioEquipmentProviderWithRbb.getAuUnitType(n).equals("RRUWRRUS") && radioEquipmentProviderWithRbb.getRbbName(n).equalsIgnoreCase("RBB44_1D")) {
            bl = true;
        }
        return bl;
    }

    public static int getSectorAntennaNumberWithRetCascading(Rbs rbs, int n) {
        return SectorUtil.isRrus32WithRbb441d(rbs, n) ? 2 : 1;
    }
}

