/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3104.configitem;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.AbstractRbs3RadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.Configuration1Normal;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationCableData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.resource.McpaSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGammaCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHiPowTxCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIntJumperCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInterSubTimingCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIntraCabTimingCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimLoPowTxCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTrxRfCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RadioEquipment3104CI
extends AbstractRbs3RadioEquipmentCI {
    private static final int BBIF_SLOT1 = 8;
    private static final int BBIF_SLOT2 = 0;
    private static final int RFIF_SLOT1 = 9;
    private static final int RFIF_SLOT2 = 0;
    private static final int TRX_SLOT1 = 10;
    private static final int TRX_SLOT2 = 11;
    private static final int AIU_SLOT = 12;
    private static final int MCPA_SLOT1 = 1;
    private static final int MCPA_SLOT2 = 0;
    private static final String MCPA_CABINET_POSITION = "1";
    private static final String MCPA_SUBRACK_POSITION = "1A3";
    private static final int MCPA_SUBRACK_NO_SLOTS = 1;

    public RadioEquipment3104CI(Rbs rbs) {
        super(rbs);
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"6", "7"});
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"5"});
    }

    protected void createConfigurations() throws BemException {
        int n = this.getRbs().getMaxNumberOfSectors();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 1; i <= n; ++i) {
            ConfigurationData configurationData = this.getConfigurationData(n2, n3, n4);
            ConfigurationCableData configurationCableData = this.getConfigurationCableData();
            Configuration1Normal configuration1Normal = new Configuration1Normal(this.getRbs(), i, configurationData, configurationCableData);
            SectorCapability sectorCapability = new SectorCapability();
            sectorCapability.addConfiguration(configuration1Normal);
            this.addSectorCapability(i, sectorCapability);
            n2 += 0;
            n3 += 0;
            n4 += 0;
        }
    }

    protected ConfigurationData getConfigurationData(int n, int n2, int n3) throws BemException {
        HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(this.getRbs().getEquipmentMoi());
        McpaSubrackRI mcpaSubrackRI = new McpaSubrackRI(this.getRbs(), 1, MCPA_CABINET_POSITION, MCPA_SUBRACK_POSITION, this.getRbs().getEquipmentMoi());
        return new ConfigurationData(8, 0, 9, 0, 10 + n, 11 + n, 12 + n2, 1 + n3, 0 + n3, hubSubrackMoi, hubSubrackMoi, hubSubrackMoi, hubSubrackMoi, mcpaSubrackRI);
    }

    private ConfigurationCableData getConfigurationCableData() {
        ConfigurationCableData configurationCableData = new ConfigurationCableData();
        configurationCableData.addDelayAndAttenuationAttributes(MimGammaCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDelay", new Integer(12))});
        configurationCableData.addDelayAndAttenuationAttributes(MimInterSubTimingCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(12))});
        configurationCableData.addDelayAndAttenuationAttributes(MimIntraCabTimingCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalUlDelay", new Integer(12))});
        configurationCableData.addDelayAndAttenuationAttributes(MimTrxRfCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(20)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(6))});
        configurationCableData.addDelayAndAttenuationAttributes(MimIntJumperCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalUlDelay", new Integer(27)), Nal.getFactory().getNameValue("electricalDlDelay", new Integer(26)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(4)), Nal.getFactory().getNameValue("ulAttenuation", new Integer(4))});
        configurationCableData.addDelayAndAttenuationAttributes(MimLoPowTxCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(50)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(2))});
        configurationCableData.addDelayAndAttenuationAttributes(MimHiPowTxCable.MOTYPENAME, new NalNameValue[]{Nal.getFactory().getNameValue("electricalDlDelay", new Integer(50)), Nal.getFactory().getNameValue("dlAttenuation", new Integer(2))});
        return configurationCableData;
    }

    public Integer getTerminationConnector(int n, String string) throws BemException {
        if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_A)) {
            return new Integer(3);
        }
        if (string.equalsIgnoreCase(MimAntennaBranchDef.BRANCH_B)) {
            return new Integer(4);
        }
        throw new BemException(this.getClass().getName() + " getTerminationConnector(): Antenna branch " + string + " not supported");
    }
}

