/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimConfigurationVersion;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwAllocation;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public abstract class AbstractSwHandlingRI
extends AbstractResourceItem
implements ResourceItem {
    private static final String ERROR_NO_SWALLOCATIONS = "No SwAllocation MOs found on the node. Check that an Upgrade Package has been installed.";
    private String swAllocationRole;
    protected boolean moveSlotAllowed = false;
    protected BemMo configVersionMo = null;
    private BemMo piuTypeMo;
    protected Vector repertoiresToInstall = new Vector();
    protected Vector repertoiresToUninstall = new Vector();

    public AbstractSwHandlingRI(String string, Rbs rbs, String[] stringArray) {
        super(string, rbs, stringArray);
    }

    protected void setRoleForSwAllocation(String string) {
        this.swAllocationRole = string;
    }

    protected String getRoleForSwAllocation() {
        return this.swAllocationRole;
    }

    protected void addRepertoiresToInstall(String string) {
        this.repertoiresToInstall.add(string);
    }

    protected void addRepertoiresToUninstall(String string) {
        this.repertoiresToUninstall.add(string);
    }

    protected void createSwAllocationIfNotExisting() throws BemException {
        try {
            BemMo bemMo = this.getSwAllocationMOForRole(this.swAllocationRole);
            if (!this.isExisting(bemMo)) {
                Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
                vector.add(Nal.getFactory().getNameValue("role", this.swAllocationRole));
                this.create(bemMo, vector);
            }
        }
        catch (RuntimeException runtimeException) {
            String string = "Creation of SwAllocation MO";
            String string2 = runtimeException.toString();
            throw new BemException(string, "createSwAllocationIfNotExisting()", this.swAllocationRole, string2, runtimeException);
        }
    }

    protected void updateSwAllocation() throws BemException {
        this.deleteRepFromSwAllocationIfExisting();
        this.addRepToSwAllocationIfExisting();
    }

    protected void addRepToSwAllocationIfExisting() throws BemException {
        for (int i = 0; i < this.repertoiresToInstall.size(); ++i) {
            this.addRepToSwAllocationIfExisting((String)this.repertoiresToInstall.get(i));
        }
    }

    protected void addRepToSwAllocationIfExisting(String string) throws BemException {
        try {
            String string2 = this.rbs.getRepertoireLdn(string);
            if (string2 == null) {
                String string3 = "The Repertoire " + string + " not found for the " + this.getDisplayName() + " board.";
                throw new BemException(null, null, this.getLdn(), string3, null);
            }
            BemMo bemMo = this.getMo(string2);
            BemMo bemMo2 = this.getSwAllocationMOForRole(this.swAllocationRole);
            boolean bl = this.isRepertoireAlreadyConnected(bemMo2, string);
            if (!bl) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aRepertoire", bemMo)};
                this.action(bemMo2, "addRepertoire", nalNameValueArray);
            }
        }
        catch (RuntimeException runtimeException) {
            String string4 = "Adding Repertoire to the SwAllocation MO";
            String string5 = runtimeException.toString();
            throw new BemException(string4, "addRepToSwAllocationIfExisting()", this.getLdn(), string5, runtimeException);
        }
    }

    protected void deleteRepFromSwAllocationIfExisting() throws BemException {
        for (int i = 0; i < this.repertoiresToUninstall.size(); ++i) {
            this.deleteRepFromSwAllocationIfExisting((String)this.repertoiresToUninstall.get(i));
        }
    }

    protected void deleteRepFromSwAllocationIfExisting(String string) throws BemException {
        boolean bl;
        BemMo bemMo = this.getSwAllocationMOForRole(this.swAllocationRole);
        String string2 = this.rbs.getRepertoireLdn(string);
        if (string2 != null && (bl = this.isRepertoireAlreadyConnected(bemMo, string))) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aRepertoire", this.getMo(string2))};
            this.action(bemMo, "deleteRepertoire", nalNameValueArray);
        }
    }

    protected boolean isRepertoireAlreadyConnected(String string) throws BemException {
        BemMo bemMo = this.getSwAllocationMOForRole(this.swAllocationRole);
        return this.isRepertoireAlreadyConnected(bemMo, string);
    }

    private boolean isRepertoireAlreadyConnected(BemMo bemMo, String string) throws BemException {
        boolean bl = false;
        BemMo[] bemMoArray = null;
        bemMoArray = (BemMo[])this.getAttribute(bemMo, "repertoireList");
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                String string2 = (String)bemMo2.getAttribute("name");
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    protected BemMo getSwAllocationMOForRole(String string) throws BemException {
        String string2 = this.rbs.getSwAllocationLdn(string);
        if (string2 == null) {
            string2 = BemLdn.LDN_SWMANAGEMENT + "," + MimSwAllocation.MOTYPENAME + "=" + string;
        }
        BemMo bemMo = this.getMo(string2);
        return bemMo;
    }

    protected BemMo checkIfSlotAlreadyInUse(BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        BemMo bemMo3 = this.getMo(BemLdn.LDN_SWMANAGEMENT);
        BemMo[] bemMoArray = this.getChildren(bemMo3, 1, MimSwAllocation.MOTYPENAME, "");
        if (bemMoArray == null || bemMoArray.length == 0) {
            throw new BemException(ERROR_NO_SWALLOCATIONS);
        }
        BemMo bemMo4 = null;
        for (int i = 0; i < bemMoArray.length; ++i) {
            bemMo4 = bemMoArray[i];
            boolean bl = this.checkIfSlotIsAlreadyConnected(bemMo4, bemMo);
            if (!bl) continue;
            bemMo2 = bemMo4;
            break;
        }
        return bemMo2;
    }

    protected boolean checkIfSlotIsAlreadyConnected(BemMo bemMo, BemMo bemMo2) throws BemException {
        BemMo[] bemMoArray = null;
        boolean bl = false;
        try {
            if (bemMo.isExisting()) {
                bemMoArray = (BemMo[])this.getAttribute(bemMo, "slotList");
            }
        }
        catch (NalCmException nalCmException) {
            throw new BemException("Get slotList", bemMo.getDN(), (Throwable)nalCmException);
        }
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string;
                BemMo bemMo3 = bemMoArray[i];
                String string2 = bemMo3.getDN();
                if (!string2.equals(string = bemMo2.getDN())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractSwHandlingRI)) {
            return false;
        }
        AbstractSwHandlingRI abstractSwHandlingRI = (AbstractSwHandlingRI)object;
        String string = this.getLdn();
        String string2 = abstractSwHandlingRI.getLdn();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.getLdn().hashCode() * 11;
    }

    public void setAllowMoveSlot(boolean bl) {
        this.moveSlotAllowed = bl;
    }

    protected void deleteSlotIfConnected(BemMo bemMo, BemMo bemMo2) throws BemException {
        boolean bl = this.checkIfSlotIsAlreadyConnected(bemMo, bemMo2);
        if (bl) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo2)};
            this.action(bemMo, "deleteSlot", nalNameValueArray);
        }
    }

    protected BemMo getPiuType() throws BemException {
        this.initPiuTypeMo();
        return this.piuTypeMo;
    }

    private void initPiuTypeMo() throws BemException {
        String string;
        if (this.piuTypeMo == null && this.repertoiresToInstall.size() > 0 && !(string = (String)this.repertoiresToInstall.get(0)).equals("")) {
            String string2 = this.rbs.getRepertoireLdn(string);
            BemMo bemMo = this.getMo(string2);
            this.piuTypeMo = this.getPiuTypeFromRepertoire(bemMo);
        }
    }

    protected void installPiuTypes() throws BemException {
        BemMo bemMo = this.getPiuType();
        if (bemMo != null) {
            boolean bl = true;
            this.installPiuTypeIfNeeded(bemMo, bl);
        }
    }

    private boolean isLmFilesInstalled(BemMo bemMo) {
        boolean bl = false;
        Integer n = (Integer)bemMo.getAttribute("lmFilesInstallState");
        if (2 == n) {
            bl = true;
        }
        return bl;
    }

    protected void installPiuTypeIfNeeded(BemMo bemMo, boolean bl) throws BemException {
        boolean bl2 = false;
        boolean bl3 = false;
        long l = System.currentTimeMillis() + 600000L;
        while (!bl2) {
            if (this.isInterrupted()) {
                return;
            }
            if (this.repertoiresToInstall.isEmpty() || ((String)this.repertoiresToInstall.get(0)).equals("")) {
                bl2 = true;
                return;
            }
            if (this.isLmFilesInstalled(bemMo)) {
                bl2 = true;
            } else if (bl3) {
                BemLog.log(7, this.getClass() + bemMo.getDN() + " install started, wait for " + "lmFilesInstallState" + " to be installed");
                this.delay_ms(100);
            }
            if (l < System.currentTimeMillis()) {
                BemLog.log(2, this.getClass() + bemMo.getDN() + " installPiuTypeIfNeeded() Timed out before " + "lmFilesInstallState" + " was installed installStarted=" + bl3 + " checkIfInstalled=" + bl);
                return;
            }
            while (!(bl3 || bl2 && bl)) {
                if (this.isInterrupted()) {
                    return;
                }
                bl3 = this.piuTypeForcedInstall(bemMo);
                if (l < System.currentTimeMillis()) {
                    BemLog.log(2, this.getClass() + bemMo.getDN() + " installPiuTypeIfNeeded() Timed out before " + "lmFilesInstallState" + " was installed installStarted=" + bl3 + " checkIfInstalled=" + bl);
                    return;
                }
                if (bl3) continue;
                this.delay_ms(500);
            }
        }
    }

    private boolean piuTypeForcedInstall(BemMo bemMo) throws BemException {
        boolean bl = false;
        BemMo bemMo2 = this.getMo(this.rbs.getMoiRefs().getCurrentUPMoi().getLdn());
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aPiuTypeMo", bemMo)};
        Integer n = null;
        NalTransaction nalTransaction = Nal.getFactory().createTransaction();
        try {
            n = (Integer)bemMo2.action("piuTypeInstall", nalNameValueArray, nalTransaction);
            nalTransaction.commit();
            BemLog.log(7, this.getClass() + ".piuTypeForcedInstall(" + bemMo.getDN() + ")" + "actionid: " + n + " returned from action " + "piuTypeInstall");
        }
        catch (NalCmException nalCmException) {
            nalTransaction.rollback("BemLog.MAX_LOG_LEVEL, getClass()Rollback piuTypeForceInstall", nalCmException);
            if (nalCmException.toString().indexOf("ActionNotAllowed") != -1) {
                BemLog.log(7, this.getClass() + ".piuTypeForcedInstall(" + bemMo.getDN() + ")" + " ActionNotAllowed");
                return bl;
            }
            if (nalCmException.toString().indexOf("Connect to FTP server failed: Operation timed out") != -1) {
                BemLog.logError("Connect to FTP server failed", nalCmException);
                return bl;
            }
            throw nalCmException;
        }
        bl = this.waitForInstallationToComplete(n);
        return bl;
    }

    protected void setConfigurationVersionMo() throws BemException {
        if (this.configVersionMo == null) {
            BemMo bemMo = this.getRoot();
            BemMo[] bemMoArray = this.getChildren(bemMo, 2, MimConfigurationVersion.MOTYPENAME, "");
            this.configVersionMo = bemMoArray[0];
        }
    }

    private BemMo getPiuTypeFromRepertoire(BemMo bemMo) throws BemException {
        BemMo bemMo2;
        block10: {
            Object object;
            NalObject nalObject;
            int n;
            bemMo2 = null;
            BemMo[] bemMoArray = (BemMo[])bemMo.getAttribute("piuTypeList");
            for (n = 0; n < bemMoArray.length; ++n) {
                nalObject = bemMoArray[n];
                if (!this.isLmFilesInstalled((BemMo)nalObject) || nalObject.getLastRDN().endsWith("preInstalledSW_*")) continue;
                bemMo2 = nalObject;
                if (!this.getName().equals("CBU")) {
                    BemLog.log(7, this.getClass() + ".getPiuTypeFromRepertoire(" + bemMo.getDN() + ") " + "Found a piuType with LMs installed: " + bemMo2.getDN());
                    break;
                }
                object = (NalStruct)nalObject.getAttribute("productData");
                try {
                    String string = (String)object.getMemberValue("productName");
                    if (string.indexOf("CBU") == -1) continue;
                    BemLog.log(7, this.getClass() + ".getPiuTypeFromRepertoire(" + bemMo.getDN() + ") " + "Found a piuType with LMs installed: " + bemMo2.getDN());
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new BemException();
                }
            }
            if (bemMo2 != null || bemMoArray.length <= 0) break block10;
            if (!this.getName().equals("CBU")) {
                for (n = 0; n < bemMoArray.length; ++n) {
                    if (bemMoArray[n].getLastRDN().endsWith("preInstalledSW_*")) continue;
                    bemMo2 = bemMoArray[n];
                    BemLog.log(7, this.getClass() + ".getPiuTypeFromRepertoire(" + bemMo.getDN() + ") Found no piuType with LMs already installed, one without selected: " + bemMo2.getDN());
                    break;
                }
            } else {
                for (n = 0; n < bemMoArray.length; ++n) {
                    bemMo2 = bemMoArray[n];
                    nalObject = (NalStruct)bemMo2.getAttribute("productData");
                    try {
                        object = (String)nalObject.getMemberValue("productName");
                        if (((String)object).indexOf("CBU") == -1) continue;
                        BemLog.log(7, this.getClass() + ".getPiuTypeFromRepertoire(" + bemMo.getDN() + ") Found no piuType with LMs already installed, one without selected: " + bemMo2.getDN());
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        throw new BemException();
                    }
                }
            }
        }
        return bemMo2;
    }

    public boolean checkIfLoadModuleIsInstalled(String string) throws BemException {
        Integer n = null;
        this.setConfigurationVersionMo();
        BemMo bemMo = (BemMo)this.configVersionMo.getAttribute("currentUpgradePackage");
        BemMo[] bemMoArray = (BemMo[])bemMo.getAttribute("loadModuleList");
        if (bemMoArray != null && bemMoArray.length != 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string2;
                NalStruct nalStruct = (NalStruct)bemMoArray[i].getAttribute("productData");
                if (nalStruct == null) continue;
                try {
                    string2 = (String)nalStruct.getMemberValue("productName");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new BemException(noSuchFieldException.getCause());
                }
                if (string2.toUpperCase().indexOf(string) == -1) continue;
                n = (Integer)bemMoArray[i].getAttribute("fileState");
                break;
            }
        }
        if (n == null) {
            throw new BemException(this.getClass() + " Could not find the " + string + " loadmodule on current UGP !");
        }
        return n == 1;
    }

    public Integer nonBlockingInstall(String string, BemMo bemMo) throws BemException {
        BemMo bemMo2 = this.getMo(this.rbs.getMoiRefs().getCurrentUPMoi().getLdn());
        Integer n = null;
        BemMo bemMo3 = this.getSwAllocationMOForRole(this.swAllocationRole);
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("aSlot", bemMo)};
        NalTransaction nalTransaction = Nal.getFactory().createTransaction();
        n = (Integer)bemMo3.action("addSlot", nalNameValueArray, nalTransaction);
        nalTransaction.commit();
        nalTransaction = Nal.getFactory().createTransaction();
        NalNameValue[] nalNameValueArray2 = new NalNameValue[]{};
        n = (Integer)bemMo2.action("nonBlockingInstall", nalNameValueArray2, nalTransaction);
        nalTransaction.commit();
        return n;
    }

    public boolean waitForInstallationToComplete(Integer n) throws BemException {
        BemMo bemMo = this.getMo(this.rbs.getMoiRefs().getCurrentUPMoi().getLdn());
        boolean bl = false;
        boolean bl2 = false;
        while (!bl && !this.isInterrupted()) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl3 = false;
            NalStruct[] nalStructArray = (NalStruct[])bemMo.getAttribute("actionResult");
            try {
                for (int i = 0; i < nalStructArray.length; ++i) {
                    Integer n2 = (Integer)nalStructArray[i].getMemberValue("actionId");
                    if (n.intValue() == n2.intValue()) {
                        Integer n3 = (Integer)nalStructArray[i].getMemberValue("info");
                        String string = (String)nalStructArray[i].getMemberValue("additionalInfo");
                        if (n3 == 0 || n3 == 17) {
                            Integer n4 = (Integer)bemMo.getAttribute("progressHeader");
                            if (n4 == 0) {
                                bl2 = true;
                                bl = true;
                                break;
                            }
                            BemLog.log(7, " progressHeader is " + n4.toString());
                            break;
                        }
                        if (n3 == 9) {
                            bl2 = false;
                            bl = true;
                            break;
                        }
                        if (n3 == 16 && string.indexOf("Connect to FTP server failed: Operation timed out") != -1) {
                            bl2 = false;
                            bl = true;
                            break;
                        }
                        bl3 = true;
                        stringBuffer.append(((Object)nalStructArray[i]).toString());
                        continue;
                    }
                    bl = false;
                }
                if (bl3) {
                    throw new BemException("Download of loadmodules could not be initiated. getAttribute(actionResult) returned: " + stringBuffer.toString() + "\n" + ((Object)bemMo).toString(), (Throwable)new Exception());
                }
                if (bl) continue;
                this.delay_ms(100);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new BemException("getAttribute(actionResult)", ((Object)bemMo).toString(), (Throwable)noSuchFieldException);
            }
        }
        return bl2;
    }
}

