/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.exception;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionConstants;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionPropertiesContainer;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperty;

public class SortedProperties
implements ExceptionConstants {
    private static final boolean COPY_DEEP = true;
    private static final boolean COPY_SHALLOW = false;
    private final ExceptionPropertiesContainer propsContainer;
    private HashMap deepPropsCopy;
    private List userKeys;
    private List designerKeys;
    private List remainingKeys;
    private List stackTraces;
    private HashMap shallowPropsCopy;
    private List exceptionMessageKeys;
    private List revisionKeys;

    SortedProperties(ExceptionPropertiesContainer exceptionPropertiesContainer) {
        this.propsContainer = exceptionPropertiesContainer;
    }

    public synchronized ExceptionProperty.Iterator getPopUpIterator() {
        this.sortDeepExceptionProperties();
        ExceptionProperty.Iterator iterator = new ExceptionProperty.Iterator(USER_LEVEL, this.userKeys, this.deepPropsCopy);
        return iterator;
    }

    public synchronized ExceptionProperty.Iterators getDescriptionIterators() {
        this.sortDeepExceptionProperties();
        ExceptionProperty.Iterators iterators = new ExceptionProperty.Iterators();
        ExceptionProperty.Iterator iterator = this.getPopUpIterator();
        iterators.add(iterator);
        iterator = new ExceptionProperty.Iterator(DESIGNER_LEVEL, this.designerKeys, this.deepPropsCopy);
        iterators.add(iterator);
        iterator = new ExceptionProperty.Iterator(UNKNOWN_LEVEL, this.remainingKeys, this.deepPropsCopy);
        iterators.add(iterator);
        iterator = ExceptionProperties.getRevisionProperties().container.getSortedProperties().getRevisionIterator();
        iterators.add(iterator);
        iterator = new ExceptionProperty.Iterator(STACK_TRACES, this.stackTraces, this.deepPropsCopy);
        iterators.add(iterator);
        return iterators;
    }

    public String getExceptionMessageHeader() {
        this.copyShallowExceptionProperties();
        String string = (String)this.shallowPropsCopy.get("Exception message header");
        if (string == null) {
            string = "";
        }
        return string;
    }

    public synchronized ExceptionProperty.Iterator getExceptionMessageIterator() {
        Object object;
        if (this.exceptionMessageKeys == null) {
            this.exceptionMessageKeys = new ArrayList();
            object = this.copyShallowExceptionProperties();
            this.moveKeys((Set)object, this.exceptionMessageKeys, USER_LEVEL);
            this.moveKeys((Set)object, this.exceptionMessageKeys, DESIGNER_LEVEL);
            object.remove("Exception message header");
            this.sortAlphabetically((Set)object, this.exceptionMessageKeys);
        }
        object = new ExceptionProperty.Iterator(UNKNOWN_LEVEL, this.exceptionMessageKeys, this.shallowPropsCopy);
        return object;
    }

    public synchronized ExceptionProperty.Iterator getRevisionIterator() {
        Object object;
        if (this.revisionKeys == null) {
            this.revisionKeys = new ArrayList();
            object = this.copyShallowExceptionProperties();
            this.moveKeys((Set)object, this.revisionKeys, REVISION);
            this.sortAlphabetically((Set)object, this.revisionKeys);
        }
        object = new ExceptionProperty.Iterator(REVISION, this.revisionKeys, this.shallowPropsCopy);
        return object;
    }

    private List moveKeys(Set set, List list, ExceptionConstants.KeyGroup keyGroup) {
        for (int i = 0; i < keyGroup.KEYS.length; ++i) {
            String string = keyGroup.KEYS[i];
            if (!set.remove(string)) continue;
            list.add(string);
        }
        return list;
    }

    private List moveKeys(Set set, ExceptionConstants.KeyGroup keyGroup) {
        List list = new ArrayList();
        list = this.moveKeys(set, list, keyGroup);
        return list;
    }

    private List sortAlphabetically(Set set, List list) {
        TreeSet treeSet = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        treeSet.addAll(set);
        list.addAll(treeSet);
        return list;
    }

    private List sortAlphabetically(Set set) {
        List list = new ArrayList();
        list = this.sortAlphabetically(set, list);
        return list;
    }

    private synchronized Set copyDeepExceptionProperties() {
        if (this.deepPropsCopy == null) {
            this.deepPropsCopy = this.propsContainer.copyProperties(true);
        }
        HashSet hashSet = new HashSet(this.deepPropsCopy.keySet());
        return hashSet;
    }

    private synchronized void sortDeepExceptionProperties() {
        Object object;
        if (this.userKeys != null) {
            return;
        }
        Set set = this.copyDeepExceptionProperties();
        this.userKeys = this.moveKeys(set, USER_LEVEL);
        if (this.userKeys.size() == 0) {
            object = this.propsContainer.getDeepestException();
            String string = "INTERNAL ERROR!";
            String string2 = object == null ? "" : ((Throwable)object).toString();
            this.deepPropsCopy.put(string, string2);
            this.userKeys.add(string);
        }
        this.designerKeys = this.moveKeys(set, DESIGNER_LEVEL);
        this.stackTraces = this.moveKeys(set, STACK_TRACES);
        object = this.propsContainer.getStackTrace();
        if (object != null) {
            this.deepPropsCopy.put("Caught Exception", object);
            this.stackTraces.add("Caught Exception");
        }
        set.remove("Exception message header");
        this.remainingKeys = this.sortAlphabetically(set);
    }

    private synchronized Set copyShallowExceptionProperties() {
        if (this.shallowPropsCopy == null) {
            this.shallowPropsCopy = this.propsContainer.copyProperties(false);
        }
        HashSet hashSet = new HashSet(this.shallowPropsCopy.keySet());
        return hashSet;
    }
}

