/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;

public class CustomerParameterRadioButtonGroup
extends JPanel
implements CustomerParameterListener,
CustomerParameterComponent {
    private JRadioButton[] buttons;
    private CustomerParameter customerParameter;
    private JLabel groupLabel;
    private boolean showLabel;

    public CustomerParameterRadioButtonGroup(String string, String[] stringArray, CustomerParameter customerParameter, boolean bl) {
        int n;
        this.buttons = new JRadioButton[stringArray.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (n = 0; n < this.buttons.length; ++n) {
            this.buttons[n] = new JRadioButton(stringArray[n]);
            buttonGroup.add(this.buttons[n]);
        }
        this.groupLabel = new JLabel(string);
        this.showLabel = bl;
        this.customerParameter = customerParameter;
        this.init();
        for (n = 0; n < this.buttons.length; ++n) {
            this.buttons[n].addActionListener(new InputListener());
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.showLabel) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.groupLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.buttons[i], gridBagConstraints);
        }
        this.setSelectedButton();
    }

    public void addListener(ActionListener actionListener) {
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i].addActionListener(actionListener);
        }
    }

    private void setSelectedButton() {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!this.buttons[i].getText().equalsIgnoreCase(this.customerParameter.getValue())) continue;
            this.buttons[i].setSelected(true);
        }
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter != this.customerParameter) {
            return;
        }
        if (!parameterEvent.isAccessLevelChanged()) {
            return;
        }
        this.setSelectedButton();
    }

    private class InputListener
    implements ActionListener {
        private InputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                CustomerParameterRadioButtonGroup.this.customerParameter.setValue(actionEvent.getActionCommand());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

