/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalSimpleLog;

public class OptionsWindow
extends JFrame
implements ActionListener {
    static final String[] LOG_LEVEL_KEYS = new String[]{"Min", "Error", "Warning", "Notify", "Parameter", "Trace Flow", "Trace", "Max"};
    static final int[] LOG_LEVEL_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private final JComboBox logLevels = new JComboBox();
    private final JPanel mainPanel = new JPanel();
    private final JCheckBox logToStdOutCheckB;
    private final JCheckBox logToFileCheckB;
    private static final String LOG_DATA_TO_FILE = "Log data to file";
    private final JTextField logFilePath = new JTextField();
    private final JTextField logFilePrefix = new JTextField();
    private final JButton okButton;
    private final JButton applyButton;
    private final JButton cancelButton;
    private final ApplyButtonAction applyButtonAction = new ApplyButtonAction();
    private final EditAction editAction = new EditAction();

    public OptionsWindow(Component component) {
        super("Log Options");
        Object object;
        Object object2;
        Container container;
        if (component != null && component instanceof JFrame) {
            container = (JFrame)component;
            object2 = ((Frame)container).getTitle();
            int n = ((String)object2).indexOf("-");
            if (n > 0) {
                object2 = ((String)object2).substring(n + 1);
            }
            this.setTitle((String)object2 + " - About");
            object = ((Frame)container).getIconImage();
            if (object != null) {
                this.setIconImage((Image)object);
            }
        }
        container = this.getContentPane();
        this.mainPanel.setLayout(new GridBagLayout());
        object2 = new JLabel("Log level:");
        ((JLabel)object2).setLabelFor(this.logLevels);
        this.mainPanel.add((Component)object2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.logLevels.setToolTipText("Change the log level");
        this.mainPanel.add((Component)this.logLevels, new GridBagConstraints(1, 1, 3, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.logToStdOutCheckB = new JCheckBox("Log data to standard out");
        this.mainPanel.add((Component)this.logToStdOutCheckB, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.logToStdOutCheckB.setToolTipText("Log data to standard out");
        this.logToFileCheckB = new JCheckBox(LOG_DATA_TO_FILE);
        this.mainPanel.add((Component)this.logToFileCheckB, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.logToFileCheckB.setToolTipText(LOG_DATA_TO_FILE);
        JLabel jLabel = new JLabel("Log-file path: ");
        jLabel.setToolTipText("Path to log file");
        jLabel.setLabelFor(this.logFilePath);
        this.mainPanel.add((Component)jLabel, new GridBagConstraints(0, 4, 5, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.logFilePath, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.logFilePath.setToolTipText("Path to log file");
        this.logFilePath.setEnabled(false);
        object = new JLabel("Log-file prefix: ");
        ((JLabel)object).setLabelFor(this.logFilePrefix);
        this.mainPanel.add((Component)object, new GridBagConstraints(0, 5, 5, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ((JComponent)object).setToolTipText("prefix to: YYYYMMDD_HHMMSS.txt");
        this.mainPanel.add((Component)this.logFilePrefix, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.logFilePrefix.setToolTipText("prefix to: YYYYMMDD_HHMMSS.txt");
        this.logFilePrefix.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.applyButton = new JButton("Apply");
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        jPanel.add(this.applyButton);
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.init();
        container.add((Component)this.mainPanel, "East");
        this.pack();
        this.centerApplication(component);
        this.setVisible(true);
    }

    protected void init() {
        String string;
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this.applyButtonAction);
        this.cancelButton.addActionListener(this);
        this.logLevels.addActionListener(this.editAction);
        this.logToStdOutCheckB.addActionListener(this.editAction);
        this.logToFileCheckB.addActionListener(this.editAction);
        this.logFilePrefix.addActionListener(this.editAction);
        this.setSelectedItem(this.logLevels, this.getLogLevels());
        boolean bl = NalSimpleLog.getTheInstance().getLogToStdOut();
        this.logToStdOutCheckB.setSelected(bl);
        boolean bl2 = NalSimpleLog.getTheInstance().getLogToFile();
        this.logToFileCheckB.setSelected(bl2);
        String string2 = NalSimpleLog.getTheInstance().getLogFilePath();
        if (string2 != null) {
            this.logFilePath.setText(string2);
        }
        if ((string = NalSimpleLog.getTheInstance().getLogFileNamePrefix()) != null) {
            this.logFilePrefix.setText(string);
        }
        this.applyButton.setEnabled(false);
    }

    protected void setSelectedItem(JComboBox jComboBox, ComboBoxModel comboBoxModel) {
        Object object = comboBoxModel.getSelectedItem();
        jComboBox.setModel(comboBoxModel);
        if (object != null) {
            comboBoxModel.setSelectedItem(object);
        }
    }

    private DefaultComboBoxModel getLogLevels() {
        String[] stringArray = LOG_LEVEL_KEYS;
        int[] nArray = LOG_LEVEL_VALUES;
        DefaultComboBoxModel<LogLevel> defaultComboBoxModel = new DefaultComboBoxModel<LogLevel>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            LogLevel logLevel = new LogLevel(string, nArray[i]);
            defaultComboBoxModel.addElement(logLevel);
            if (nArray[i] != NalSimpleLog.getTheInstance().getTraceLevel()) continue;
            defaultComboBoxModel.setSelectedItem(logLevel);
        }
        return defaultComboBoxModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.perform();
        }
        this.okButton.removeActionListener(this);
        this.applyButton.removeActionListener(this.applyButtonAction);
        this.cancelButton.removeActionListener(this);
        this.logLevels.removeActionListener(this.editAction);
        this.logToStdOutCheckB.removeActionListener(this.editAction);
        this.logToFileCheckB.removeActionListener(this.editAction);
        this.logFilePrefix.removeActionListener(this.editAction);
        this.setVisible(false);
    }

    public boolean isResizable() {
        return true;
    }

    protected boolean perform() {
        return true;
    }

    protected void centerApplication(Component component) {
        int n = component.getX();
        int n2 = component.getY();
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        double d = n + (n3 - n5) / 2;
        double d2 = n2 + (n4 / 2 - n6 / 2);
        this.setLocation((int)d, (int)d2);
    }

    private static class LogLevel
    implements Comparable {
        private String label;
        private int value;

        protected LogLevel(String string, int n) {
            this.label = string;
            this.value = n;
        }

        public int compareTo(Object object) {
            return this.label.compareTo(((LogLevel)object).getLabel());
        }

        public boolean equals(Object object) {
            if (this.label == null || object == null || ((LogLevel)object).getLabel() == null) {
                return false;
            }
            return this.label.equals(((LogLevel)object).getLabel());
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        protected String getLabel() {
            return this.label;
        }

        protected int getValue() {
            return this.value;
        }

        public String toString() {
            return this.label;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(OptionsWindow.LOG_DATA_TO_FILE)) {
                if (OptionsWindow.this.logToFileCheckB.isSelected()) {
                    OptionsWindow.this.logFilePath.setEnabled(true);
                    OptionsWindow.this.logFilePrefix.setEnabled(true);
                } else {
                    OptionsWindow.this.logFilePath.setEnabled(false);
                    OptionsWindow.this.logFilePrefix.setEnabled(false);
                }
            }
            OptionsWindow.this.applyButton.setEnabled(true);
        }
    }

    private class ApplyButtonAction
    implements ActionListener {
        private ApplyButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OptionsWindow.this.perform()) {
                OptionsWindow.this.applyButton.setEnabled(false);
            }
        }
    }
}

