/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import se.ericsson.wcdma.rbs.bem.common.gui.components.AbstractGenLabelledField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.TranslatableComboBox;
import se.ericsson.wcdma.support.gui.gengui.SyntaxException;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;

class GenTranslatableStringComboBox
extends AbstractGenLabelledField
implements LocaleChangeListener,
ActionListener {
    private TranslatableComboBox boxes = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String myBundle = null;
    private boolean doActions = false;

    public GenTranslatableStringComboBox(String string, String string2, String[] stringArray, boolean bl) {
        super(string, string2);
        this.myBundle = string;
        this.boxes = new TranslatableComboBox(stringArray, bl);
        this.boxes.addActionListener(this);
        this.add(this.boxes);
    }

    public GenTranslatableStringComboBox(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, true);
    }

    public GenTranslatableStringComboBox(String string, String[] stringArray, boolean bl) {
        super(string);
        Log.traceFlow();
        this.boxes = new TranslatableComboBox(stringArray, bl);
        this.boxes.addActionListener(this);
        this.add(this.boxes);
    }

    public GenTranslatableStringComboBox(String string, String[] stringArray) {
        this(string, stringArray, true);
    }

    public void setActionListener(ActionListener actionListener, String string) {
        this.actionListener = actionListener;
        this.actionCommand = string;
        this.doActions = true;
    }

    public void setWidth(int n) {
        Dimension dimension = this.boxes.getPreferredSize();
        dimension.width = n;
        this.boxes.setPreferredSize(dimension);
    }

    public void setValue(String string) throws SyntaxException {
        Log.trace("setValue()");
        boolean bl = true;
        for (int i = 0; i < this.boxes.getTranslatableItemCount(); ++i) {
            if (!this.boxes.getTranslatableItemAt(i).equals(string)) continue;
            this.doActions = false;
            this.boxes.setSelectedIndex(i);
            this.doActions = true;
            bl = false;
        }
        if (bl) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        return (String)this.boxes.getTranslatableItemAt(this.boxes.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.boxes.getUnsortedIndex();
    }

    public void removeAllItems() {
        this.doActions = false;
        if (this.boxes.getItemCount() > 0) {
            this.boxes.removeAllItems();
        }
        this.layoutComponent();
        this.doActions = true;
    }

    public void addItems(String[] stringArray) {
        this.doActions = false;
        this.boxes.addTranslatableItems(stringArray);
        if (this.boxes.getSelectedIndex() == -1) {
            this.boxes.setSelectedIndex(0);
        }
        this.layoutComponent();
        this.doActions = true;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.boxes;
    }

    public void updateLocale(Locale locale) {
        this.doActions = false;
        Log.trace("translate()");
        super.updateLocale(locale);
        this.boxes.setBundle(GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader()));
        this.layoutComponent();
        this.doActions = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionListener != null && this.doActions) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
        }
    }
}

