/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import se.ericsson.wcdma.support.gui.guilib.infra.Translatable;

class TranslatableComboBox
extends JComboBox
implements Translatable {
    private String[] translatableTags;
    private ResourceBundle myBundle;
    private TranslatableListItem[] myListItems;
    private boolean sortingOn = true;
    private ActionListener actionListener;

    TranslatableComboBox(String[] stringArray, boolean bl) {
        super(stringArray);
        this.sortingOn = bl;
        this.addTranslatableItems(stringArray);
    }

    Object getTranslatableItemAt(int n) {
        if (n > this.getTranslatableItemCount() || this.myListItems == null) {
            return null;
        }
        return this.myListItems[n].myKey;
    }

    int getUnsortedIndex() {
        String string = (String)this.getTranslatableItemAt(this.getSelectedIndex());
        for (int i = 0; i < this.translatableTags.length; ++i) {
            if (!this.translatableTags[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void removeAllItems() {
        if (this.getItemCount() > 0) {
            super.removeAllItems();
        }
        this.translatableTags = null;
        this.myListItems = null;
    }

    void setBundle(ResourceBundle resourceBundle) {
        this.myBundle = resourceBundle;
        this.updateLocale();
    }

    void addTranslatableItems(String[] stringArray) {
        int n;
        if (this.translatableTags == null) {
            this.translatableTags = stringArray;
        } else {
            int n2;
            n = stringArray.length + this.translatableTags.length;
            String[] stringArray2 = this.translatableTags;
            this.translatableTags = new String[n];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                this.translatableTags[n2] = stringArray2[n2];
            }
            for (n2 = stringArray2.length; n2 < n; ++n2) {
                this.translatableTags[n2] = stringArray[n2 - stringArray2.length];
            }
        }
        if (this.myBundle != null) {
            this.updateLocale();
        } else {
            this.removeActionListener(this.actionListener);
            this.myListItems = new TranslatableListItem[this.translatableTags.length];
            for (n = 0; n < this.translatableTags.length; ++n) {
                this.myListItems[n] = new TranslatableListItem(this.translatableTags[n], this.translatableTags[n]);
            }
            if (this.sortingOn) {
                Arrays.sort(this.myListItems);
            }
            for (n = 0; n < this.myListItems.length; ++n) {
                this.addItem(this.myListItems[n].myTranslation);
            }
            super.addActionListener(this.actionListener);
        }
    }

    int getTranslatableItemCount() {
        if (this.myListItems == null) {
            return 0;
        }
        return this.myListItems.length;
    }

    void updateLocale() {
        int n;
        this.removeActionListener(this.actionListener);
        String[] stringArray = this.translatableTags;
        int n2 = this.getSelectedIndex();
        String string = null;
        if (this.myListItems != null && n2 > -1) {
            string = this.myListItems[n2].myKey;
        }
        if (this.getItemCount() > 0) {
            this.removeAllItems();
        }
        this.myListItems = new TranslatableListItem[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) {
                String string2 = null;
                try {
                    string2 = this.myBundle.getString(stringArray[n]);
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = stringArray[n];
                }
                this.myListItems[n] = new TranslatableListItem(stringArray[n], string2);
                continue;
            }
            this.myListItems[n] = new TranslatableListItem("<ERROR: NULL KEY>", "<ERROR: NULL KEY>");
        }
        if (this.sortingOn) {
            Arrays.sort(this.myListItems);
        }
        for (n = 0; n < this.myListItems.length; ++n) {
            this.addItem(this.myListItems[n].myTranslation);
        }
        if (string == null) {
            this.setSelectedIndex(0);
        } else {
            for (n = 0; n < this.myListItems.length; ++n) {
                if (!this.myListItems[n].myKey.equals(string)) continue;
                this.setSelectedIndex(n);
            }
        }
        this.translatableTags = stringArray;
        super.addActionListener(this.actionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
        this.actionListener = actionListener;
    }

    public void translate(ResourceBundle resourceBundle, Locale locale) {
        this.myBundle = resourceBundle;
        this.updateLocale();
    }

    public static class TranslatableListItem
    implements Comparable {
        String myKey;
        String myTranslation;

        TranslatableListItem(String string, String string2) {
            this.myKey = string;
            this.myTranslation = string2;
        }

        public int compareTo(Object object) {
            String string = ((TranslatableListItem)object).myTranslation;
            return this.myTranslation.compareToIgnoreCase(string);
        }
    }
}

