/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.log;

import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configlogic.RbsNclException;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogUtil;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.script.BemScriptUtil;

public class BemLogAndScriptUtil {
    public static boolean generateScripts;
    private static BemLogAndScriptUtil singletonInstance;
    private final NalLog nalLog = Nal.newLog("se.ericsson.wcdma.rbs.bem");
    private static final String BEM_SCRIPT_UTIL_IMPL_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.script.impl.client.BemScriptUtilImpl";
    private BemScriptUtil bemScriptUtil = null;

    private BemLogAndScriptUtil() {
    }

    public static synchronized BemLogAndScriptUtil getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new BemLogAndScriptUtil();
        }
        return singletonInstance;
    }

    public void logStartConfigurationProcedure(String string) {
        this.nalLog.nalTrace(4, this.getClass(), "----- StartConfigurationProcedure --- " + string + "-------------------------------------");
        if (this.bemScriptUtil == null) {
            this.bemScriptUtil = this.newBemScriptUtil();
        }
        if (this.bemScriptUtil != null) {
            this.bemScriptUtil.scriptStartConfigurationProcedure(string);
        }
    }

    public void logStartConfigurationStep(String string) {
        this.nalLog.nalTrace(4, this.getClass(), "----- StartConfigurationStep --- " + string + "------------------");
        if (this.bemScriptUtil != null) {
            this.bemScriptUtil.scriptStartConfigurationStep(string);
        }
    }

    public void logEndConfigurationStep() {
        if (this.bemScriptUtil != null) {
            this.bemScriptUtil.scriptEndConfigurationStep();
        }
    }

    public void logEndConfigurationProcedure() {
        if (this.bemScriptUtil != null) {
            this.bemScriptUtil.scriptEndConfigurationProcedure();
        }
    }

    public void logIsExisting(BemMo bemMo) {
    }

    public void logCreate(BemMo bemMo) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptCreate(bemMo);
        }
    }

    public void logCreate(BemMo bemMo, NalNameValue[] nalNameValueArray) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptCreate(bemMo, nalNameValueArray);
        }
    }

    public void logDelete(BemMo bemMo) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptDelete(bemMo);
        }
    }

    public void logAction(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptAction(bemMo, string, nalNameValueArray);
        }
    }

    public void logAction(BemMo bemMo, String string, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptAction(bemMo, string, nalNameValueArray, nalTransaction);
        }
    }

    public void logGetChildren(BemMo bemMo) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptGetChildren(bemMo);
        }
    }

    public void logGetChildren(BemMo bemMo, int n, String string, String string2) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptGetChildren(bemMo, n, string, string2);
        }
    }

    public void logGetAttributes(BemMo bemMo, String[] stringArray) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptGetAttributes(bemMo, stringArray);
        }
    }

    public void logGetAttribute(BemMo bemMo, String string) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptGetAttribute(bemMo, string);
        }
    }

    public void logSetAttribute(BemMo bemMo, String string, Object object) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptSetAttribute(bemMo, string, object);
        }
    }

    public void logSetAttributes(BemMo bemMo, NalNameValue[] nalNameValueArray) {
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptSetAttributes(bemMo, nalNameValueArray);
        }
    }

    public void logResult(BemMo bemMo, Object object) {
    }

    public static void logBeginTransaction() {
        BemLogUtil.logTransaction("beginTransaction", null);
    }

    public static void logEndTransaction(boolean bl) {
        BemLogUtil.logTransaction("endTransaction", bl);
    }

    public void log(int n, String string) {
        BemLog.log(n, string);
        if (this.isScriptActive()) {
            this.bemScriptUtil.scriptAddComment(string);
        }
    }

    private BemScriptUtil newBemScriptUtil() {
        boolean bl = Nal.executesOnClient();
        if (!bl) {
            return null;
        }
        String string = "PROGRAMMING ERROR! Failed to construct a new instance of class \n   se.ericsson.wcdma.rbs.bem.common.script.impl.client.BemScriptUtilImpl";
        try {
            Class<?> clazz = Class.forName(BEM_SCRIPT_UTIL_IMPL_CLASS_NAME);
            Object obj = clazz.newInstance();
            Nal.getLog().nalTrace(4, this.getClass(), "The BemScriptUtil has been instanciated.");
            return (BemScriptUtil)obj;
        }
        catch (Exception exception) {
            Nal.getLog().nalTraceError(this.getClass(), string, exception);
            throw new RbsNclException(string, exception);
        }
    }

    private boolean isScriptActive() {
        boolean bl = this.bemScriptUtil != null && this.bemScriptUtil.isActive();
        return bl;
    }

    static {
        singletonInstance = null;
    }
}

