/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;

class NalMoMsg {
    private static NalLog nalLog = Nal.newLog("se.ericsson.wcdma.rbs.bem");
    private final int logLevel;
    private final StringBuffer headerBuffer = new StringBuffer(32);
    private final StringBuffer paramBuffer = new StringBuffer();
    private NalMo theMo;
    private NalTransaction theTransaction;

    private NalMoMsg(int n) {
        this.logLevel = n;
    }

    public static NalMoMsg newLog(int n) {
        if (nalLog.isTraced(n)) {
            return new NalMoMsg(n);
        }
        return null;
    }

    public void addHeader(String string, NalMo nalMo, String string2) {
        this.headerBuffer.append(string);
        this.headerBuffer.append(" ");
        if (nalMo != null) {
            String string3 = nalMo.getType();
            this.headerBuffer.append(string3);
        }
        if (string2 != null) {
            this.headerBuffer.append(".");
            this.headerBuffer.append(string2);
        }
    }

    public void addParam(String string, NalNameValue[] nalNameValueArray) {
        String string2 = NalMoMsg.arrayToString(nalNameValueArray);
        this.paramBuffer.append(" ").append(string).append(" = ");
        this.paramBuffer.append(string2);
    }

    public void addParam(String string, String string2) {
        this.paramBuffer.append(" ").append(string).append(" = ");
        this.paramBuffer.append(string2);
    }

    public void addParam(String string, String[] stringArray) {
        this.paramBuffer.append(" ").append(string).append(" = ");
        String string2 = null;
        if (stringArray != null) {
            string2 = NalMoMsg.arrayToString(stringArray);
        }
        this.paramBuffer.append(string2);
    }

    public void addAttributeNames(String[] stringArray) {
        this.paramBuffer.append(" AttributeNames: ");
        String string = null;
        if (stringArray != null) {
            string = NalMoMsg.arrayToString(stringArray);
        }
        this.paramBuffer.append(string);
    }

    public void addValue(Object object) {
        this.paramBuffer.append(" value = ");
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            String string = NalMoMsg.arrayToString(objectArray);
            this.paramBuffer.append(string);
        } else {
            this.paramBuffer.append(object);
        }
    }

    public void addTail(NalMo nalMo, NalTransaction nalTransaction) {
        this.theMo = nalMo;
        this.theTransaction = nalTransaction;
    }

    public void logMoOperation() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("NalMo ");
        stringBuffer.append(this.headerBuffer);
        stringBuffer.append(" :");
        if (this.paramBuffer.length() > 0) {
            stringBuffer.append(this.paramBuffer).append(" , ");
        } else {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.theMo);
        stringBuffer.append(" , transaction = ").append(this.theTransaction);
        String string = stringBuffer.toString();
        nalLog.nalTrace(this.logLevel, NalMo.class, string);
    }

    public void logResult(Object object) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("NalMo - result of ");
        stringBuffer.append(this.headerBuffer);
        stringBuffer.append(" = ");
        if (object instanceof Object[]) {
            object2 = (Object[])object;
            String string = NalMoMsg.arrayToString(object2);
            stringBuffer.append(string);
        } else {
            stringBuffer.append(object);
        }
        stringBuffer.append(" , transaction = ").append(this.theTransaction);
        object2 = stringBuffer.toString();
        nalLog.nalTrace(this.logLevel, NalMo.class, (String)object2);
    }

    private static String arrayToString(Object[] objectArray) {
        String string = null;
        if (objectArray != null) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                if ((object = objectArray[i]) == null) {
                    stringBuffer.append("null");
                    continue;
                }
                String string2 = NalMoMsg.getDataType(object);
                String string3 = NalMoMsg.convertValueToString(object);
                stringBuffer.append("[").append(i).append("] ");
                stringBuffer.append(string3).append(" ").append(string2);
            }
            stringBuffer.append("}");
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String getDataType(Object object) {
        String string = "(unknown type)";
        if (object == null) {
            string = "(null)";
            object = "";
        } else if (object instanceof String) {
            string = "(String)";
        } else if (object instanceof Integer) {
            string = "(Integer)";
        } else if (object instanceof Float) {
            string = "(Float)";
        } else if (object instanceof Boolean) {
            string = "(Boolean)";
        } else if (object instanceof Long) {
            string = "(Long)";
        } else if (object instanceof NalMo) {
            string = "(MoRef)";
        } else if (object instanceof NalNameValue) {
            NalNameValue nalNameValue = (NalNameValue)object;
            string = NalMoMsg.getDataType(nalNameValue.getValue());
        } else {
            string = object instanceof NalStruct ? "(Struct)" : (object instanceof NalMo[] ? "(MoRef[])" : (object instanceof Integer[] ? "(Integer[])" : (object instanceof int[] ? "(int[])" : (object instanceof Float[] ? "(Float[])" : (object instanceof float[] ? "(float[])" : (object instanceof String[] ? "(String[])" : (object instanceof NalStruct[] ? "(Struct[])" : ("se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl".equals(object.getClass().getName()) ? "(BemMo)" : "(unknown type)"))))))));
        }
        return string;
    }

    private static String convertValueToString(Object object) {
        StringBuffer stringBuffer;
        if (object instanceof NalMo[] || object instanceof Integer[] || object instanceof Float[] || object instanceof String[] || object instanceof NalStruct[]) {
            stringBuffer = new StringBuffer(NalMoMsg.arrayToString((Object[])object));
        } else if (object instanceof int[]) {
            stringBuffer = new StringBuffer(NalMoMsg.intArrayToString((int[])object));
        } else if (object instanceof float[]) {
            stringBuffer = new StringBuffer(NalMoMsg.floatArrayToString((float[])object));
        } else if (object instanceof NalStruct[]) {
            NalStruct[] nalStructArray = (NalStruct[])object;
            stringBuffer = new StringBuffer("{");
            for (int i = 0; i < nalStructArray.length; ++i) {
                stringBuffer.append("[").append(i).append("] ");
                Object[] objectArray = nalStructArray[i].getNameValueArray();
                stringBuffer.append(NalMoMsg.arrayToString(objectArray));
                stringBuffer.append("}");
            }
        } else {
            stringBuffer = object == null ? new StringBuffer("null") : new StringBuffer(object.toString());
        }
        return stringBuffer.toString();
    }

    private static String intArrayToString(int[] nArray) {
        String string = null;
        if (nArray != null) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < nArray.length; ++i) {
                String string2 = "null";
                string2 = "[" + i + "] " + nArray[i] + " (int)";
                stringBuffer.append(string2);
            }
            stringBuffer.append("}");
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String floatArrayToString(float[] fArray) {
        String string = null;
        if (fArray != null) {
            StringBuffer stringBuffer = new StringBuffer("{");
            for (int i = 0; i < fArray.length; ++i) {
                String string2 = "null";
                string2 = "[" + i + "] " + fArray[i] + " (float)";
                stringBuffer.append(string2);
            }
            stringBuffer.append("}");
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        return this.headerBuffer.toString();
    }
}

