/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.log;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalAwareNativeObject;

public class NalTransactionLog
implements NalTransaction,
NalAwareNativeObject {
    private final NalTransaction delegate;
    private final NalLog log = Nal.getLog();

    NalTransactionLog(NalTransaction nalTransaction) {
        this.delegate = nalTransaction;
    }

    public Object getNative() {
        return this.delegate.getNative();
    }

    public void commit() throws NalCmException {
        int n = NalTransactionLog.getLogLevel(this.isNullTransaction());
        if (this.log.isTraced(n)) {
            this.log.nalTrace(n, this.delegate.getClass(), "NalTransaction.commit( this=" + this + ")");
        }
        this.delegate.commit();
    }

    public void rollback(String string, Throwable throwable) throws NalCmException {
        int n = NalTransactionLog.getLogLevel(this.isNullTransaction());
        if (this.log.isTraced(n)) {
            String string2;
            String string3 = string2 = throwable == null ? "" : ", cause=" + throwable;
            if (-1 != string2.indexOf(10)) {
                string2 = ", cause=" + throwable.getClass().getName();
            }
            this.log.nalTrace(n, this.delegate.getClass(), "NalTransaction.rollback( this=" + this + (string == null ? "" : ", message=" + string) + string2 + ")");
        }
        this.delegate.rollback(string, throwable);
    }

    public static int getLogLevel(boolean bl) {
        int n = bl ? 7 : 6;
        return n;
    }

    public boolean isNullTransaction() {
        return this.delegate.isNullTransaction();
    }

    public NalObject getNalWrapper() {
        return this.delegate;
    }

    public String toString() {
        String string = ((Object)this.delegate).toString();
        return string;
    }
}

