/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.nex;

import java.util.Properties;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.neal.Node;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperty;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactoryParameters;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalProgress;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalBackendNeal;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalFactoryNeal;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalFactoryNexParameters;

public class NalFactoryNex
extends NalFactoryNeal
implements NalFactory {
    private final LauncherInterface launcher;
    private final Properties properties;
    private final String nodeServicesXml;

    public NalFactoryNex(NalFactoryParameters nalFactoryParameters) {
        NalFactoryNexParameters nalFactoryNexParameters = (NalFactoryNexParameters)nalFactoryParameters;
        if (nalFactoryNexParameters == null || nalFactoryNexParameters.launcher == null) {
            throw new NalCmException("Connection failed. Internal error. Launcher object not set");
        }
        if (nalFactoryNexParameters.properties == null) {
            throw new NalCmException("Connection failed. Internal error. Launcher properties not set");
        }
        this.launcher = nalFactoryNexParameters.launcher;
        this.properties = nalFactoryNexParameters.properties;
        this.nodeServicesXml = LaunchProperty.NODESERVICES_CONFIG.get(this.properties);
    }

    public String getNalType() {
        return "nex";
    }

    public synchronized void connectToMib(String string) {
        NodeServices nodeServices = null;
        try {
            this.getLog().nalTrace(4, this.getClass(), "Trying to connect to CPP NodeServices object with hostname=" + string + " and nodeServicesXml=" + this.nodeServicesXml);
            nodeServices = (NodeServices)this.launcher.runResource(this.nodeServicesXml, string, this.properties, null);
            this.getLog().nalTrace(6, this.getClass(), "Connected to CPP NodeServices object: " + nodeServices);
        }
        catch (Exception exception) {
            this.getLog().nalTraceError(this.getClass(), "Unable to connected to CPP NodeServices with host name = " + string, exception);
            throw new NalCmException("Unable to connect to RBS: " + string, exception);
        }
        Node node = nodeServices.getNode();
        NalBackendNeal.setNode(string, node);
    }

    public synchronized void reconnectMib(String string, NalProgress nalProgress) {
        super.reconnectMib(string, nalProgress);
    }
}

