/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlSource;
import se.ericsson.wcdma.rbs.bem.common.service.BemServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.Source;
import se.ericsson.wcdma.rbs.bem.common.service.gen.RBSPseudoDef;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DeprecationConverter {
    private String aDtdFilePathName;

    public DeprecationConverter() {
    }

    public DeprecationConverter(String string) {
        this.aDtdFilePathName = string;
    }

    public void convert(BemServiceValue bemServiceValue) throws BemXmlException {
        ServiceNameValue serviceNameValue;
        Object object;
        Object object2;
        String[] stringArray;
        String[] stringArray2;
        Object object3;
        Object object4;
        ServiceNameValue serviceNameValue2;
        Object object5;
        Object object6;
        Object object7;
        ServiceNameValue serviceNameValue3;
        Object object82;
        ServiceNameValue serviceNameValue4;
        ServiceNameValue serviceNameValue5;
        ServiceNameValue serviceNameValue6;
        ServiceNameValue serviceNameValue7;
        Object object9;
        if (null != bemServiceValue.getValue("auHubType")) {
            object9 = this.getSourceLineInfo(bemServiceValue.getAttribute("auHubType"));
            bemServiceValue.addDeprecationWarning((Integer)object9, "auHubType=\"" + bemServiceValue.getValue("auHubType") + "\"" + " is ignored");
        }
        if ((object9 = bemServiceValue.getAttribute("ethernetIpAddress")) != null) {
            this.convertIpOverEtherNetIpAdressInOam(bemServiceValue, (ServiceNameValue)object9);
        }
        if ((serviceNameValue7 = bemServiceValue.getAttribute("CAB1_supportSystemControl")) != null) {
            this.convertSupportSystemControl(bemServiceValue, serviceNameValue7);
        }
        if ((serviceNameValue6 = bemServiceValue.getAttribute("slotsForETMFX")) != null) {
            this.convertSlotsForEtmfx(bemServiceValue, serviceNameValue6);
        }
        if ((serviceNameValue5 = bemServiceValue.getAttribute("ethernetSubnetMask")) != null) {
            this.convertIpOverEtherNetSubnetMaskInOam(bemServiceValue, serviceNameValue5);
        }
        if ((serviceNameValue4 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("slotsForHsdpa"))) != null) {
            this.convertHsdpa(bemServiceValue, serviceNameValue4);
        }
        this.convertFreqBandHiAndLoEdge(bemServiceValue);
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(RBSPseudoDef.getPseudoName("radioBuildingBlock"));
        for (Object object82 : vector) {
            if (object82 == null) continue;
            this.convertRadioBuildingBlock(bemServiceValue, (ServiceNameValue)object82);
        }
        object82 = bemServiceValue.getAllAttributesWithSimpleName(RBSPseudoDef.getPseudoName("band"));
        Iterator iterator = object82.iterator();
        while (iterator.hasNext()) {
            serviceNameValue3 = (ServiceNameValue)iterator.next();
            if (serviceNameValue3 == null) continue;
            this.convertBand(bemServiceValue, serviceNameValue3);
        }
        serviceNameValue3 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("numberOfSectors"));
        if (serviceNameValue3 != null) {
            this.ignoreAttribute(bemServiceValue, serviceNameValue3);
        }
        ServiceNameValue serviceNameValue8 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantTiming"));
        ServiceNameValue serviceNameValue9 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantSwitching"));
        ServiceNameValue serviceNameValue10 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantMP"));
        ServiceNameValue[] serviceNameValueArray = new ServiceNameValue[]{serviceNameValue10, serviceNameValue8, serviceNameValue9};
        ServiceNameValue serviceNameValue11 = this.findFirstSetTo(serviceNameValueArray, "YES");
        if (serviceNameValue11 != null) {
            object7 = RBSPseudoDef.getPseudoName("redundantControlSystem");
            this.convertTo(bemServiceValue, serviceNameValue11, (String)object7, "YES");
        } else {
            object7 = this.findFirstSetTo(serviceNameValueArray, "NO");
            if (object7 != null) {
                object6 = RBSPseudoDef.getPseudoName("redundantControlSystem");
                this.convertTo(bemServiceValue, (ServiceNameValue)object7, (String)object6, "NO");
            }
        }
        object7 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("useInternalPower"));
        if (object7 != null) {
            this.convertTo(bemServiceValue, (ServiceNameValue)object7, "configurePowerSupply", ((ServiceNameValue)object7).getValueAsString());
        }
        if ((object6 = bemServiceValue.getAttribute("CAB1_" + RBSPseudoDef.getPseudoName("typeOfPowerSupply"))) != null) {
            object5 = "YES";
            if (((ServiceNameValue)object6).getValue().equals("MINUS_48VDC")) {
                object5 = "NO";
            }
            this.convertTo(bemServiceValue, (ServiceNameValue)object6, "configurePowerSupply", (String)object5);
        }
        if ((object5 = bemServiceValue.getAttribute("CAB1_" + RBSPseudoDef.getPseudoName("batteryBackup"))) != null) {
            this.convertTo(bemServiceValue, (ServiceNameValue)object5, "configureBatteryBackup", ((ServiceNameValue)object5).getValueAsString());
        }
        if ((serviceNameValue2 = bemServiceValue.getAttribute("CAB1_" + RBSPseudoDef.getPseudoName("isXalmInstalled"))) != null) {
            this.convertTo(bemServiceValue, serviceNameValue2, "configureXalm", serviceNameValue2.getValueAsString());
        }
        for (int i = 1; i < 7; ++i) {
            int n = i + 1;
            object4 = MessageFormat.format("CAB{0}_", new Integer(n));
            object3 = bemServiceValue.getAttribute((String)object4 + RBSPseudoDef.getPseudoName("useExternalPowerSupply"));
            if (object3 != null) {
                this.convertTo(bemServiceValue, (ServiceNameValue)object3, "configurePowerSupply", ((ServiceNameValue)object3).getValueAsString());
            }
            if ((stringArray2 = bemServiceValue.getAttribute((String)object4 + RBSPseudoDef.getPseudoName("useExternalBatteryBackup"))) == null) continue;
            this.convertTo(bemServiceValue, (ServiceNameValue)stringArray2, "configureBatteryBackup", stringArray2.getValueAsString());
        }
        Vector vector2 = bemServiceValue.getAllAttributesWithSimpleName("tmaType");
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (ServiceNameValue)enumeration.nextElement();
            if (!((ServiceNameValue)object4).getValue().equals("RET")) continue;
            this.convertTo(bemServiceValue, (ServiceNameValue)object4, "tmaType", "ASC");
            this.convertTo(bemServiceValue, (ServiceNameValue)object4, "configureRet", "YES");
        }
        object4 = bemServiceValue.getAllAttributesWithSimpleName("configureRet");
        object3 = ((Vector)object4).elements();
        block4: while (object3.hasMoreElements()) {
            stringArray2 = (String[])object3.nextElement();
            if (!stringArray2.getValue().equals("YES")) continue;
            stringArray = bemServiceValue.getAllAttributesWithSimpleName("typeOfRet");
            Enumeration enumeration2 = stringArray.elements();
            object2 = null;
            while (enumeration2.hasMoreElements()) {
                object2 = (ServiceNameValue)enumeration2.nextElement();
                if (!((ServiceNameValue)object2).getPrefix().equals(stringArray2.getPrefix())) continue;
                if (((ServiceNameValue)object2).getValueAsString().equals("ARETU")) {
                    this.convertTo(bemServiceValue, (ServiceNameValue)stringArray2, "typeOfRet", "ARETU");
                    continue block4;
                }
                this.convertTo(bemServiceValue, (ServiceNameValue)stringArray2, "typeOfRet", "RETU");
                continue block4;
            }
        }
        stringArray2 = new String[]{"dlJumperAttenuationBranchA", "ulJumperAttenuationBranchA", "dlJumperDelayBranchA", "ulJumperDelayBranchA", "dlJumperAttenuationBranchB", "ulJumperAttenuationBranchB", "dlJumperDelayBranchB", "ulJumperDelayBranchB"};
        stringArray = new String[]{"dlFeederAttenuationBranchA", "ulFeederAttenuationBranchA", "dlFeederDelayBranchA", "ulFeederDelayBranchA", "dlFeederAttenuationBranchB", "ulFeederAttenuationBranchB", "dlFeederDelayBranchB", "ulFeederDelayBranchB"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.convertJumperCableParam(bemServiceValue, stringArray2[i], stringArray[i]);
        }
        Vector vector3 = bemServiceValue.getAllAttributesWithSimpleName("frequencyPlanes");
        object2 = vector3.elements();
        while (object2.hasMoreElements()) {
            object = (ServiceNameValue)object2.nextElement();
            if (object == null) continue;
            this.ignoreAttribute(bemServiceValue, (ServiceNameValue)object);
        }
        object = bemServiceValue.getAllAttributesWithSimpleName("frequencyPlane");
        Enumeration enumeration3 = ((Vector)object).elements();
        while (enumeration3.hasMoreElements()) {
            ServiceNameValue serviceNameValue12 = (ServiceNameValue)enumeration3.nextElement();
            if (serviceNameValue12 == null) continue;
            this.ignoreAttribute(bemServiceValue, serviceNameValue12);
        }
        for (int i = 1; i <= 6; ++i) {
            String string = MessageFormat.format("S{0}_", new Integer(i));
            serviceNameValue = bemServiceValue.getAttribute(string + "numberOfRu");
            ServiceNameValue serviceNameValue13 = bemServiceValue.getAttribute(string + "numberOfCarriers");
            ServiceNameValue serviceNameValue14 = bemServiceValue.getAttribute("radioIfType");
            if (serviceNameValue == null || serviceNameValue13 == null) continue;
            if (serviceNameValue14 != null && serviceNameValue14.getValue().equals("OBIF")) {
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + " and " + serviceNameValue13 + " are ignored");
                continue;
            }
            this.convertNoOfRusAndCarriers(bemServiceValue, serviceNameValue, serviceNameValue13);
        }
        String[] stringArray3 = new String[]{"productName", "productNumber", "productRevision", "productionDate", "serialNumber"};
        for (int i = 0; i < stringArray3.length; ++i) {
            serviceNameValue = bemServiceValue.getAttribute(stringArray3[i]);
            if (serviceNameValue == null) continue;
            this.ignoreAttribute(bemServiceValue, serviceNameValue);
        }
        this.convertRruInstalledParam(bemServiceValue);
        this.convertCpriLineRateParam(bemServiceValue);
        this.convertNeedRuPositionAllocationParam(bemServiceValue);
        this.convertGpsAttrs2TimingUnitConf(bemServiceValue);
        this.convertSwitchComSupSysAtrrs2ConfigPowerBattery(bemServiceValue);
        this.updateNeedRuPositionAllocation(bemServiceValue);
    }

    private void convertNoOfRusAndCarriers(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, ServiceNameValue serviceNameValue2) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue2.getValueAsString();
        String string3 = serviceNameValue.getServiceName();
        String string4 = serviceNameValue.getPrefix();
        Source source = serviceNameValue.getInputSource();
        String string5 = "radioBuildingBlock";
        String string6 = this.getRadioBuildingBlock(string, string2);
        ServiceNameValue serviceNameValue3 = new ServiceNameValue(string3, string4, string5, string6, source);
        bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + " and " + serviceNameValue2 + "\nwas converted to " + serviceNameValue3);
        bemServiceValue.addAttribute(string3, serviceNameValue3);
    }

    private String getRadioBuildingBlock(String string, String string2) {
        Integer n = new Integer(string);
        switch (n) {
            case 1: {
                if (string2.equals("1")) {
                    return "RB1";
                }
                if (string2.equals("2")) {
                    return "RB4";
                }
            }
            case 2: {
                if (!string2.equals("2")) break;
                return "RB3";
            }
        }
        return null;
    }

    private void convertHsdpa(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        ServiceNameValue serviceNameValue2 = serviceNameValue;
        String string = serviceNameValue.getValueAsString();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        String string2 = serviceNameValue.getServiceName();
        String string3 = "numHsCodeResources";
        String string4 = "1";
        Source source = serviceNameValue.getInputSource();
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("0")) continue;
            string5 = MessageFormat.format("hsSlot{0}_", stringArray[i]);
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(string2, string5, string3, string4, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue2), serviceNameValue2 + "\nwas converted to " + serviceNameValue3);
            bemServiceValue.addAttribute(string2, serviceNameValue3);
        }
    }

    private void convertSlotsForEtmfx(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (!string.equals("0")) {
            String string2 = serviceNameValue.getServiceName();
            String string3 = "slotsForETMFX11";
            String string4 = string;
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
            bemServiceValue.addAttribute(string2, serviceNameValue2);
        }
    }

    private void convertIpOverEtherNetIpAdressInOam(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "ipAddress";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertSupportSystemControl(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "supportSystemControl";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertIpOverEtherNetSubnetMaskInOam(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "subnetMask";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertRadioBuildingBlock(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (string.equals("RBB12_2A")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB12_1A");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB22_2C")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB22_1B");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB22_4B")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB22_2B");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB42_4A")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB42_2D");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        }
    }

    private void setMixedModeRadio(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = "SectorData";
        String string2 = serviceNameValue.getPrefix();
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string, string2, "mixedModeRadio", "TRUE", source);
        bemServiceValue.addAttribute(string, serviceNameValue2);
    }

    private void convertBand(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (string.equals("0")) {
            ServiceNameValue serviceNameValue2;
            IntegerRange integerRange = new IntegerRange(21100, 21650);
            IntegerRange integerRange2 = new IntegerRange(19300, 19850);
            IntegerRange integerRange3 = new IntegerRange(8690, 8890);
            IntegerRange integerRange4 = new IntegerRange(21150, 21700);
            IntegerRange integerRange5 = new IntegerRange(19350, 19900);
            IntegerRange integerRange6 = new IntegerRange(8740, 8940);
            IntegerRange[] integerRangeArray = new IntegerRange[]{integerRange, integerRange2, integerRange3};
            IntegerRange[] integerRangeArray2 = new IntegerRange[]{integerRange4, integerRange5, integerRange6};
            String[] stringArray = new String[]{"1", "2", "5"};
            if (string.equals("0") && (serviceNameValue2 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "fqBandHighEdgeBranchA")) != null) {
                String string2 = serviceNameValue2.getValueAsString();
                ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "fqBandLowEdgeBranchA");
                if (serviceNameValue3 != null) {
                    String string3 = serviceNameValue3.getValueAsString();
                    for (int i = 0; i < integerRangeArray.length; ++i) {
                        boolean bl = integerRangeArray2[i].isValueInRange(string2);
                        boolean bl2 = integerRangeArray[i].isValueInRange(string3);
                        if (!bl2 || !bl) continue;
                        this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private void convertFreqBandHiAndLoEdge(BemServiceValue bemServiceValue) {
        String[][] stringArrayArray = new String[][]{{"freqBandHiEdge", "fqBandHighEdgeBranch"}, {"freqBandLoEdge", "fqBandLowEdgeBranch"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string = stringArrayArray[i][0];
            String string2 = stringArrayArray[i][1];
            Vector vector = bemServiceValue.getAttributesStartingWith(string);
            for (ServiceNameValue serviceNameValue : vector) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(serviceNameValue.getName(), "_");
                if (stringTokenizer.countTokens() != 3) continue;
                String string4 = stringTokenizer.nextToken() + "_";
                String string5 = stringTokenizer.nextToken();
                String string6 = serviceNameValue.getServiceName();
                String string7 = string3 = serviceNameValue.getValueAsString();
                if (string3 != null && !string3.equals("")) {
                    try {
                        int n = Integer.parseInt(string3) * 2;
                        string7 = String.valueOf(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                bemServiceValue.addAttribute(string6, new ServiceNameValue(string6, string4, string2 + string5, string7, serviceNameValue.getInputSource()));
            }
        }
        String[][] stringArrayArray2 = new String[][]{{"freqBandHiEdgeBranchA", "fqBandHighEdgeBranchA"}, {"freqBandLoEdgeBranchA", "fqBandLowEdgeBranchA"}, {"freqBandHiEdgeBranchB", "fqBandHighEdgeBranchB"}, {"freqBandLoEdgeBranchB", "fqBandLowEdgeBranchB"}, {"freqBandHiEdgeBranchC", "fqBandHighEdgeBranchC"}, {"freqBandLoEdgeBranchC", "fqBandLowEdgeBranchC"}, {"freqBandHiEdgeBranchD", "fqBandHighEdgeBranchD"}, {"freqBandLoEdgeBranchD", "fqBandLowEdgeBranchD"}, {"freqBandHiEdgeBranchE", "fqBandHighEdgeBranchE"}, {"freqBandLoEdgeBranchE", "fqBandLowEdgeBranchE"}, {"freqBandHiEdgeBranchF", "fqBandHighEdgeBranchF"}, {"freqBandLoEdgeBranchF", "fqBandLowEdgeBranchF"}};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            this.convertFqBandEgdeWithSimpleName(bemServiceValue, stringArrayArray2[i][0], stringArrayArray2[i][1]);
        }
    }

    private void convertFqBandEgdeWithSimpleName(BemServiceValue bemServiceValue, String string, String string2) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(string);
        for (ServiceNameValue serviceNameValue : vector) {
            String string3;
            String string4 = string3 = (String)serviceNameValue.getValue();
            if (string3 != null && !string3.equals("")) {
                try {
                    int n = Integer.parseInt(string3) * 2;
                    string4 = String.valueOf(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.convertTo(bemServiceValue, serviceNameValue, string2, string4);
        }
    }

    private void convertJumperCableParam(BemServiceValue bemServiceValue, String string, String string2) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (serviceNameValue == null) continue;
            this.addToListParamater(bemServiceValue, serviceNameValue, string2);
        }
    }

    private void convertRruInstalledParam(BemServiceValue bemServiceValue) {
        this.convertRruInstalledWithSimpleName(bemServiceValue);
    }

    private void convertRruInstalledWithSimpleName(BemServiceValue bemServiceValue) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("rruInstalled");
        for (ServiceNameValue serviceNameValue : vector) {
            String string = serviceNameValue.getValueAsString();
            if (!string.equals("YES")) continue;
            this.convertTo(bemServiceValue, serviceNameValue, "auUnitType", "RRU22");
        }
    }

    private void convertGpsAttrs2TimingUnitConf(BemServiceValue bemServiceValue) {
        if (this.getaDtdFilePathName().indexOf("SiteEquipment.dtd") != -1) {
            ServiceNameValue serviceNameValue = bemServiceValue.getAttribute("CAB1_gpsOutEnabled");
            ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute("CAB1_gpsOutEnabledOnSlot2");
            ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute("CAB1_absoluteTimeSynchEnabled");
            if (serviceNameValue != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue, "gpsOutEnabled", serviceNameValue.getValueAsString());
            }
            if (serviceNameValue2 != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue2, "gpsOutEnabledOnSlot2", serviceNameValue2.getValueAsString());
            }
            if (serviceNameValue3 != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue3, "absoluteTimeSynchEnabled", serviceNameValue3.getValueAsString());
            }
        }
    }

    private void convertSwitchComSupSysAtrrs2ConfigPowerBattery(BemServiceValue bemServiceValue) {
        if (this.getaDtdFilePathName().indexOf("ExpandAndModifyRbs.dtd") != -1) {
            String string = "CAB1s_";
            String string2 = "CAB1_";
            Vector vector = bemServiceValue.getAttributesStartingWith("CAB1s_");
            if (vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    ServiceNameValue serviceNameValue;
                    ServiceNameValue serviceNameValue2 = (ServiceNameValue)vector.get(i);
                    String string3 = serviceNameValue2.getPrefix();
                    int n = string3.indexOf(string);
                    String string4 = string2 + string3.substring(n + string.length());
                    if ("supportSystemControl".equals(serviceNameValue2.getSimpleName())) {
                        serviceNameValue = new ServiceNameValue(serviceNameValue2.getServiceName(), "", serviceNameValue2.getSimpleName(), (String)serviceNameValue2.getValue());
                        bemServiceValue.addAttribute(serviceNameValue2.getServiceName(), serviceNameValue);
                        continue;
                    }
                    if (null != bemServiceValue.getAttribute(string4, serviceNameValue2.getSimpleName())) continue;
                    serviceNameValue = new ServiceNameValue(serviceNameValue2.getServiceName(), string4, serviceNameValue2.getSimpleName(), (String)serviceNameValue2.getValue());
                    bemServiceValue.addAttribute(serviceNameValue2.getServiceName(), serviceNameValue);
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue2), serviceNameValue2 + "\nwas converted to " + serviceNameValue);
                }
            }
        }
    }

    private void ignoreAttribute(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\n is no longer used and will be ignored. ");
    }

    private void convertTo(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string, String string2) {
        if (null != serviceNameValue) {
            String string3 = serviceNameValue.getServiceName();
            String string4 = serviceNameValue.getPrefix();
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string3, string4, string, string2, source);
            bemServiceValue.addAttribute(string3, serviceNameValue2);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2);
        }
    }

    private void convertToGpsAttr(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string, String string2) {
        if (null != serviceNameValue) {
            String string3 = "TimingUnitConfig";
            String string4 = "";
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string3, string4, string, string2, source);
            bemServiceValue.addAttribute(string3, serviceNameValue2);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2 + ". " + "You should use <TimingUnitConfig> to configure Sync related attributes");
        }
    }

    private void addToListParamater(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string) {
        String string2 = serviceNameValue.getPrefix();
        String string3 = serviceNameValue.getServiceName();
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(string2, string);
        if (serviceNameValue2 == null) {
            String string4 = serviceNameValue.getValueAsString();
            serviceNameValue2 = new ServiceNameValue(string3, string2, string, string4, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2);
        } else {
            int n = Integer.parseInt(serviceNameValue.getValueAsString());
            String string5 = serviceNameValue2.getValueAsString();
            String[] stringArray = BemUtil.getStringArray(string5);
            int[] nArray = BemUtil.convertStringArrayToIntArray(stringArray);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                nArray[i] = nArray[i] + n;
            }
            string5 = BemUtil.getCommaSeparatedValueString(nArray);
            serviceNameValue2 = new ServiceNameValue(string3, string2, string, string5, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\n was merged to " + serviceNameValue2);
        }
    }

    private ServiceNameValue findFirstSetTo(ServiceNameValue[] serviceNameValueArray, String string) {
        for (int i = 0; i < serviceNameValueArray.length; ++i) {
            if (!(serviceNameValueArray[i] == null ? string == null : serviceNameValueArray[i].getValue().equals(string))) continue;
            return serviceNameValueArray[i];
        }
        return null;
    }

    private Integer getSourceLineInfo(ServiceNameValue serviceNameValue) {
        Source source = serviceNameValue.getInputSource();
        if (source instanceof XmlSource) {
            XmlSource xmlSource = (XmlSource)source;
            Integer n = xmlSource.getLine();
            return n;
        }
        return new Integer(-1);
    }

    private void convertCpriLineRateParam(BemServiceValue bemServiceValue) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("cpriLineRate");
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            if (serviceNameValue == null || "".equals(string = serviceNameValue.getValueAsString()) || !string.startsWith("E") && !string.startsWith("O")) continue;
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), string.substring(1).toUpperCase());
            ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "auUnitType");
            if (null != serviceNameValue2 && (null == serviceNameValue2 || !"".equals(serviceNameValue2.getValueAsString()))) continue;
            String string2 = string.startsWith("E") ? "RUWRUS" : "RRUWRRUS";
            this.convertTo(bemServiceValue, serviceNameValue, "auUnitType", string2);
        }
    }

    private void convertNeedRuPositionAllocationParam(BemServiceValue bemServiceValue) throws BemXmlException {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("auUnitType");
        for (ServiceNameValue serviceNameValue : vector) {
            ServiceNameValue serviceNameValue2;
            if (!AuUnitType.isMacroAuUnitType(serviceNameValue.getValueAsString()) || !this.isModifyWizard(bemServiceValue)) continue;
            String string = serviceNameValue.getPrefix();
            ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute(string, "primaryPortId");
            ServiceNameValue serviceNameValue4 = bemServiceValue.getAttribute(string, "secondaryPortId");
            ServiceNameValue serviceNameValue5 = bemServiceValue.getAttribute(string, "cabinetNumber");
            if (serviceNameValue.getServiceName().equals("AddSector")) {
                if (null != serviceNameValue3) continue;
                if (null == serviceNameValue4 && null == serviceNameValue5) {
                    serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "YES");
                    bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
                    continue;
                }
                throw new BemXmlException("add " + string + "Sector, cabinetNumber and secordaryProtId " + "must be null when primary is null ");
            }
            if (!serviceNameValue.getServiceName().equals("ModifySector")) continue;
            serviceNameValue2 = null;
            serviceNameValue2 = null == serviceNameValue3 && null == serviceNameValue4 && null == serviceNameValue5 ? new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "YES") : new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "NO");
            bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
        }
    }

    private void updateNeedRuPositionAllocation(BemServiceValue bemServiceValue) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("primaryPortId"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("secondaryPortId"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("cabinetNumber"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("auUnitType"));
        for (ServiceNameValue serviceNameValue : arrayList) {
            if (!serviceNameValue.getServiceName().equals("ModifySector") || serviceNameValue.getSimpleName().equals("auUnitType") && AuUnitType.isMacroAuUnitType(serviceNameValue.getValueAsString())) continue;
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "NO");
            bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
        }
    }

    private boolean isModifyWizard(BemServiceValue bemServiceValue) {
        Enumeration enumeration = bemServiceValue.getAllServices();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!"AddSector".equals(string) && !"ModifySector".equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getaDtdFilePathName() {
        return this.aDtdFilePathName;
    }
}

