/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.table.TableCellEditor;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.view.EcPortView;

public abstract class AbstractEcPortController
extends BemWizardGuiController {
    protected EcPortView view = null;
    protected Rbs rbs;
    private JButton addButton = null;
    private JButton removeButton = null;
    private AddButtonActionListener addButtonActionListener = null;
    private RemoveButtonActionListener removeButtonActionListener = null;

    protected void init() {
        this.view = (EcPortView)this.getView();
        this.addButtonActionListener = new AddButtonActionListener();
        this.removeButtonActionListener = new RemoveButtonActionListener();
    }

    protected void afterVisible() {
        this.addButton = this.view.getAddButton();
        this.removeButton = this.view.getRemoveButton();
        this.addActionListeners();
        try {
            Object[][] objectArray = this.getAttributeData();
            this.view.setTableParameters(objectArray, this.getColumnNames());
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("AbstractEcPortController", "afterVisible()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
    }

    private Object[][] getAttributeData() throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters();
        Object[][] objectArray = new Object[ecPortInfoArray.length][this.getColumnNames().length];
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            objectArray[i][0] = ecPortInfo.getUnitTypeParameter();
            objectArray[i][1] = ecPortInfo.getUnitNumberParameter();
            objectArray[i][2] = ecPortInfo.getPortNumberParameter();
            objectArray[i][3] = DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType()) ? ecPortInfo.getcascadingOrderParameter() : ecPortInfo.getHubPositionParameter();
        }
        return objectArray;
    }

    protected boolean next() {
        boolean bl;
        try {
            this.rbs.checkConsistency("CabinetBasicCI");
            this.removeActionListeners();
            bl = true;
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            super.displayErrorMessage(customerParameterException.getReason());
            this.setFocusOnCustomerParameterComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    private void setFocusOnCustomerParameterComponent(String string) {
        CustomerParameterTable customerParameterTable = this.view.getTable();
        if (customerParameterTable.isParameterInTable(string)) {
            customerParameterTable.setFocusOnCell(string);
        }
    }

    protected boolean previous() {
        this.removeActionListeners();
        return true;
    }

    protected boolean cancel() {
        this.removeActionListeners();
        return super.cancel();
    }

    private void addActionListeners() {
        this.addButton.addActionListener(this.addButtonActionListener);
        this.removeButton.addActionListener(this.removeButtonActionListener);
    }

    private void removeActionListeners() {
        this.addButton.removeActionListener(this.addButtonActionListener);
        this.removeButton.removeActionListener(this.removeButtonActionListener);
    }

    private String[] getColumnNames() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Unit Type");
        arrayList.add("Unit Number");
        arrayList.add("Port Number");
        if (DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(this.rbs.getRbsType())) {
            arrayList.add("Cascading Order");
        } else {
            arrayList.add("Hub Position");
        }
        return arrayList.toArray(new String[0]);
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterTable customerParameterTable = AbstractEcPortController.this.view.getTable();
            int[] nArray = customerParameterTable.getSelectedRows();
            TableCellEditor tableCellEditor = customerParameterTable.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            CustomerParameterTableModel customerParameterTableModel = AbstractEcPortController.this.view.getTableModel();
            if (nArray != null && nArray.length > 0) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    int n = nArray[i];
                    CustomerParameter customerParameter = (CustomerParameter)customerParameterTableModel.getValueAt(n, 0);
                    CustomerParameter customerParameter2 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 1);
                    CustomerParameter customerParameter3 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 2);
                    CustomerParameter customerParameter4 = (CustomerParameter)customerParameterTableModel.getValueAt(n, 3);
                    if (customerParameter.getAccessLevel() == 0) {
                        return;
                    }
                    String string = customerParameter.getName().substring(0, customerParameter.getName().indexOf("unitType"));
                    Nal.getLog().nalTrace(6, this.getClass(), "Deleting customer parameter " + customerParameter + customerParameter2 + customerParameter3 + customerParameter4);
                    EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)((Object)AbstractEcPortController.this.rbs.getConfigItem("CabinetBasicCI"));
                    try {
                        ecPortCustomerParameterProvider.removeEcPortCustomerParameter(string);
                        AbstractEcPortController.this.view.deleteRow(n);
                        continue;
                    }
                    catch (BemException bemException) {
                        String string2 = "Error removing EcPort row. Reason=" + bemException.toString();
                        Nal.getLog().nalTraceError(this.getClass(), string2);
                        AbstractEcPortController.this.displayErrorMessage(string2);
                    }
                }
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)((Object)AbstractEcPortController.this.rbs.getConfigItem("CabinetBasicCI"));
            try {
                EcPortInfo ecPortInfo = ecPortCustomerParameterProvider.createEcPortCustomerParameter();
                Vector<Enumeration> vector = new Vector<Enumeration>();
                vector.add(ecPortInfo.getUnitTypeParameter());
                vector.add(ecPortInfo.getUnitNumberParameter());
                vector.add(ecPortInfo.getPortNumberParameter());
                if (DuwUtil.isDualDuwAndPrimaryIsV2() && RbsInfo.RBS_6601W.NAME.equals(AbstractEcPortController.this.rbs.getRbsType())) {
                    vector.add(ecPortInfo.getcascadingOrderParameter());
                } else {
                    vector.add(ecPortInfo.getHubPositionParameter());
                }
                AbstractEcPortController.this.view.addRow(vector);
            }
            catch (BemException bemException) {
                String string = "Failed to add EcPort!";
                Nal.getLog().nalTraceError(this.getClass(), string, bemException);
                AbstractEcPortController.this.displayErrorMessage(string);
            }
        }
    }
}

