/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.gui.ViewRefresh;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;
import se.ericsson.wcdma.rbs.bem.common.util.SilentModeManager;
import se.ericsson.wcdma.rbs.bem.wizard.control.EmasWorkarounder;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.ExecutionManager;
import se.ericsson.wcdma.rbs.bem.wizard.util.InstallController;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.view.ProgressDialogView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractDialogController;

public abstract class ProgressDialogController
extends AbstractDialogController
implements ProgressReporter,
ExecutionManager {
    private ProgressDialogView myView = null;
    private int currentProgressReported = 0;
    private String currentProgressDescription = "Not started";
    private int totalNoMoOperations = 0;
    private InstallController installController = null;
    private EmasWorkarounder theCallingWindow = null;
    private WizardException wizardException = null;
    private boolean configurationSuccessful = false;
    private boolean shouldDisplayCancelDialog = true;
    private boolean isFailed = false;
    private boolean isCancelled = false;
    private StringBuffer theInstallReport = null;

    protected void init() {
        this.myView = (ProgressDialogView)this.getView();
        this.theCallingWindow = (EmasWorkarounder)((Object)this.getParentController());
        this.myView.cancelButton.addActionListener(new CancelButtonActionListener());
        this.totalNoMoOperations = 0;
        try {
            this.installController = this.createInstallController();
            this.totalNoMoOperations = this.installController.initiate();
        }
        catch (WizardException wizardException) {
            this.wizardException = wizardException;
            this.endThisDialog();
        }
        catch (Exception exception) {
            this.wizardException = new WizardException("ProgressDialogController", null, null, "Initiate subcontrollers", exception);
            this.endThisDialog();
        }
        this.myView.jProgressBar.setMaximum(this.totalNoMoOperations);
        this.myView.jProgressBar.setMinimum(1);
        this.myView.jProgressBar.setValue(1);
        if (RegressionTestInDesigntestUtils.getRegressionTest()) {
            try {
                this.installController.run_subcontrollers();
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised("Error has occurred", bemException);
            }
        } else {
            this.installController.start();
        }
    }

    public void configurationFailed(String string) {
        this.configurationSuccessful = false;
        this.endThisDialog();
    }

    public abstract InstallController createInstallController() throws WizardException;

    public void reportComplete(StringBuffer stringBuffer) {
        String string;
        this.shouldDisplayCancelDialog = false;
        this.theInstallReport = stringBuffer;
        this.configurationSuccessful = true;
        this.myView.jProgressBar.setValue(this.totalNoMoOperations);
        this.myView.packageNameField.setText("");
        this.myView.cancelButton.setActionCommand("Ok");
        this.myView.cancelWarning.setVisible(false);
        this.myView.cancelButton.setText("Ok");
        String string2 = "Configuration Completed Successfully.";
        if (stringBuffer != null && !(string = stringBuffer.toString().trim()).equals("") && !string.equals("\n")) {
            string2 = string2 + "\n" + "\n\n\n" + stringBuffer.toString().trim();
        }
        this.myView.resultArea.append(string2);
        this.myView.resultArea.setCaretPosition(0);
        if (SilentModeManager.isSilentMode(string2, false)) {
            this.endThisDialog();
        }
    }

    public void reportError(BemException bemException) {
        ExceptionProperties exceptionProperties = bemException.getProperties();
        exceptionProperties.setProperty("Progress", this.currentProgressDescription);
        String string = exceptionProperties.getPopUpMessge();
        if (SilentModeManager.isSilentMode(string, true)) {
            this.endThisDialog();
        } else if (!this.isCancelled) {
            this.shouldDisplayCancelDialog = false;
            this.wizardException = bemException instanceof WizardException ? (WizardException)bemException : new WizardException(null, (Throwable)bemException);
            this.isFailed = true;
            if (this.theCallingWindow == null) {
                JOptionPane.showConfirmDialog(null, "This dialog should only occur on errors when NPC test are run in design test environment.\nCheck the real error message in the java console!!!\n\n" + string, "INFO", 0);
            } else {
                String string2 = "Configuration Failed\n" + string;
                this.myView.resultArea.setText(string2);
            }
        }
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        String string3;
        int n2;
        this.currentProgressReported += n;
        if (this.currentProgressReported <= this.totalNoMoOperations) {
            this.myView.jProgressBar.setValue(this.currentProgressReported);
        }
        if ((n2 = (string3 = string).lastIndexOf(".")) > 0) {
            string3 = string3.substring(n2 + 1);
        }
        this.currentProgressDescription = string2;
        if (!this.isCancelled) {
            this.myView.packageNameField.setText("  " + string2);
        }
    }

    public String getReportedProgress() {
        return this.currentProgressDescription;
    }

    private void endThisDialog() {
        this.stopDialog();
    }

    public boolean getResult() throws WizardException {
        if (this.wizardException != null) {
            throw this.wizardException;
        }
        return this.configurationSuccessful;
    }

    public StringBuffer getInstallReport() {
        return this.theInstallReport;
    }

    public String toString() {
        return this.currentProgressDescription;
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ProgressDialogController.this.shouldDisplayCancelDialog) {
                ProgressDialogController.this.isCancelled = true;
                ProgressDialogController.this.installController.stopExecution();
            }
            if (ProgressDialogController.this.theCallingWindow != null) {
                if (actionEvent.getActionCommand().equals("Ok")) {
                    ProgressDialogController.this.theCallingWindow.reportInstallerComplete(ProgressDialogController.this.theInstallReport);
                } else {
                    ProgressDialogController.this.endThisDialog();
                    if (ProgressDialogController.this.isFailed) {
                        ProgressDialogController.this.theCallingWindow.reportInstallerError(ProgressDialogController.this.wizardException);
                    } else {
                        ProgressDialogController.this.theCallingWindow.reportInstallerCancelled();
                    }
                }
            }
            WizardLaunchChecker.wizardStopped();
            ViewRefresh.setViewRefreshEnabled(true);
        }
    }
}

