/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.precontrol;

import java.text.MessageFormat;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionsCheck;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;

public abstract class AbstractCreateRbsPreController
implements SubInstaller {
    protected String theDescription = "Evaluating preconditions";
    private String description = "Preparing for configuration";
    private String name = this.getClass().getName();
    private int totalReports = 20;
    private Installer installer = null;
    protected WizardCIModel model = null;
    private String rbsStep = null;
    private WizardHelper wizardHelp = null;
    private final Preconditions preconditions;

    public AbstractCreateRbsPreController(Installer installer, WizardCIModel wizardCIModel, String string, WizardHelper wizardHelper, Preconditions preconditions) {
        this.installer = installer;
        this.model = wizardCIModel;
        this.rbsStep = string;
        this.wizardHelp = wizardHelper;
        String string2 = this.getClass().getName();
        int n = string2.lastIndexOf(".");
        this.name = string2.substring(n + 1);
        this.preconditions = preconditions;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public boolean install() throws BemException, MoHandlerException {
        String string;
        this.installer.reportProgress(this.name, this.description);
        --this.totalReports;
        this.checkPreconditions();
        Rbs rbs = null;
        String string2 = null;
        ServiceValue serviceValue = this.model.getServiceValue();
        List list = RbsFactory.getCabinetNoList(serviceValue);
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        boolean bl = false;
        String[] stringArray = new String[list.size()];
        boolean[] blArray = new boolean[list.size()];
        if (this.model.getUseFileInput()) {
            int n;
            string2 = serviceValue.getValue("rbsType");
            for (n = 0; n < list.size(); ++n) {
                int n2 = Integer.parseInt(list.get(n).toString());
                string = MessageFormat.format("CAB{0}_", new Integer(n2));
                stringArray[n] = serviceValue.getValue(string + "cabinetType");
            }
            for (n = 1; n < list.size(); ++n) {
                blArray[n] = null != stringArray[n];
            }
            String string3 = serviceValue.getValue("2radioIfType");
            if (string3 != null && string3.equals("DUI_O")) {
                bl = true;
            } else if (!this.rbsStep.equals("STEP_CABINET")) {
                bl = DuwUtil.isPantherHybridRbs();
            }
        } else if (!this.rbsStep.equals("STEP_CABINET")) {
            bl = DuwUtil.isPantherHybridRbs();
        }
        try {
            rbs = string2 != null ? RbsFactory.getRbs(string2, moHandlerImpl, this.rbsStep, bl, serviceValue) : RbsFactory.getRbs(moHandlerImpl, this.rbsStep, bl, serviceValue);
            for (int i = 0; i < list.size(); ++i) {
                if (!blArray[i]) continue;
                rbs.getCabinetTypeParams()[i] = stringArray[i];
            }
            this.model.setRbs(rbs);
            this.description = "Preparing for configuration (open CIs)";
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
            this.openConfigurationItems(rbs);
            this.description = "Preparing for configuration ready (open CIs)";
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
            if (this.model.getUseFileInput()) {
                this.description = "Updating model with data from xml-file";
                this.installer.reportProgress(this.name, this.description);
                --this.totalReports;
                if (serviceValue != null) {
                    rbs.setCustomerParameters(serviceValue);
                    if (this.shallBeNoWizard() && this.model.getUseWizard()) {
                        this.model.setUseWizard(false);
                        this.wizardHelp.useInputFileWithoutWizard();
                    }
                    rbs.checkConsistency();
                }
            }
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            string = "";
            if (customerParameter != null) {
                string = customerParameter.getName() + " = " + customerParameter.getValue() + " is not allowed\n" + "reason: " + customerParameterException.getReason();
            }
            throw new WizardException(string, (Throwable)customerParameterException);
        }
        while (this.totalReports > 0) {
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
        }
        return true;
    }

    private boolean checkPreconditions() throws WizardException {
        boolean bl;
        block7: {
            bl = false;
            Preconditions preconditions = null;
            try {
                preconditions = new PreconditionsCheck().checkPreconditions(this.preconditions);
                if (preconditions.getPreconditionsFullfilled()) {
                    bl = true;
                    break block7;
                }
                String string = preconditions.getResultMessage();
                throw new WizardException(string);
            }
            catch (WizardException wizardException) {
                throw wizardException;
            }
            catch (Exception exception) {
                throw new WizardException("checkPreconditions()", null, null, this.theDescription, exception);
            }
            finally {
                preconditions = null;
            }
        }
        return bl;
    }

    public String getTheName() {
        return this.name;
    }

    public String getTheDescription() {
        return this.description;
    }

    protected abstract void openConfigurationItems(Rbs var1) throws BemException;

    protected boolean shallBeNoWizard() throws BemException {
        return false;
    }
}

