/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.subcontrol;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionConstants;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.util.ExceptionUtil;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public class InstallCIsPostController
implements SubInstaller,
ExceptionConstants {
    private final NalLog nalLog = Nal.newLog("se.ericsson.wcdma.rbs.bem");
    private int totalNumberOfProgressReports = 50;
    private Installer theInstaller = null;
    private final String theName;
    private int myProgressReports = 0;
    private String theDescription = "Install according to choices";
    private static final String PREFIX_DESCRIPTION = "Currently handling ";
    private final WizardCIModel model;
    private final Rbs rbs;
    private final Phase[] installationPhases;

    public InstallCIsPostController(Installer installer, WizardCIModel wizardCIModel) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
        this.model = wizardCIModel;
        this.rbs = this.model.getRbs();
        this.installationPhases = this.rbs.getInstallationPhases();
        int n = this.installationPhases.length;
        this.myProgressReports = this.totalNumberOfProgressReports = n + 5;
    }

    public boolean install() throws BemException {
        Object object;
        Object object2;
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Wizard", this.model.getWizardName());
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        TransactionHelper transactionHelper = TransactionHelper.getInstance(moHandlerImpl);
        boolean bl = moHandlerImpl.getUseLargeTransactions();
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        try {
            this.theDescription = "Reading resources to install";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            ArrayList arrayList = this.rbs.getRIsToInstall();
            this.theDescription = "Starting installation";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            for (int i = 0; i < this.installationPhases.length; ++i) {
                boolean bl2;
                object2 = this.installationPhases[i].getName();
                try {
                    bl2 = transactionHelper.setPhase((String)object2);
                }
                catch (MoHandlerException moHandlerException) {
                    if (ExceptionUtil.isCausedByCorbaConnectionLost(moHandlerException)) {
                        bl2 = true;
                        Nal.getLog().nalTrace(6, this.getClass(), "Connection lost during commit of transaction (timing related, expected behaviour when changing nodeInterfaceName).");
                    }
                    throw moHandlerException;
                }
                if (bl2) continue;
                exceptionProperties.setProperty("PhaseName", object2);
                object = this.installationPhases[i].getInstallDisplayName();
                exceptionProperties.setProperty("PhaseReport", object);
                this.theDescription = PREFIX_DESCRIPTION + (String)object;
                this.theInstaller.reportProgress(this.theName, this.theDescription);
                CharSequence charSequence = new StringBuffer(128);
                charSequence.append("----- Phase ");
                if (i < 9) {
                    charSequence.append(' ');
                }
                charSequence.append(i + 1);
                charSequence.append(" of ").append(this.installationPhases.length);
                charSequence.append(" ---- ").append((String)object2).append(" ---");
                while (charSequence.length() < 64) {
                    charSequence.append('-');
                }
                charSequence.append(" ").append((String)object);
                charSequence.append(": ---");
                while (charSequence.length() < 120) {
                    charSequence.append('-');
                }
                this.nalLog.nalTrace(4, this.getClass(), charSequence.toString());
                --this.myProgressReports;
                if (this.theInstaller.isInterrupted()) {
                    boolean bl3 = false;
                    return bl3;
                }
                charSequence = this.theDescription;
                for (ResourceItem resourceItem : arrayList) {
                    if (resourceItem == null) continue;
                    exceptionProperties.setProperty("ResourceItem  (RI)", resourceItem.getDisplayName());
                    this.theDescription = (String)charSequence + " " + resourceItem.getDisplayName();
                    this.theInstaller.reportProgress(this.theName, this.theDescription, 0);
                    if ("StartUseLargeTransactionPhase".equals(object2) && !bl) {
                        moHandlerImpl.setUseLargeTransactions(true);
                    }
                    resourceItem.install((String)object2);
                    if ("EndUseLargeTransactionPhase".equals(object2) && !bl) {
                        moHandlerImpl.setUseLargeTransactions(false);
                    }
                    --this.myProgressReports;
                    if (!this.theInstaller.isInterrupted()) continue;
                    boolean bl4 = false;
                    return bl4;
                }
                exceptionProperties.setProperty("ResourceItem  (RI)", "(RI loop ended)");
            }
            exceptionProperties.setProperty("PhaseName", "(Install phases loop ended)");
            exceptionProperties.setProperty("PhaseReport", "(Install phases loop ended)");
            StringBuffer stringBuffer = null;
            for (ResourceItem resourceItem : arrayList) {
                if (resourceItem == null) continue;
                exceptionProperties.setProperty("ResourceItem  (RI)", resourceItem.getDisplayName());
                stringBuffer = resourceItem.getInstallReport();
                if (stringBuffer == null || stringBuffer.toString().trim().equals("")) continue;
                this.theInstaller.extendInstallReport(resourceItem.getInstallReport());
            }
            exceptionProperties.setProperty("ResourceItem  (RI)", "(RI loop ended)");
        }
        catch (BemException bemException) {
            String string;
            String string2 = bemException.getTheFunction();
            if (string2 == null) {
                string2 = "";
            }
            string2 = "Installing data on node " + string2;
            object2 = bemException.getAction();
            if (object2 == null) {
                object2 = "";
            }
            if ((string = bemException.getAdditionalInfo()) == null) {
                string = "";
            }
            this.theDescription = this.theDescription + "  " + string;
            object = new WizardException(string2, (String)object2, "", this.theDescription, bemException);
            throw object;
        }
        catch (Exception exception) {
            exceptionProperties.setProperty("Progress", this.theInstaller.getReportedProgress());
            throw new WizardException("install() failed", exceptionProperties, (Throwable)exception);
        }
        finally {
            moHandlerImpl.setUseLargeTransactions(false);
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return true;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalNumberOfProgressReports;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }
}

