/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.InformativeText;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.wizard.control.AbstractFlexFinishController;
import se.ericsson.wcdma.rbs.bem.wizard.control.GuiCheckAndShowWarning;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.control.ModifyPostProgressDlgController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view.FinishFlexView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view.ModifyProgressDialogView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;

public class ModifyFinishController
extends AbstractFlexFinishController {
    private FinishFlexView myView = null;
    private Rbs rbs = null;
    private static final String CUSTPARAM_DEFAULT_VALUE_ENDING = " (Default)";

    public ModifyFinishController() {
        super(ModifyModel.getInstance(), WizardHelp.getTheInstance());
    }

    protected void init() {
        AbstractView abstractView = this.getView();
        this.myView = (FinishFlexView)abstractView;
        super.setFlexModel(ModifyModel.getInstance());
        super.init();
        this.rbs = ModifyModel.getInstance().getRbs();
        this.myView.setXmlFileUsed(ModifyModel.getInstance().getUseFileInput());
    }

    protected void afterVisible() {
        super.afterVisible();
        try {
            int n;
            int n2;
            Object object;
            Object object2;
            InformativeText informativeText = new InformativeText(this.rbs);
            Vector[] vectorArray = informativeText.getSectorParams();
            Vector[][] vectorArray2 = informativeText.getCellParams();
            Vector vector = informativeText.getSiteParams();
            Vector vector2 = informativeText.getNetworkParams();
            Vector vector3 = informativeText.getGpsParams();
            Vector vector4 = informativeText.getDeleteRaxParams();
            Vector vector5 = informativeText.getAddDuwDataParams();
            Vector vector6 = informativeText.getAtmNamesParams();
            Vector vector7 = informativeText.getClimateSystemParams();
            Vector vector8 = informativeText.getEcPortParams();
            Vector vector9 = informativeText.getCommonSupportSystemParams();
            Vector[] vectorArray3 = informativeText.getCabinetParams();
            Vector vector10 = informativeText.getECBusParams();
            for (int i = 1; i <= this.rbs.getMaxNumberOfSectors(); ++i) {
                CustomerParameter customerParameter;
                object2 = MessageFormat.format("S{0}_", i);
                object = (String)object2 + "createSector";
                if (!this.rbs.isParameterSupported((String)object) || !(customerParameter = this.rbs.getCustomerParameterObject((String)object)).hasValueChanged() || !customerParameter.getValue().equals("NO")) continue;
                vectorArray[i - 1].add(Nal.getFactory().getNameValue("Sector", "Delete"));
            }
            this.myView.setRbsName(this.rbs.getRbsType());
            this.myView.setSectorValues(vectorArray, this.rbs.getMaxNumberOfSectors());
            CellAndCarrierCI cellAndCarrierCI = (CellAndCarrierCI)this.rbs.getCellAndCarrierProvider();
            object2 = null;
            if (this.rbs.isPantherHybridRbs()) {
                object2 = (CellAndCarrierCI)this.rbs.getCellAndCarrierProvider(1);
            }
            object = new int[this.rbs.getMaxNumberOfSectors()][1];
            for (n2 = 0; n2 < this.rbs.getMaxNumberOfSectors(); ++n2) {
                int n3 = this.rbs.isPantherHybridRbs() && n2 > 5 ? ((CellAndCarrierCI)object2).getNumberOfCellsInSector(n2 - 6) : cellAndCarrierCI.getNumberOfCellsInSector(n2);
                object[n2][0] = n3;
            }
            n2 = this.rbs.getMaxNumberOfCells();
            this.myView.setCellValues(vectorArray2, n2);
            NalNameValue nalNameValue = null;
            for (n = 0; n < vector.size(); ++n) {
                nalNameValue = (NalNameValue)vector.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector2.size(); ++n) {
                nalNameValue = (NalNameValue)vector2.get(n);
                if (nalNameValue == null) continue;
                if (!nalNameValue.getValue().toString().endsWith(CUSTPARAM_DEFAULT_VALUE_ENDING)) continue;
                vector2.remove(nalNameValue);
                --n;
            }
            for (n = 0; n < vector2.size(); ++n) {
                nalNameValue = (NalNameValue)vector2.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector3.size(); ++n) {
                nalNameValue = (NalNameValue)vector3.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector4.size(); ++n) {
                nalNameValue = (NalNameValue)vector4.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector5.size(); ++n) {
                nalNameValue = (NalNameValue)vector5.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector6.size(); ++n) {
                nalNameValue = (NalNameValue)vector6.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector7.size(); ++n) {
                nalNameValue = (NalNameValue)vector7.get(n);
                this.myView.setValue(nalNameValue);
            }
            for (n = 0; n < vector9.size(); ++n) {
                nalNameValue = (NalNameValue)vector9.get(n);
                this.myView.setValue(nalNameValue);
            }
            this.myView.setCabinetValues(vectorArray3);
            this.myView.setEcBusParameters(vector10);
            if (vector8.size() > 0) {
                ArrayList<EcPortInfo> arrayList = new ArrayList<EcPortInfo>();
                for (int i = 0; i < vector8.size(); ++i) {
                    nalNameValue = (NalNameValue)vector8.get(i);
                    if (!nalNameValue.getName().startsWith("EcPort") || !nalNameValue.getName().endsWith("hubPosition") && !nalNameValue.getName().endsWith("cascadingOrder")) continue;
                    String string = nalNameValue.getName().substring(0, nalNameValue.getName().indexOf("_") + 1);
                    EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)((Object)this.rbs.getConfigItem("CabinetBasicCI"));
                    EcPortInfo ecPortInfo = ecPortCustomerParameterProvider.getEcPortCustomerParameter(string);
                    if (!ecPortInfo.getcascadingOrderParameter().hasValueChanged() && !ecPortInfo.getHubPositionParameter().hasValueChanged() && !ecPortInfo.getPortNumberParameter().hasValueChanged() && !ecPortInfo.getUnitNumberParameter().hasValueChanged() && !ecPortInfo.getUnitTypeParameter().hasValueChanged()) continue;
                    arrayList.add(ecPortInfo);
                }
                this.myView.setEcPortValues(arrayList);
            }
            if (DuwUtil.hasDuw()) {
                this.myView.setHasDuw(true);
            }
            if (this.rbs.isParameterSupported("IPoverGigabitEthernet_transportOption")) {
                String string = this.rbs.getCustomerParameter("IPoverGigabitEthernet_transportOption");
                this.myView.setValue(Nal.getFactory().getNameValue("IPoverGigabitEthernet_transportOption", string));
            }
            String string = ModifyModel.getInstance().getTmfFiles();
            this.myView.setTmfFiles(string);
            this.myView.updateGui();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("FinishController", "afterVisible()", null, "Getting changed customer parameters", exception);
            this.displayError(wizardException);
        }
    }

    protected void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Modify RBS Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean finish() {
        if (!GuiCheckAndShowWarning.checkDcVoltageAndShowWarning(this.rbs, this, this.myView.sectorParameters)) {
            return false;
        }
        super.finish();
        boolean bl = this.finishReconnecting("ModifyRbsEquipment", "MODIFY_RBS_CONFIGURATION_TITLE", ModifyProgressDialogView.class, ModifyPostProgressDlgController.class);
        return bl;
    }

    public void reportInstallerError(WizardException wizardException) {
        this.setFinishEnabled(true);
        this.setCancelEnabled(true);
        String string = wizardException.getAction();
        if ("ROLLBACK_TRANSACTION".equals(string)) {
            this.restartNode(true);
        }
        this.getApplication().stopApplicationNoCheck();
    }

    public void reportInstallerCancelled() {
        this.setFinishEnabled(true);
        this.setCancelEnabled(true);
        String string = "ROLLBACK_TRANSACTION";
        MoHandler moHandler = this.rbs.getMoHandler();
        boolean bl = moHandler.getUseLargeTransactions();
        if (bl) {
            try {
                TransactionHelper transactionHelper = TransactionHelper.getInstance(moHandler);
                MoHandlerException moHandlerException = new MoHandlerException("User cancelled installation", null);
                transactionHelper.rollbackAlloperations(moHandlerException);
                string = "Cancel";
            }
            catch (Exception exception) {
                string = "ROLLBACK_TRANSACTION";
            }
        }
        if ("ROLLBACK_TRANSACTION".equals(string)) {
            this.restartNode(true);
        }
        this.getApplication().stopApplicationNoCheck();
    }

    protected String getWizardName() {
        return "Modify";
    }
}

