/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemCheckBoxSingle;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemStringField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.model.ModifyModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.modify.view.WelcomeViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationView;
import se.ericsson.wcdma.support.gui.resources.ImageConstant;

public class WelcomeView
extends AbstractApplicationView
implements WelcomeViewer {
    private final JPanel welcomePanel = new JPanel();
    private final JTextArea infoTextArea = new JTextArea();
    private final AbstractApplicationView.WhatNextButtonPanel buttonPanel = new AbstractApplicationView.WhatNextButtonPanel();
    private final JPanel preconditionPanel = new JPanel();
    private final JLabel headingLabel = new JLabel();
    private final JPanel headingPanel = new JPanel();
    private final Dimension thePreferedDimension = new Dimension(800, 500);
    private final JPanel configurationFilePanel = new JPanel();
    private BemStringField filePathStringField;
    private final JButton browseButton = new JButton();
    private Border border1;
    private BemCheckBoxSingle checkBoxAddTmdFile = new BemCheckBoxSingle(WizardLanguageHelp.getTranslation("ADD_TMF_FILES"));
    private JPanel tmfFilesPanel = new JPanel();
    private CustomerParameterList tmfFilesList = new CustomerParameterList();
    private JScrollPane tmfFileScrollPane = new JScrollPane(this.tmfFilesList);
    private JButton addTmfFilesButton = new JButton(WizardLanguageHelp.getTranslation("ADD_TMF_FILE"));
    private JButton removeTmfFilesButton = new JButton(WizardLanguageHelp.getTranslation("REMOVE_TMF_FILE"));
    private static final String l1 = "Welcome to Ericsson Modify RBS Equipment Configuration Wizard. ";
    private static final String l3 = "This wizard can be used to modify the RBS configuration from an XML file.\n\n";
    private JLabel picture = new JLabel();

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(this.thePreferedDimension);
        this.putClientProperty("HELP_KEY", "MODIFY_RBS_BUTTON_HELP");
        this.setLayout(new GridBagLayout());
        this.welcomePanel.setLayout(new GridBagLayout());
        this.border1 = BorderFactory.createEtchedBorder();
        ImageIcon imageIcon = ImageConstant.BEM_TRUMPET_SPLASH.getImageIcon();
        this.picture = new JLabel(imageIcon);
        this.picture.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        Font font = this.headingLabel.getFont();
        String string = font.getFontName();
        Font font2 = new Font(string, 0, 20);
        this.headingLabel.setFont(font2);
        this.headingLabel.setForeground(Color.darkGray);
        this.headingLabel.setText("MODIFY_RBS_CONFIGURATION_HEADING");
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        Color color = this.welcomePanel.getBackground();
        this.infoTextArea.setBackground(color);
        this.infoTextArea.setText(l1 + l3);
        this.filePathStringField = new BemStringField("NCONF_FIL_FILE_PATH_LABEL", false, (Integer)30);
        this.preconditionPanel.setLayout(new GridBagLayout());
        this.preconditionPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "MODIFY_RBS_CONFIGURATION_INFORMATION"));
        this.headingPanel.setLayout(new GridBagLayout());
        this.configurationFilePanel.setLayout(new GridBagLayout());
        this.configurationFilePanel.setBorder(new TitledBorder(this.border1, "NCONF_FIL_PANEL_LABEL"));
        this.configurationFilePanel.add((Component)this.filePathStringField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.browseButton.setText("NCONF_FIL_BROWSE_BUTTON");
        this.configurationFilePanel.add((Component)this.browseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.addTmfFilesButton.setPreferredSize(this.removeTmfFilesButton.getPreferredSize());
        this.removeTmfFilesButton.setEnabled(false);
        this.tmfFileScrollPane.setPreferredSize(new Dimension(400, 72));
        this.tmfFilesPanel.setLayout(new GridBagLayout());
        this.tmfFilesPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "CONFIGURE_TMF_FILES"));
        this.checkBoxAddTmdFile.setBackground(color);
        this.tmfFilesPanel.add((Component)this.tmfFileScrollPane, new GridBagConstraints(1, 0, 2, 3, 2.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tmfFilesPanel.add((Component)this.addTmfFilesButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tmfFilesPanel.add((Component)this.removeTmfFilesButton, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setTmfFilesPanel(false);
        this.add((Component)this.welcomePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 2), 0, 0));
        this.preconditionPanel.add((Component)this.infoTextArea, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headingPanel.add((Component)this.headingLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 56, 3));
        this.welcomePanel.add((Component)this.picture, new GridBagConstraints(0, 0, 1, 6, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.headingPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.preconditionPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.configurationFilePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 10, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.checkBoxAddTmdFile, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.tmfFilesPanel, new GridBagConstraints(1, 4, 5, 5, 1.0, 1.0, 10, 1, new Insets(4, 10, 0, 0), 0, 0));
        this.welcomePanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public JButton getNextButton() {
        return this.buttonPanel.nextButton;
    }

    public JButton getCancelButton() {
        return this.buttonPanel.cancelButton;
    }

    public JComponent getBrowseButtonComponent() {
        return this.browseButton;
    }

    public String getFilePath() {
        String string = this.filePathStringField.getValue();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setFilePath(String string) {
        this.filePathStringField.setValue(string);
    }

    public void setHeaderText(String string) {
        this.headingLabel.setText(string);
    }

    public Dimension getPreferredSize() {
        return this.thePreferedDimension;
    }

    public JComponent[] getToolBarComponents() {
        return null;
    }

    public JMenu[] getMenus() {
        return null;
    }

    public void hideTheView() {
        this.setVisible(false);
    }

    public void setTheViewToDummy() {
        this.remove(this.welcomePanel);
        this.infoTextArea.setText("This Window can not be removed");
        this.add(this.infoTextArea);
        this.repaint();
    }

    public void setProductData(String string) {
        this.infoTextArea.setText(l1 + l3 + string);
    }

    public BemCheckBoxSingle getCheckBoxAddTmfFilesComponent() {
        return this.checkBoxAddTmdFile;
    }

    public CustomerParameterList getListTmfFilesComponent() {
        return this.tmfFilesList;
    }

    public JButton getButtonAddTmfFilesComponent() {
        return this.addTmfFilesButton;
    }

    public JButton getButtonRemoveTmfFilesComponent() {
        return this.removeTmfFilesButton;
    }

    public boolean isTmfFileToAdd() {
        return this.checkBoxAddTmdFile.getValue("");
    }

    public void setTmfFilesPanel(boolean bl) {
        if (bl) {
            this.addTmfFilesButton.setVisible(true);
            this.removeTmfFilesButton.setVisible(true);
            this.tmfFileScrollPane.setVisible(true);
            this.tmfFilesPanel.setVisible(true);
        } else {
            this.addTmfFilesButton.setVisible(false);
            this.removeTmfFilesButton.setVisible(false);
            this.tmfFileScrollPane.setVisible(false);
            this.tmfFilesPanel.setVisible(false);
            ModifyModel.getInstance().setTmfFiles("");
        }
    }
}

