/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.IpRoutingCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.RoutingController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamCustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.OamGuiComponentErrorManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.AddStaticRouteDialogView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractDialogController;

public class AddStaticRouteDialogController
extends AbstractDialogController
implements OamGuiComponentErrorManager {
    private AddStaticRouteDialogView myView = null;
    private RoutingController theParent = null;
    private IpRoutingCI ipRoutingCI = null;
    private DynamicCustomerParameterProvider dynamicCustomerParameterProvider = null;
    private CustomerParameterPanel[] guiComponents = null;
    private OamCustomerParameterComboBox defaultField = null;
    ArrayList dynamicCustomerParameters = null;

    protected void init() {
    }

    protected void afterVisible() {
        this.theParent = (RoutingController)this.getParentController();
        this.myView = (AddStaticRouteDialogView)this.getView();
        this.myView.getAddButton().addActionListener(new AddButtonActionListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonActionListener());
        this.ipRoutingCI = this.theParent.getIpRoutingCI();
        this.dynamicCustomerParameterProvider = this.ipRoutingCI;
        try {
            this.dynamicCustomerParameters = (ArrayList)this.dynamicCustomerParameterProvider.createCP();
            this.guiComponents = this.createGuiComponents();
            this.defaultField.addListener();
            this.myView.setGuiComponents(this.guiComponents);
        }
        catch (Exception exception) {
            this.showError("Can not get Customer Parameters. Reason=" + exception.toString());
            this.stopDialog();
        }
    }

    private boolean checkSyntax() {
        boolean bl = true;
        try {
            this.ipRoutingCI.checkDynamicConsistency();
        }
        catch (Exception exception) {
            this.showError(exception.toString());
            bl = false;
        }
        return bl;
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    private CustomerParameterPanel[] createGuiComponents() {
        CustomerParameterPanel customerParameterPanel;
        CustomerParameterPanel[] customerParameterPanelArray = new CustomerParameterPanel[6];
        CustomerParameter customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(0);
        this.defaultField = new OamCustomerParameterComboBox((Enumeration)customerParameter, this);
        JComponent jComponent = new CustomerParameterPanel("Get default values for:", this.defaultField, false);
        customerParameterPanelArray[0] = jComponent;
        customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(1);
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[1] = customerParameterPanel = new CustomerParameterPanel("Destination IP address:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(2);
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[2] = customerParameterPanel = new CustomerParameterPanel("Destination subnet mask:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(3);
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[3] = customerParameterPanel = new CustomerParameterPanel("Next hop IP address:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(4);
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[4] = customerParameterPanel = new CustomerParameterPanel("Route metric:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.dynamicCustomerParameters.get(5);
        jComponent = new CustomerParameterCheckbox("", (BooleanCustomerParameter)customerParameter);
        customerParameterPanelArray[5] = customerParameterPanel = new CustomerParameterPanel("Redistribute:", (CustomerParameterComponent)((Object)jComponent), false);
        return customerParameterPanelArray;
    }

    public void handleSetError(Exception exception) {
        this.showError("Problem to set component. Reason=" + exception.toString());
    }

    class CancelButtonActionListener
    implements ActionListener {
        CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddStaticRouteDialogController.this.theParent.cancelAddStaticRoute(AddStaticRouteDialogController.this.dynamicCustomerParameters);
            AddStaticRouteDialogController.this.defaultField.removeListener();
            AddStaticRouteDialogController.this.stopDialog();
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AddStaticRouteDialogController.this.checkSyntax()) {
                AddStaticRouteDialogController.this.theParent.addStaticRoute(AddStaticRouteDialogController.this.dynamicCustomerParameters);
                AddStaticRouteDialogController.this.defaultField.removeListener();
                AddStaticRouteDialogController.this.stopDialog();
            }
        }
    }
}

