/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.BemServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.util.Preconditions;
import se.ericsson.wcdma.rbs.bem.wizard.util.PreconditionsCheck;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardCommon;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLaunchChecker;
import se.ericsson.wcdma.rbs.bem.wizard.view.FileInputView;
import se.ericsson.wcdma.rbs.bem.wizard.view.NodeResultView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.FileInputOamController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.NodeResultController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.WelcomeViewer;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class WelcomeController
extends AbstractApplicationController {
    private static String NCONF_OAM_WEL_HEADING = "O&M Access Configuration";
    private WelcomeViewer myView = null;
    private WizardHelper wizardHelp = null;
    private Class nextController = FileInputOamController.class;
    private Class nextView = FileInputView.class;
    private final String configurationVersion = WizardCommon.WIZARD_LDN_CONFIGURATIONVERSION;
    private MoHandler theMoHandler;
    private OamCIModel oamCIModel = null;

    protected void init() {
        this.myView = (WelcomeViewer)((Object)this.getView());
        this.oamCIModel = OamCIModel.getInstance();
        this.theMoHandler = new MoHandlerImpl();
        this.myView.getNextButton().addActionListener(new NextButtonListener());
        this.myView.getCancelButton().addActionListener(new CancelButtonListener());
    }

    protected boolean canStop() {
        return true;
    }

    protected void beforeVisible() {
        boolean bl = WizardLaunchChecker.wizardStarted();
        if (!bl) {
            this.getApplication().stopApplicationNoCheck();
        }
    }

    protected void afterVisible() {
        BemServiceValue.setNoOfRoutes(0);
        ServiceValue.setNoOfAtmPorts(0);
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardHelp.destroyTheInstance();
        this.wizardHelp = WizardHelp.getTheInstance();
        this.setWindowSubTitle();
        this.checkInputFilePreconditions();
        try {
            this.setProductData();
        }
        catch (Exception exception) {
            this.showError(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInputFilePreconditions() {
        Preconditions preconditions = null;
        try {
            preconditions = WizardCommon.WIZARD_INPUTFILE_PRECONDITIONS_OAM;
            preconditions = new PreconditionsCheck().checkPreconditions(preconditions);
            boolean bl = preconditions.getPreconditionsFullfilled();
            if (bl) {
                this.oamCIModel.setIsWizardRun(false);
            } else {
                this.nextController = NodeResultController.class;
                this.nextView = NodeResultView.class;
                this.oamCIModel.setUseFileInput(false);
                this.wizardHelp.excludeSlides("FileInputOamController", "FileInputOamController");
                this.wizardHelp.excludeSlides("AtmPortController", "AtmPortController");
                this.oamCIModel.setIsWizardRun(true);
            }
        }
        catch (Exception exception) {
            this.showError(exception.getMessage());
        }
        finally {
            preconditions = null;
        }
    }

    protected void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Error", 0);
    }

    protected void cancel() {
        WizardLaunchChecker.wizardStopped();
        this.getApplication().stopApplication();
    }

    private void setWindowSubTitle() {
        String string = NCONF_OAM_WEL_HEADING;
        this.myView.setHeaderText(string);
    }

    public Class getNextControllerClass() {
        return this.nextController;
    }

    public Class getNextViewClass() {
        return this.nextView;
    }

    protected void viewClosing() {
        this.cancel();
    }

    private void setProductData() throws NoSuchFieldException, IOException {
        BemMo bemMo = this.theMoHandler.getMo(this.configurationVersion);
        BemMo bemMo2 = null;
        try {
            Object object;
            bemMo2 = (BemMo)this.theMoHandler.getAttribute(bemMo, "currentUpgradePackage");
            NalStruct nalStruct = (NalStruct)this.theMoHandler.getAttribute(bemMo2, "administrativeData");
            String string = (String)nalStruct.getMemberValue("productNumber");
            String string2 = (String)nalStruct.getMemberValue("productRevision");
            String string3 = WizardHelp.getTheInstance().getDtdFilePath();
            InputStream inputStream = WelcomeController.class.getResourceAsStream(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = "";
            char[] cArray = new char[4096];
            int n = bufferedReader.read(cArray);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            while (n != -1) {
                n = bufferedReader.read(cArray);
                stringBuffer.append(cArray);
            }
            string4 = stringBuffer.toString();
            bufferedReader.close();
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "<!");
            String string5 = "";
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                int n2 = ((String)object).indexOf("revision");
                if (n2 == -1) continue;
                int n3 = ((String)object).indexOf("(");
                int n4 = ((String)object).indexOf(")");
                if (n3 == -1 || n4 == -1) continue;
                string5 = ((String)object).substring(n3 + 1, n4);
                break;
            }
            object = ExceptionProperties.getRevisionProperties();
            ((ExceptionProperties)object).setProperty("Upgrade Package Revision", string + " rev " + string2);
            ((ExceptionProperties)object).setProperty("DTD version", "O&M : " + string5);
            String string6 = "* Software package\n  Product number: " + string + "\n" + "  Product revision: " + string2 + "\n" + "  DTD version: " + string5;
            this.myView.setProductData(string6);
        }
        catch (MoHandlerException moHandlerException) {
            this.showError(moHandlerException.toString());
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WelcomeController.this.cancel();
        }
    }

    class NextButtonListener
    implements ActionListener {
        NextButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[][] objectArray = new String[0][0];
            WelcomeController.this.startWizard(false, BemLanguageHelp.getTranslation("NCONF_OAM_WIZARD_WINDOW_TITLE"), null, WelcomeController.this.getNextViewClass(), WelcomeController.this.getNextControllerClass(), objectArray);
            WelcomeController.this.myView.setTheViewToDummy();
        }
    }
}

