/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetParameter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpHostLinkConfigurationViewer;

public class IpHostLinkConfigurationView
extends BemWizardGuiView
implements IpHostLinkConfigurationViewer {
    private JPanel ipHostLinkPanel = null;
    private JPanel ipInterFacePanel = null;
    private JPanel vpnInterFacePanel = null;
    private JPanel hostEt2LinkPanel = null;
    private JPanel ipInterFace1Panel = null;
    private CustomerParameterTextField ipAddressField = null;
    private CustomerParameterComboBox ipHostLinkConfigurationModeField = null;
    private CustomerParameterTextField subnetMaskField = null;
    private CustomerParameterTextField defaultRouter0Field = null;
    private CustomerParameterTextField vidField = null;
    private CustomerParameterTextField ipsecVpnIpAddressField = null;
    private CustomerParameterTextField hostEt2_ipAddressField = null;
    private CustomerParameterTextField ipInterface1_subnetMaskField = null;
    private CustomerParameterTextField ipInterface1_defaultRouter0Field = null;
    private CustomerParameterTextField ipInterface1_vidField = null;
    private final List componentList = new ArrayList();
    private final JPanel mainPanel = new JPanel();

    protected void init() {
        try {
            super.init();
            this.initPanels();
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to initialize IP Host Link GUI.", exception);
        }
    }

    private void initPanels() throws Exception {
        this.mainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.mainPanel);
        this.ipHostLinkPanel = new JPanel();
        this.ipHostLinkPanel.setLayout(new GridBagLayout());
        this.ipHostLinkPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IPHOSTLINK_IP"));
        this.ipInterFacePanel = new JPanel();
        this.ipInterFacePanel.setLayout(new GridBagLayout());
        this.ipInterFacePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IPHOSTLINK_IP_INTERFACE"));
        this.vpnInterFacePanel = new JPanel();
        this.vpnInterFacePanel.setLayout(new GridBagLayout());
        this.vpnInterFacePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IPHOSTLINK_IP"));
        this.hostEt2LinkPanel = new JPanel();
        this.hostEt2LinkPanel.setLayout(new GridBagLayout());
        this.hostEt2LinkPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_OAM_HOST_ET"));
        this.ipInterFace1Panel = new JPanel();
        this.ipInterFace1Panel.setLayout(new GridBagLayout());
        this.ipInterFace1Panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IPHOSTLINK_IP_INTERFACE"));
        this.mainPanel.add((Component)this.ipHostLinkPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.ipInterFacePanel, new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.vpnInterFacePanel, new GridBagConstraints(0, 6, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.hostEt2LinkPanel, new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.ipInterFace1Panel, new GridBagConstraints(0, 12, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        JPanel jPanel = new JPanel();
        this.mainPanel.add((Component)jPanel, new GridBagConstraints(0, 17, 1, 5, 10.0, 10.0, 18, 1, new Insets(0, 0, 0, 0), 0, 1));
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_OAM_IPG_IPHOSTLINK_HEADING");
    }

    private void setBemComponent(CustomerParameterPanel customerParameterPanel, int n, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)customerParameterPanel, gridBagConstraints);
    }

    public void setCustomerParametersNoIpsec(CustomerParameter[] customerParameterArray) throws BemException {
        for (CustomerParameter customerParameter : customerParameterArray) {
            CustomerParameterPanel customerParameterPanel;
            if (customerParameter == null) continue;
            String string = customerParameter.getName();
            if (string.equals("OamIpHost_oamIpAddress")) {
                if (this.ipAddressField != null) continue;
                this.ipAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.ipAddressField, false);
                this.setBemComponent(customerParameterPanel, 0, this.ipHostLinkPanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_configurationMode")) {
                if (this.ipHostLinkConfigurationModeField != null) continue;
                this.ipHostLinkConfigurationModeField = new CustomerParameterComboBox((Enumeration)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("IP configuration mode:", this.ipHostLinkConfigurationModeField, false);
                this.setBemComponent(customerParameterPanel, 0, this.ipInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamSubnetMask")) {
                if (this.subnetMaskField != null) continue;
                this.subnetMaskField = new CustomerParameterTextField((SubnetParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("Subnet mask:", this.subnetMaskField);
                this.setBemComponent(customerParameterPanel, 1, this.ipInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamDefaultRouter0")) {
                if (this.defaultRouter0Field != null) continue;
                this.defaultRouter0Field = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("Default router 0:", this.defaultRouter0Field);
                this.setBemComponent(customerParameterPanel, 2, this.ipInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (!string.equals("OamIpHost_oamVid") || this.vidField != null) continue;
            this.vidField = new CustomerParameterTextField((IntegerParameter)customerParameter);
            customerParameterPanel = new CustomerParameterPanel("VID:", this.vidField);
            this.setBemComponent(customerParameterPanel, 3, this.ipInterFacePanel);
            this.componentList.add(customerParameterPanel);
        }
    }

    public void setCustomerParametersIpsec(CustomerParameter[] customerParameterArray) throws BemException {
        for (CustomerParameter customerParameter : customerParameterArray) {
            CustomerParameterPanel customerParameterPanel;
            if (customerParameter == null) continue;
            String string = customerParameter.getName();
            if (string.equals("OamIpHost_oamIpAddress")) {
                if (this.ipsecVpnIpAddressField != null) continue;
                this.ipsecVpnIpAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.ipsecVpnIpAddressField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.ipsecVpnIpAddressField);
                this.setBemComponent(customerParameterPanel, 0, this.vpnInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_outerOamIpAddressHostEt")) {
                if (this.hostEt2_ipAddressField != null) continue;
                this.hostEt2_ipAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.hostEt2_ipAddressField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.hostEt2_ipAddressField);
                this.setBemComponent(customerParameterPanel, 0, this.hostEt2LinkPanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamSubnetMask")) {
                if (this.ipInterface1_subnetMaskField != null) continue;
                this.ipInterface1_subnetMaskField = new CustomerParameterTextField((SubnetParameter)customerParameter);
                this.ipInterface1_subnetMaskField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Subnet mask:", this.ipInterface1_subnetMaskField);
                this.setBemComponent(customerParameterPanel, 0, this.ipInterFace1Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamDefaultRouter0")) {
                if (this.ipInterface1_defaultRouter0Field != null) continue;
                this.ipInterface1_defaultRouter0Field = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.ipInterface1_defaultRouter0Field.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Default router 0:", this.ipInterface1_defaultRouter0Field);
                this.setBemComponent(customerParameterPanel, 1, this.ipInterFace1Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamVid")) {
                if (this.ipInterface1_vidField != null) continue;
                this.ipInterface1_vidField = new CustomerParameterTextField((IntegerParameter)customerParameter);
                this.ipInterface1_vidField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("VID:", this.ipInterface1_vidField);
                this.setBemComponent(customerParameterPanel, 2, this.ipInterFace1Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (!string.equals("IPoverGigabitEthernet_syncIpAddress") || this.hostEt2_ipAddressField != null) continue;
            this.hostEt2_ipAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
            this.hostEt2_ipAddressField.setEnabled(false);
            customerParameterPanel = new CustomerParameterPanel("IP address:", this.hostEt2_ipAddressField);
            this.setBemComponent(customerParameterPanel, 0, this.hostEt2LinkPanel);
            this.componentList.add(customerParameterPanel);
        }
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        Iterator iterator = this.componentList.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
            break;
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        Iterator iterator = this.componentList.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            String string2 = customerParameterPanel.getLabel().getText().replace(':', ' ');
            return string2;
        }
        return null;
    }

    public void setCustomerParameters(CustomerParameter[] customerParameterArray, boolean bl, boolean bl2) throws BemException {
        if (bl) {
            this.vpnInterFacePanel.setVisible(true);
            this.hostEt2LinkPanel.setVisible(true);
            this.ipInterFace1Panel.setVisible(true);
            this.ipInterFacePanel.setVisible(false);
            this.ipHostLinkPanel.setVisible(false);
            this.setCustomerParametersIpsec(customerParameterArray);
        } else {
            this.vpnInterFacePanel.setVisible(false);
            this.hostEt2LinkPanel.setVisible(false);
            this.ipInterFace1Panel.setVisible(false);
            this.ipInterFacePanel.setVisible(true);
            this.ipHostLinkPanel.setVisible(true);
            this.setCustomerParametersNoIpsec(customerParameterArray);
            this.ipHostLinkConfigurationModeField.setEnabled(false);
            if (bl2) {
                if (this.ipAddressField != null) {
                    this.ipAddressField.setEnabled(false);
                }
                if (this.subnetMaskField != null) {
                    this.subnetMaskField.setEnabled(false);
                }
                if (this.defaultRouter0Field != null) {
                    this.defaultRouter0Field.setEnabled(false);
                }
                this.vidField.setEnabled(false);
            }
        }
    }
}

