/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetParameter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomHeaderRenderer;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpSyncConfigurationViewer;

public class IpSyncConfigurationView
extends BemWizardGuiView
implements IpSyncConfigurationViewer {
    private JPanel ipAccessHosEtPanel = null;
    private JPanel ipInterFacePanel = null;
    private JPanel ipSyncRefPanel = null;
    private JPanel hostEt3LinkPanel = null;
    private JPanel ipInterFace2Panel = null;
    private JPanel vpnInterFacePanel = null;
    private CustomerParameterTextField ipAddressField = null;
    private CustomerParameterTextField networkPrefixLengthField = null;
    private CustomerParameterTextField defaultRouter0Field = null;
    private CustomerParameterTextField vidField = null;
    private CustomerParameterTable ipSyncRefTable = null;
    private final List componentList = new ArrayList();
    private CustomerParameterTextField ipInterFace2_networkPrefixLengthField = null;
    private CustomerParameterTextField ipInterFace2_defaultRouter0Field = null;
    private CustomerParameterTextField ipInterFace2_vidField = null;
    private CustomerParameterTextField ipsecVpnIpAddressField = null;
    private CustomerParameterTextField hostEt3_ipAddressField = null;
    private final JPanel mainPanel = new JPanel();

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.initPanels();
    }

    private void initPanels() throws Exception {
        this.mainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.mainPanel);
        this.ipAccessHosEtPanel = new JPanel();
        this.ipAccessHosEtPanel.setLayout(new GridBagLayout());
        this.ipAccessHosEtPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IP_ACCESS_HOST"));
        this.ipInterFacePanel = new JPanel();
        this.ipInterFacePanel.setLayout(new GridBagLayout());
        this.ipInterFacePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IP_INTERFACE"));
        this.hostEt3LinkPanel = new JPanel();
        this.hostEt3LinkPanel.setLayout(new GridBagLayout());
        this.hostEt3LinkPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IUB_HOST_ET"));
        this.vpnInterFacePanel = new JPanel();
        this.vpnInterFacePanel.setLayout(new GridBagLayout());
        this.vpnInterFacePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IP_ACCESS_HOST"));
        this.ipInterFace2Panel = new JPanel();
        this.ipInterFace2Panel.setLayout(new GridBagLayout());
        this.ipInterFace2Panel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IP_INTERFACE"));
        this.ipSyncRefPanel = new JPanel();
        this.ipSyncRefPanel.setLayout(new GridBagLayout());
        this.ipSyncRefPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_IPG_IP_SYNC_REF"));
        this.mainPanel.add((Component)this.ipAccessHosEtPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.ipInterFacePanel, new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.vpnInterFacePanel, new GridBagConstraints(0, 6, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.hostEt3LinkPanel, new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.ipInterFace2Panel, new GridBagConstraints(0, 12, 1, 5, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 1));
        this.mainPanel.add((Component)this.ipSyncRefPanel, new GridBagConstraints(0, 17, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_OAM_IPG_IP_SYNCH_HEADING");
    }

    private void setBemComponent(CustomerParameterPanel customerParameterPanel, int n, JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(3, 5, 0, 0);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)customerParameterPanel, gridBagConstraints);
    }

    public void setCustomerParametersNoIpsec(CustomerParameter[] customerParameterArray) {
        for (CustomerParameter customerParameter : customerParameterArray) {
            CustomerParameterPanel customerParameterPanel;
            String string = customerParameter.getName();
            if (string.equals("IPoverGigabitEthernet_syncIpAddress")) {
                if (this.ipAddressField != null) continue;
                this.ipAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.ipAddressField, false);
                this.setBemComponent(customerParameterPanel, 0, this.ipAccessHosEtPanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_syncSubnetMask")) {
                if (this.networkPrefixLengthField != null) continue;
                this.networkPrefixLengthField = new CustomerParameterTextField((SubnetParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("Subnet Mask:", this.networkPrefixLengthField);
                this.setBemComponent(customerParameterPanel, 0, this.ipInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_defaultRouter0")) {
                if (this.defaultRouter0Field != null) continue;
                this.defaultRouter0Field = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                customerParameterPanel = new CustomerParameterPanel("Default router 0:", this.defaultRouter0Field);
                this.setBemComponent(customerParameterPanel, 1, this.ipInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (!string.equals("IPoverGigabitEthernet_syncVid") || this.vidField != null) continue;
            this.vidField = new CustomerParameterTextField((IntegerParameter)customerParameter);
            customerParameterPanel = new CustomerParameterPanel("VID:", this.vidField);
            this.setBemComponent(customerParameterPanel, 2, this.ipInterFacePanel);
            this.componentList.add(customerParameterPanel);
        }
    }

    public void setCustomerParametersIpsec(CustomerParameter[] customerParameterArray) {
        for (CustomerParameter customerParameter : customerParameterArray) {
            CustomerParameterPanel customerParameterPanel;
            String string = customerParameter.getName();
            if (string.equals("Iub_ipAddressHostEt")) {
                if (this.ipsecVpnIpAddressField != null) continue;
                this.ipsecVpnIpAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.ipsecVpnIpAddressField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.ipsecVpnIpAddressField);
                this.setBemComponent(customerParameterPanel, 0, this.vpnInterFacePanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_syncIpAddress") || string.equals("OamIpHost_outerOamIpAddressHostEt")) {
                if (this.hostEt3_ipAddressField != null) continue;
                this.hostEt3_ipAddressField = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.hostEt3_ipAddressField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("IP address:", this.hostEt3_ipAddressField);
                this.setBemComponent(customerParameterPanel, 0, this.hostEt3LinkPanel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_syncSubnetMask")) {
                if (this.ipInterFace2_networkPrefixLengthField != null) continue;
                this.ipInterFace2_networkPrefixLengthField = new CustomerParameterTextField((SubnetParameter)customerParameter);
                this.ipInterFace2_networkPrefixLengthField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Subnet mask:", this.ipInterFace2_networkPrefixLengthField);
                this.setBemComponent(customerParameterPanel, 0, this.ipInterFace2Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_defaultRouter0")) {
                if (this.ipInterFace2_defaultRouter0Field != null) continue;
                this.ipInterFace2_defaultRouter0Field = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.ipInterFace2_defaultRouter0Field.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Default router 0:", this.ipInterFace2_defaultRouter0Field);
                this.setBemComponent(customerParameterPanel, 1, this.ipInterFace2Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("IPoverGigabitEthernet_syncVid")) {
                if (this.ipInterFace2_vidField != null) continue;
                this.ipInterFace2_vidField = new CustomerParameterTextField((IntegerParameter)customerParameter);
                this.ipInterFace2_vidField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("VID:", this.ipInterFace2_vidField);
                this.setBemComponent(customerParameterPanel, 2, this.ipInterFace2Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamSubnetMask")) {
                if (this.ipInterFace2_networkPrefixLengthField != null) continue;
                this.ipInterFace2_networkPrefixLengthField = new CustomerParameterTextField((SubnetParameter)customerParameter);
                this.ipInterFace2_networkPrefixLengthField.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Subnet mask:", this.ipInterFace2_networkPrefixLengthField);
                this.setBemComponent(customerParameterPanel, 0, this.ipInterFace2Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (string.equals("OamIpHost_oamDefaultRouter0")) {
                if (this.ipInterFace2_defaultRouter0Field != null) continue;
                this.ipInterFace2_defaultRouter0Field = new CustomerParameterTextField((IpAddressParameter)customerParameter);
                this.ipInterFace2_defaultRouter0Field.setEnabled(false);
                customerParameterPanel = new CustomerParameterPanel("Default router 0:", this.ipInterFace2_defaultRouter0Field);
                this.setBemComponent(customerParameterPanel, 1, this.ipInterFace2Panel);
                this.componentList.add(customerParameterPanel);
                continue;
            }
            if (!string.equals("OamIpHost_oamVid") || this.ipInterFace2_vidField != null) continue;
            this.ipInterFace2_vidField = new CustomerParameterTextField((IntegerParameter)customerParameter);
            this.ipInterFace2_vidField.setEnabled(false);
            customerParameterPanel = new CustomerParameterPanel("VID:", this.ipInterFace2_vidField);
            this.setBemComponent(customerParameterPanel, 2, this.ipInterFace2Panel);
            this.componentList.add(customerParameterPanel);
        }
    }

    public void setIpSyncRefTableParameters(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (this.ipSyncRefTable == null) {
            this.ipSyncRefTable = new CustomerParameterTable(objectArray, stringArray, stringArray2);
            this.ipSyncRefTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
            TableColumn tableColumn = this.ipSyncRefTable.getColumnModel().getColumn(0);
            tableColumn.setMaxWidth(1);
            TableColumnModel tableColumnModel = this.ipSyncRefTable.getTableHeader().getColumnModel();
            int n = this.ipSyncRefTable.getRowHeight();
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn2 = tableColumnModel.getColumn(i);
                String string = "Sync Server Type";
                String string2 = "";
                string2 = (String)tableColumn2.getHeaderValue();
                CustomHeaderRenderer customHeaderRenderer = new CustomHeaderRenderer();
                if (string2.equals(string)) {
                    customHeaderRenderer.setToolTipText("BEM_OAM_SYNC_SERVER_TYPE");
                }
                tableColumn2.setHeaderRenderer(customHeaderRenderer);
                customHeaderRenderer.setPreferredSize(new Dimension(this.getWidth(), n));
            }
            JScrollPane jScrollPane = new JScrollPane(this.ipSyncRefTable);
            this.ipSyncRefPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getWizardPresenter().sniff(this);
        }
    }

    public void udpateIpSyncRefTable(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (this.ipSyncRefTable != null) {
            this.ipSyncRefTable.reArrangeTable(objectArray, stringArray, stringArray2);
        }
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        Iterator iterator = this.componentList.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
            break;
        }
        this.ipSyncRefTable.setFocusOnCell(string);
    }

    public String getGuiNameForCustomerParameter(String string) {
        Iterator iterator = this.componentList.iterator();
        CustomerParameterPanel customerParameterPanel = null;
        while (iterator.hasNext()) {
            customerParameterPanel = (CustomerParameterPanel)iterator.next();
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            String string2 = customerParameterPanel.getLabel().getText().replace(':', ' ');
            return string2;
        }
        String string3 = this.ipSyncRefTable.getRowAndColumnName(string);
        return string3;
    }

    public void setCustomerParameters(CustomerParameter[] customerParameterArray, boolean bl) throws BemException {
        if (bl) {
            this.vpnInterFacePanel.setVisible(true);
            this.hostEt3LinkPanel.setVisible(true);
            this.ipInterFace2Panel.setVisible(true);
            this.ipInterFacePanel.setVisible(false);
            this.ipAccessHosEtPanel.setVisible(false);
            this.setCustomerParametersIpsec(customerParameterArray);
        } else {
            this.vpnInterFacePanel.setVisible(false);
            this.hostEt3LinkPanel.setVisible(false);
            this.ipInterFace2Panel.setVisible(false);
            this.ipInterFacePanel.setVisible(true);
            this.ipAccessHosEtPanel.setVisible(true);
            this.setCustomerParametersNoIpsec(customerParameterArray);
        }
    }
}

