/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterList;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.NetworkSynchRefViewer;

public class NetworkSynchRefView
extends BemWizardGuiView
implements NetworkSynchRefViewer {
    private final JPanel mainPanel = new JPanel();
    private final JPanel syncPanel = new JPanel();
    private final JPanel cpriBasedSyncConfigPanel = new JPanel();
    private final JPanel syncRiPortCandidatePanel = new JPanel();
    CustomerParameterCheckbox configureCpriBasedSyncCheckbox;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel buttonPanel;
    private CustomerParameterList syncRiPortLeftList;
    private CustomerParameterList syncRiPortRightList;
    private boolean cpriBasedSyncPanelIsSet = false;
    private static String[] allowedPortRangeSingleDuw = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU1_F"};
    private static String[] allowedPortRangeDualDuw = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E"};
    private static String[] allowedPortRangeDBB22 = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU2_A", "BU2_B", "BU2_C", "BU2_D"};
    private DbbManager dbbManager;

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.mainPanel);
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_OAM_NW_SUBHEADER");
    }

    public void setBemComponents(CustomerParameterPanel[][] customerParameterPanelArray) {
        this.syncPanel.setLayout(new GridBagLayout());
        this.syncPanel.setBorder(new TitledBorder("Network Synchronization"));
        JLabel jLabel = new JLabel("Priority");
        this.syncPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        JLabel jLabel2 = new JLabel("Slot");
        this.syncPanel.add((Component)jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        JLabel jLabel3 = new JLabel("Board");
        this.syncPanel.add((Component)jLabel3, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        JLabel jLabel4 = new JLabel("Port");
        this.syncPanel.add((Component)jLabel4, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
        jLabel4.setToolTipText("<html>For GPB or CBU-based radio nodes:<br>1 to 4 means the PhysPathTerms and 5 to 6 means the Tu Synchronization Reference;<br>1 to 2 for Ip Synchronization Reference (synchPort represents the RDN ID of an Ip Synchronization Reference).<br><br>For RBS with DU radio nodes:<br>1 to 4 means the PhysPathTerms;<br>5 means the GPS Synchronization Reference;<br>6 means the Ip Synchronization Reference;<br>7 to 8 means Ip Synchronization Reference (synchPort represents the RDN ID of an Ip Synchronization Reference);<br>9 means STM-1 (Os155SpiTtp);<br>10 means GigabitEthernet, that is,gigabit Ethernet is used as a transport method for synchronization.<br>");
        for (int i = 1; i <= 8; ++i) {
            int n = i;
            int n2 = i;
            String string = "" + n2;
            JLabel jLabel5 = new JLabel(string);
            this.syncPanel.add((Component)jLabel5, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 10), 0, 0));
            this.syncPanel.add((Component)customerParameterPanelArray[i - 1][1], new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.syncPanel.add((Component)customerParameterPanelArray[i - 1][2], new GridBagConstraints(3, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.syncPanel.add((Component)customerParameterPanelArray[i - 1][3], new GridBagConstraints(4, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 0), 0, 0));
        }
        this.mainPanel.add((Component)this.syncPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
    }

    public void setCpriBasedSyncConfigCheckBox(YesNoCustomerParameter yesNoCustomerParameter) {
        if (yesNoCustomerParameter != null) {
            this.configureCpriBasedSyncCheckbox = new CustomerParameterCheckbox("", yesNoCustomerParameter);
            CustomerParameterPanel customerParameterPanel = new CustomerParameterPanel("ConfigureCpriBasedSync", this.configureCpriBasedSyncCheckbox);
            this.mainPanel.add((Component)customerParameterPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 0, 0));
        }
    }

    public void setCpriBasedSyncConfigPanel(Rbs rbs, boolean bl, Enumeration enumeration, Enumeration enumeration2, CustomerParameter customerParameter) {
        if (bl) {
            Serializable serializable;
            Serializable serializable2;
            this.cpriBasedSyncConfigPanel.setLayout(new GridBagLayout());
            this.cpriBasedSyncConfigPanel.setBorder(new TitledBorder("MSMM CPRI Based Synchronization"));
            if (enumeration != null) {
                serializable2 = new CustomerParameterComboBox(enumeration);
                serializable = new CustomerParameterPanel("AdministrativeState", (CustomerParameterComponent)((Object)serializable2));
                this.cpriBasedSyncConfigPanel.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            }
            if (enumeration2 != null) {
                serializable2 = new CustomerParameterComboBox(enumeration2);
                serializable = new CustomerParameterPanel("SyncNodePriority", (CustomerParameterComponent)((Object)serializable2));
                this.cpriBasedSyncConfigPanel.add((Component)serializable, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            }
            if (customerParameter != null) {
                Object object;
                String string;
                this.syncRiPortCandidatePanel.setLayout(new GridBagLayout());
                this.syncRiPortCandidatePanel.setBorder(new TitledBorder("SyncRiPortCandidate"));
                this.syncRiPortLeftList = new CustomerParameterList();
                this.syncRiPortRightList = new CustomerParameterList();
                serializable2 = new ArrayList();
                serializable = new ArrayList();
                boolean bl2 = false;
                String[] stringArray = allowedPortRangeSingleDuw;
                try {
                    this.dbbManager = new DbbManager(rbs);
                    bl2 = this.dbbManager.isTwoCpriLinkInstalled();
                }
                catch (BemException bemException) {
                    BemLog.exceptionRaised("Error happened when fetching digital building block", bemException);
                    bemException.printStackTrace();
                }
                if (DuwUtil.hasDualDuws()) {
                    stringArray = allowedPortRangeDualDuw;
                }
                if (bl2) {
                    stringArray = allowedPortRangeDBB22;
                }
                if (!(string = customerParameter.getValue()).equals("##UNDEFINED")) {
                    int n;
                    object = string.split(",");
                    for (n = 0; n < ((String[])object).length; ++n) {
                        this.syncRiPortRightList.addElement(object[n]);
                        ((ArrayList)serializable).add(object[n]);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        if (((ArrayList)serializable).contains(stringArray[n])) continue;
                        ((ArrayList)serializable2).add(stringArray[n]);
                    }
                    for (n = 0; n < ((ArrayList)serializable2).size(); ++n) {
                        this.syncRiPortLeftList.addElement(((ArrayList)serializable2).get(n));
                    }
                } else {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.syncRiPortLeftList.addElement(stringArray[i]);
                    }
                }
                this.syncRiPortLeftList.setVisibleRowCount(6);
                object = new JScrollPane(this.syncRiPortLeftList);
                ((JComponent)object).setPreferredSize(new Dimension(70, 90));
                this.syncRiPortLeftList.setToolTipText("SyncRiPort Range list for CPRI Based Sync ");
                this.syncRiPortRightList.setVisibleRowCount(6);
                JScrollPane jScrollPane = new JScrollPane(this.syncRiPortRightList);
                jScrollPane.setPreferredSize(new Dimension(70, 90));
                this.syncRiPortRightList.setToolTipText("SyncRiPortCandidate list for CPRI Based Sync ");
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new GridLayout(2, 1, 0, 20));
                this.addButton = new JButton("--->");
                this.deleteButton = new JButton("<---");
                this.buttonPanel.add(this.addButton);
                this.buttonPanel.add(this.deleteButton);
                if (this.syncRiPortRightList.getNumberOfValues() == 0) {
                    this.deleteButton.setEnabled(false);
                }
                if (this.syncRiPortLeftList.getNumberOfValues() == 0) {
                    this.addButton.setEnabled(false);
                }
                this.syncRiPortCandidatePanel.add((Component)object, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
                this.syncRiPortCandidatePanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
                this.syncRiPortCandidatePanel.add((Component)jScrollPane, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
                this.cpriBasedSyncConfigPanel.add((Component)this.syncRiPortCandidatePanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            }
            this.mainPanel.add((Component)this.cpriBasedSyncConfigPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 10, 0, 0), 0, 0));
        } else {
            this.buttonPanel.removeAll();
            this.syncRiPortCandidatePanel.removeAll();
            this.cpriBasedSyncConfigPanel.removeAll();
            this.cpriBasedSyncConfigPanel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            this.mainPanel.repaint();
        }
        this.setCpriBasedSyncConfig(bl);
    }

    public boolean cpriBasedSyncPanelIsSet() {
        return this.cpriBasedSyncPanelIsSet;
    }

    public void setCpriBasedSyncConfig(boolean bl) {
        this.cpriBasedSyncPanelIsSet = bl;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JComponent getRiPortRightComponent() {
        return this.syncRiPortRightList;
    }

    public JComponent getRiPortLeftComponent() {
        return this.syncRiPortLeftList;
    }
}

