/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.AntennaBranchViewer;

public class AntennaBranchController
extends BemWizardGuiController {
    private AntennaBranchViewer myView;
    private WizardCIModel wizardCiModel;
    private final List customerParameterNames = new ArrayList();
    private int[] activeSectors;
    private Rbs rbs;
    private int[][] sectorAntennaState;
    private AntennaBranchConfigurationListener textFieldListener;
    public static final int MANDATORY_INPUT = 0;
    public static final int OPTIONAL_INPUT = 1;
    public static final int CONFIGUTED_INPUT = 2;
    public static final int NA_INPUT = 3;
    public static final int INCORRECT_INPUT = 4;
    public static final String[] attrNames = new String[]{"fqBandLowEdgeBranch", "fqBandHighEdgeBranch", "antennaSupervisionBranch"};

    protected void init() {
        this.myView = (AntennaBranchViewer)((Object)this.getView());
        this.myView.setController(this);
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            Rbs rbs = this.wizardCiModel.getRbs();
            RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)rbs.getProvider(RadioEquipmentProvider.class);
            if (radioEquipmentProvider instanceof RadioEquipmentProviderWithRbb) {
                this.myView.initiateMainPanel();
            }
            int[] nArray = radioEquipmentProvider.getEquippedSectors();
            int[] nArray2 = null;
            if (rbs.isPantherHybridRbs()) {
                RadioEquipmentProvider radioEquipmentProvider2 = (RadioEquipmentProvider)rbs.getProvider(RadioEquipmentProvider.class, 1);
                int[] nArray3 = radioEquipmentProvider2.getEquippedSectors();
                nArray2 = WizardHelp.mergeIntArray(nArray, nArray3);
                if (!(radioEquipmentProvider instanceof RadioEquipmentProviderWithRbb) && radioEquipmentProvider2 instanceof RadioEquipmentProviderWithRbb) {
                    this.myView.initiateMainPanel();
                }
            } else {
                nArray2 = nArray;
            }
            this.activeSectors = nArray2;
            int n = this.activeSectors.length;
            this.sectorAntennaState = new int[n][ServiceCommon.BRANCH_NAMES.length];
            this.myView.arrangeOverviewTable(nArray2);
            this.myView.setListenerForAntennaBranchOverviewTable(new AntennaBranchOverviewListener());
            this.myView.arrangeAntennaConfigTable();
            this.checkInputValidation();
            this.updateParamListForCheckConsistency();
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Error has occured", exception);
            this.displayErrorMessage(exception.toString());
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.myView.editingStopped();
            this.checkInputValidation();
            this.rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            String string2 = this.myView.getGuiNameForCustomerParameter(string);
            this.displayErrorMessage(string2 + "\n" + customerParameterException.getReason());
            this.myView.setFocusOnCustomerParameterComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.customerParameterNames.clear();
        return true;
    }

    public int getSectorNumber(int n) {
        if (n >= 0) {
            return this.activeSectors[n];
        }
        return n;
    }

    public void checkInputValidation() {
        for (int i = 1; i <= this.activeSectors.length; ++i) {
            int n = this.activeSectors[i - 1];
            String string = String.valueOf(n);
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            try {
                int n3;
                for (int j = n3 = this.rbs.getAntennaSystemProvider(n2).getNumOfSupportedAntennaBranches(n); j < ServiceCommon.BRANCH_NAMES.length; ++j) {
                    this.changeTableCellStatus(i - 1, j, 3);
                }
                String string2 = MessageFormat.format("S{0}_", string);
                for (int j = 0; j < n3; ++j) {
                    boolean bl = false;
                    boolean bl2 = false;
                    int n4 = 0;
                    while (true) {
                        block16: {
                            String string3;
                            CustomerParameter customerParameter;
                            block15: {
                                if (n4 >= attrNames.length) break;
                                if (!AIRUtil.getInstance(this.rbs).isAirConfigured(n)) break block15;
                                if (attrNames[n4].equals("antennaSupervisionBranch")) break block16;
                            }
                            if ((customerParameter = this.rbs.getCustomerParameterObject(string3 = string2 + attrNames[n4] + ServiceCommon.BRANCH_NAMES[j])).getAccessLevel() == 1) {
                                this.changeTableCellStatus(i - 1, j, 3);
                            } else if (!(customerParameter.isDefault() || customerParameter.getValue().equals("") || customerParameter.getValue().equals("##UNDEFINED"))) {
                                if (!customerParameter.isValidValue()) {
                                    bl = true;
                                    break;
                                }
                                bl2 = true;
                            }
                        }
                        ++n4;
                    }
                    if (bl) {
                        this.sectorAntennaState[i - 1][j] = 4;
                        continue;
                    }
                    if (!bl2) continue;
                    this.sectorAntennaState[i - 1][j] = 2;
                }
                continue;
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised(bemException);
            }
        }
    }

    protected void updateParamListForCheckConsistency() {
        for (int i = 0; i < this.activeSectors.length; ++i) {
            int n = this.activeSectors[i];
            String string = MessageFormat.format("S{0}_", n);
            for (int j = 0; j < ServiceCommon.BRANCH_NAMES.length; ++j) {
                if (this.sectorAntennaState[i][j] == 3) continue;
                for (int k = 0; k < attrNames.length; ++k) {
                    if (AIRUtil.getInstance(this.rbs).isAirConfigured(n)) {
                        if (attrNames[k].equals("antennaSupervisionBranch")) continue;
                    }
                    String string2 = string + attrNames[k] + ServiceCommon.BRANCH_NAMES[j];
                    this.customerParameterNames.add(string2);
                }
            }
        }
    }

    public CustomerParameter getCP(String string) {
        CustomerParameter customerParameter = null;
        try {
            customerParameter = this.rbs.getCustomerParameterObject(string);
            if (customerParameter.getAccessLevel() != 1) {
                this.customerParameterNames.add(string);
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        return customerParameter;
    }

    public int[] getActiveSectors() {
        return this.activeSectors;
    }

    public int[][] getSectorAntennaState() {
        return this.sectorAntennaState;
    }

    public void changeTableCellStatus(int n, int n2, int n3) {
        this.sectorAntennaState[n][n2] = n3;
    }

    public AntennaBranchConfigurationListener getTextFieldListener() {
        if (this.textFieldListener == null) {
            this.textFieldListener = new AntennaBranchConfigurationListener();
        }
        return this.textFieldListener;
    }

    private class AntennaBranchConfigurationListener
    implements CustomerParameterListener {
        private AntennaBranchConfigurationListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && !customerParameter.isDefault()) {
                int n = AntennaBranchController.this.myView.getSelectedColumn() - 1;
                int n2 = AntennaBranchController.this.myView.getSelectedRow();
                AntennaBranchController.this.changeTableCellStatus(n, n2, 2);
            }
        }
    }

    private class AntennaBranchOverviewListener
    implements ListSelectionListener {
        private AntennaBranchOverviewListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AntennaBranchController.this.myView.updateSelectedCell();
            AntennaBranchController.this.myView.arrangeAntennaConfigTable();
        }
    }
}

