/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control.RetCascadingController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.RetCascadingViewer;

public class RetCascadingView
extends BemWizardGuiView
implements RetCascadingViewer {
    private final JPanel retCascadingMainPanel = new JPanel();
    private final JPanel sectorAntennaPanel = new JPanel();
    private final JPanel retCascadingPanel = new JPanel();
    private JPanel retConfigurationPanel = new JPanel();
    private JTable sectorAntennaOverviewTable;
    private JTable retOverviewTable;
    private JLabel sectorAntennaLabel;
    private JLabel sectorAntennaValueLabel;
    private JLabel sequenceNumberLabel;
    private JLabel sequenceNumberValueLabel;
    private JLabel antennaTypeLabel;
    private JComponent antennaTypeTextField;
    private JLabel uniqueHwIdLabel;
    private CustomerParameterTextField uniqueHwIdTextField;
    private CustomerParameterComboBox uniqueHwIdCombox;
    private JLabel electricalTiltLabel;
    private CustomerParameterTextField electricalTiltTextField;
    private JLabel userlabelParamLabel;
    private CustomerParameterTextField userlabelParamTextField;
    private JLabel mechanicalTiltLabel;
    private CustomerParameterTextField mechanicalTiltTextField;
    private RetCascadingController controller;
    private static final String SECTOR_ANTENNA = "Sector Antenna";
    private static final String SEQUENCE_NUMBER = "Sequence Number";
    private static final String USER_LABEL = "User Label";
    private static final String ANTENNA_TYPE = "Antenna Type";
    private static final String UNIQUE_HW_ID = "Unique Hardware Id";
    private static final String ELECTRICAL_TILT = "Electrical Tilt";
    private static final String MECHANICAL_TILT = "Mechanical Tilt";
    private int[][][] configFlags = null;

    protected void init() {
        super.init();
        this.retCascadingMainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.retCascadingMainPanel);
        this.sectorAntennaPanel.setLayout(new GridBagLayout());
        this.sectorAntennaPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_SITE_RC_SECTOR_ANTENNA_OVERVIEW")));
        this.retCascadingMainPanel.add((Component)this.sectorAntennaPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 1, new Insets(16, 10, 0, 9), 0, 0));
        this.retCascadingPanel.setLayout(new GridBagLayout());
        this.retCascadingPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_SITE_RC_ARET_OVERVIEW")));
        this.retCascadingMainPanel.add((Component)this.retCascadingPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(16, 10, 0, 9), 0, 0));
        this.retConfigurationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_SITE_RC_ARET_CONFIGURATION")));
        this.retConfigurationPanel.setLayout(new GridBagLayout());
        this.retCascadingMainPanel.add((Component)this.retConfigurationPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 5, 10), 0, 0));
    }

    public void setController(RetCascadingController retCascadingController) {
        this.controller = retCascadingController;
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_SITE_RC_SUB_TITLE");
    }

    public JTable setSectorAntennaOverviewParameters(Object[][] objectArray, String[] stringArray) {
        if (this.sectorAntennaOverviewTable != null) {
            this.sectorAntennaOverviewTable.setModel(new DefaultTableModel(objectArray, stringArray));
            return this.sectorAntennaOverviewTable;
        }
        this.sectorAntennaOverviewTable = new JTable(objectArray, stringArray){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.sectorAntennaOverviewTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.sectorAntennaOverviewTable.setDefaultRenderer(Object.class, new RetTableCellRenderer());
        this.sectorAntennaOverviewTable.setSelectionMode(0);
        this.sectorAntennaOverviewTable.setCellSelectionEnabled(true);
        this.sectorAntennaOverviewTable.setRowHeight(this.getFont().getSize() + 10);
        Dimension dimension = this.sectorAntennaOverviewTable.getPreferredSize();
        JScrollPane jScrollPane = new JScrollPane(this.sectorAntennaOverviewTable);
        jScrollPane.setPreferredSize(dimension);
        this.sectorAntennaPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this.sectorAntennaOverviewTable;
    }

    public JTable setRetOverviewParameters(Object[][] objectArray, String[] stringArray) {
        if (this.retOverviewTable != null) {
            this.retOverviewTable.setModel(new DefaultTableModel(objectArray, stringArray));
            return this.retOverviewTable;
        }
        this.retOverviewTable = new JTable(objectArray, stringArray){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.retOverviewTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.retOverviewTable.setDefaultRenderer(Object.class, new RetTableCellRenderer());
        this.retOverviewTable.setSelectionMode(0);
        this.retOverviewTable.setCellSelectionEnabled(true);
        this.retOverviewTable.setRowHeight(this.getFont().getSize() + 10);
        Dimension dimension = this.retOverviewTable.getPreferredSize();
        JScrollPane jScrollPane = new JScrollPane(this.retOverviewTable);
        jScrollPane.setPreferredSize(dimension);
        this.retCascadingPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this.retOverviewTable;
    }

    public void setRetConfigurationParameters(int n, int n2, String string, CustomerParameter customerParameter, CustomerParameter customerParameter2, CustomerParameter customerParameter3, CustomerParameter customerParameter4, CustomerParameter customerParameter5, DocumentListener documentListener) {
        JTextField jTextField;
        this.retCascadingMainPanel.remove(this.retConfigurationPanel);
        this.retConfigurationPanel = new JPanel();
        this.retConfigurationPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "Aret Configuration"));
        this.retConfigurationPanel.setLayout(new GridBagLayout());
        this.retCascadingMainPanel.add((Component)this.retConfigurationPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 12, 3, new Insets(5, 10, 5, 10), 0, 0));
        String string2 = n != 0 && n2 != 0 ? Integer.toString(n) + "-" + Integer.toString(n2) : "-";
        this.sectorAntennaLabel = new JLabel(SECTOR_ANTENNA, 2);
        this.sectorAntennaValueLabel = new JLabel(string2, 0);
        this.retConfigurationPanel.add((Component)this.sectorAntennaLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.retConfigurationPanel.add((Component)this.sectorAntennaValueLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.sequenceNumberLabel = new JLabel(SEQUENCE_NUMBER, 2);
        this.sequenceNumberValueLabel = new JLabel(string, 0);
        this.retConfigurationPanel.add((Component)this.sequenceNumberLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        this.retConfigurationPanel.add((Component)this.sequenceNumberValueLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.userlabelParamLabel = new JLabel(USER_LABEL, 2);
        this.retConfigurationPanel.add((Component)this.userlabelParamLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        if (string2.equals("-")) {
            jTextField = new JTextField("");
            jTextField.setEnabled(false);
            jTextField.setColumns(4);
            this.retConfigurationPanel.add((Component)jTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else {
            this.userlabelParamTextField = new CustomerParameterTextField(customerParameter5);
            this.userlabelParamTextField.setEnabled(true);
            this.userlabelParamTextField.setColumns(4);
            this.userlabelParamTextField.getDocument().addDocumentListener(documentListener);
            this.retConfigurationPanel.add((Component)this.userlabelParamTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        }
        this.antennaTypeLabel = new JLabel(ANTENNA_TYPE, 2);
        this.retConfigurationPanel.add((Component)this.antennaTypeLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        if (string2.equals("-")) {
            jTextField = new JTextField("");
            jTextField.setEnabled(false);
            jTextField.setColumns(4);
            this.retConfigurationPanel.add((Component)jTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else {
            if (AIRUtil.getInstance(SiteCIModel.getInstance().getRbs()).isAirConfigured(n) && "1".equals(string)) {
                this.antennaTypeTextField = new JLabel(customerParameter.getValue());
            } else {
                this.antennaTypeTextField = new CustomerParameterTextField(customerParameter);
                this.antennaTypeTextField.setEnabled(true);
                ((CustomerParameterTextField)this.antennaTypeTextField).setColumns(4);
                ((CustomerParameterTextField)this.antennaTypeTextField).getDocument().addDocumentListener(documentListener);
            }
            this.retConfigurationPanel.add((Component)this.antennaTypeTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        }
        this.uniqueHwIdLabel = new JLabel(UNIQUE_HW_ID, 2);
        this.retConfigurationPanel.add((Component)this.uniqueHwIdLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 10), 0, 0));
        if (string2.equals("-")) {
            jTextField = new JTextField("");
            jTextField.setEnabled(false);
            jTextField.setColumns(4);
            this.retConfigurationPanel.add((Component)jTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else if (customerParameter2 instanceof Enumeration) {
            this.uniqueHwIdCombox = new CustomerParameterComboBox((Enumeration)customerParameter2);
            this.retConfigurationPanel.add((Component)this.uniqueHwIdCombox, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else {
            this.uniqueHwIdTextField = new CustomerParameterTextField(customerParameter2);
            this.uniqueHwIdTextField.setEnabled(true);
            this.uniqueHwIdTextField.setColumns(4);
            this.uniqueHwIdTextField.getDocument().addDocumentListener(documentListener);
            this.retConfigurationPanel.add((Component)this.uniqueHwIdTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        }
        this.electricalTiltLabel = new JLabel(ELECTRICAL_TILT, 2);
        this.retConfigurationPanel.add((Component)this.electricalTiltLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 5, 10), 0, 0));
        if (string2.equals("-")) {
            jTextField = new JTextField("");
            jTextField.setEnabled(false);
            jTextField.setColumns(4);
            this.retConfigurationPanel.add((Component)jTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        } else {
            this.electricalTiltTextField = new CustomerParameterTextField(customerParameter3);
            this.electricalTiltTextField.setEnabled(true);
            this.electricalTiltTextField.setColumns(4);
            this.electricalTiltTextField.getDocument().addDocumentListener(documentListener);
            this.retConfigurationPanel.add((Component)this.electricalTiltTextField, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (customerParameter4 != null) {
            this.mechanicalTiltLabel = new JLabel(MECHANICAL_TILT, 2);
            this.retConfigurationPanel.add((Component)this.mechanicalTiltLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 5, 10), 0, 0));
            if (string2.equals("-")) {
                jTextField = new JTextField("");
                jTextField.setEnabled(false);
                jTextField.setColumns(4);
                this.retConfigurationPanel.add((Component)jTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
            } else {
                this.mechanicalTiltTextField = new CustomerParameterTextField(customerParameter4);
                this.mechanicalTiltTextField.setEnabled(true);
                this.mechanicalTiltTextField.setColumns(4);
                this.mechanicalTiltTextField.getDocument().addDocumentListener(documentListener);
                this.retConfigurationPanel.add((Component)this.mechanicalTiltTextField, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
            }
        }
        this.retCascadingMainPanel.repaint();
        this.retCascadingMainPanel.validate();
    }

    public void initConfigFlags(int n, int n2, int n3) {
        if (this.configFlags == null) {
            this.configFlags = new int[n + 1][n2][n3];
            for (int i = 0; i < n + 1; ++i) {
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        this.configFlags[i][j][k] = -1;
                    }
                }
            }
        }
    }

    public int[][][] getConfigFlags() {
        return this.configFlags;
    }

    public String getSectorAntennaSequenceNames(String string) {
        String string2 = string.substring(1, 2);
        String string3 = string.endsWith("2") ? "2" : "1";
        String string4 = string.indexOf("SEQ") != -1 ? string.substring(6, 7) : "1";
        return "Sector " + string2 + ", Antenna " + string3 + ", Sequence " + string4;
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = null;
        String string3 = this.getSectorAntennaSequenceNames(string);
        if (string.endsWith("antennaType") || string.substring(0, string.length() - 2).endsWith("antennaType")) {
            string2 = ANTENNA_TYPE;
        } else if (string.endsWith("uniqueHwId") || string.substring(0, string.length() - 2).endsWith("uniqueHwId")) {
            string2 = UNIQUE_HW_ID;
        } else if (string.endsWith("electricalTilt") || string.substring(0, string.length() - 2).endsWith("electricalTilt")) {
            string2 = ELECTRICAL_TILT;
        } else if (string.endsWith("mechanicalTilt") || string.substring(0, string.length() - 2).endsWith("mechanicalTilt")) {
            string2 = MECHANICAL_TILT;
        } else if (string.endsWith("userLabel") || string.substring(0, string.length() - 2).endsWith("userLabel")) {
            string2 = USER_LABEL;
        }
        return string2 + " for " + string3;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
    }

    public void removeListenerOfTextField(DocumentListener documentListener) {
        if (null != this.userlabelParamTextField) {
            this.userlabelParamTextField.getDocument().removeDocumentListener(documentListener);
        }
        if (null != this.antennaTypeTextField && this.antennaTypeTextField instanceof CustomerParameterTextField) {
            ((CustomerParameterTextField)this.antennaTypeTextField).getDocument().removeDocumentListener(documentListener);
        }
        if (null != this.uniqueHwIdTextField) {
            this.uniqueHwIdTextField.getDocument().removeDocumentListener(documentListener);
        }
        if (null != this.electricalTiltTextField) {
            this.electricalTiltTextField.getDocument().removeDocumentListener(documentListener);
        }
        if (null != this.mechanicalTiltTextField) {
            this.mechanicalTiltTextField.getDocument().removeDocumentListener(documentListener);
        }
    }

    public void addListenerOfComboBox(ItemListener itemListener) {
        if (null != this.uniqueHwIdCombox) {
            this.uniqueHwIdCombox.addItemListener(itemListener);
        }
    }

    public void removeListenerOfComboBox(ItemListener itemListener) {
        if (null != this.uniqueHwIdCombox) {
            this.uniqueHwIdCombox.removeItemListener(itemListener);
        }
    }

    public class RetTableCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(Color.BLACK);
            if (n2 == 0) {
                this.setHorizontalAlignment(2);
            } else if (RetCascadingView.this.configFlags != null) {
                int n3;
                if (jTable == RetCascadingView.this.sectorAntennaOverviewTable) {
                    RetCascadingView.this.controller;
                    n3 = 2;
                    for (int i = 0; i < RetCascadingView.this.retOverviewTable.getRowCount(); ++i) {
                        int n4 = RetCascadingView.this.configFlags[n2][n][i];
                        RetCascadingView.this.controller;
                        if (n4 == 2) continue;
                        int n5 = RetCascadingView.this.configFlags[n2][n][i];
                        RetCascadingView.this.controller;
                        if (n5 == 0) continue;
                        n3 = RetCascadingView.this.configFlags[n2][n][i];
                        break;
                    }
                } else {
                    n3 = jTable == RetCascadingView.this.retOverviewTable && ((RetCascadingView)RetCascadingView.this).controller.selectedColSectorAntennaOverview >= 0 && ((RetCascadingView)RetCascadingView.this).controller.selectedRowSectorAntennaOverview >= 0 ? RetCascadingView.this.configFlags[((RetCascadingView)RetCascadingView.this).controller.selectedColSectorAntennaOverview][((RetCascadingView)RetCascadingView.this).controller.selectedRowSectorAntennaOverview][n] : -1;
                }
                switch (n3) {
                    case 0: {
                        this.setText("");
                        break;
                    }
                    case 1: {
                        this.setHorizontalAlignment(0);
                        this.setText("*");
                        break;
                    }
                    case 3: {
                        this.setHorizontalAlignment(2);
                        this.setText("Incorrect");
                        break;
                    }
                    case 2: {
                        this.setHorizontalAlignment(4);
                        String string = "-";
                        int n6 = RetCascadingView.this.controller.getEquipedSectors().length;
                        if (jTable == RetCascadingView.this.sectorAntennaOverviewTable) {
                            if (n6 >= n2) {
                                string = RetCascadingView.this.controller.getEquipedSectors()[n2 - 1] + "-" + Integer.toString(n + 1);
                            } else {
                                this.setHorizontalAlignment(0);
                                this.setText("-");
                            }
                        } else if (jTable == RetCascadingView.this.retOverviewTable) {
                            string = RetCascadingView.this.controller.getEquipedSectors()[((RetCascadingView)RetCascadingView.this).controller.selectedColSectorAntennaOverview - 1] + "-" + Integer.toString(((RetCascadingView)RetCascadingView.this).controller.selectedRowSectorAntennaOverview + 1) + "-" + Integer.toString(n + 1);
                        }
                        this.setText(string);
                        break;
                    }
                    case -1: {
                        this.setHorizontalAlignment(0);
                        this.setText("-");
                        break;
                    }
                }
            }
            return this;
        }
    }
}

