/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.SiteLocationViewer;

public class SiteLocationView
extends BemWizardGuiView
implements SiteLocationViewer {
    private final JPanel siteInfoMainPanel = new JPanel();
    private final JPanel siteInfoDataPanel = new JPanel();
    private final JPanel wantedPosPanel = new JPanel();
    private CustomerParameterTextField siteNameComponent;
    private CustomerParameterPanel siteNamePanel;
    private CustomerParameterTextField logicalNameComponent;
    private CustomerParameterPanel logicalNamePanel;
    private CustomerParameterTextField latitudeComponent;
    private CustomerParameterPanel latitudePanel;
    private CustomerParameterTextField longitudeComponent;
    private CustomerParameterPanel longitudePanel;
    private CustomerParameterTextField altitudeComponent;
    private CustomerParameterPanel altitudePanel;
    private CustomerParameterTextField toleranceComponent;
    private CustomerParameterPanel tolerancePanel;
    private static final String SITE_NAME = "Site:";
    private static final String LOGICAL_NAME = "Logical name:";
    private static final String LATITUDE_NAME = "Latitude:";
    private static final String LONGITUDE_NAME = "Longitude:";
    private static final String ALTITUDE_NAME = "Altitude:";
    private static final String TOLERANCE_NAME = "Tolerance:";

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.siteInfoMainPanel.setLayout(new GridBagLayout());
        this.addMainPanel(this.siteInfoMainPanel);
        this.siteInfoDataPanel.setLayout(new GridBagLayout());
        this.siteInfoDataPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_SIT_SUB_HEADING")));
        this.siteInfoMainPanel.add((Component)this.siteInfoDataPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 19, 2, new Insets(16, 10, 0, 9), 0, 0));
        this.wantedPosPanel.setLayout(new GridBagLayout());
        this.wantedPosPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), WizardLanguageHelp.getTranslation("NCONF_SIT_WANTED_POS")));
        this.siteInfoMainPanel.add((Component)this.wantedPosPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 19, 2, new Insets(16, 10, 0, 9), 0, 0));
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_SITE_LOCATION_HEADING");
    }

    public void setSiteNameParameter(CustomerParameter customerParameter) {
        if (this.siteNameComponent == null) {
            this.siteNameComponent = new CustomerParameterTextField(customerParameter);
            this.siteNamePanel = new CustomerParameterPanel(SITE_NAME, this.siteNameComponent);
            this.addSubComponent(this.siteInfoDataPanel, this.siteNamePanel, 0);
        }
    }

    public void setWantedPositionParameters(CustomerParameter customerParameter, CustomerParameter customerParameter2, CustomerParameter customerParameter3, IntegerParameter integerParameter) {
        int n = 0;
        if (this.latitudeComponent == null) {
            this.latitudeComponent = new CustomerParameterTextField(customerParameter);
            this.latitudePanel = new CustomerParameterPanel(LATITUDE_NAME, this.latitudeComponent);
            this.addSubComponent(this.wantedPosPanel, this.latitudePanel, n++);
        }
        if (this.longitudeComponent == null) {
            this.longitudeComponent = new CustomerParameterTextField(customerParameter2);
            this.longitudePanel = new CustomerParameterPanel(LONGITUDE_NAME, this.longitudeComponent);
            this.addSubComponent(this.wantedPosPanel, this.longitudePanel, n++);
        }
        if (this.altitudeComponent == null) {
            this.altitudeComponent = new CustomerParameterTextField(customerParameter3);
            this.altitudePanel = new CustomerParameterPanel(ALTITUDE_NAME, this.altitudeComponent);
            this.addSubComponent(this.wantedPosPanel, this.altitudePanel, n++);
        }
        if (this.toleranceComponent == null) {
            this.toleranceComponent = new CustomerParameterTextField(integerParameter);
            this.tolerancePanel = new CustomerParameterPanel(TOLERANCE_NAME, this.toleranceComponent);
            this.addSubComponent(this.wantedPosPanel, this.tolerancePanel, n++);
        }
    }

    private void addSubComponent(JPanel jPanel, CustomerParameterPanel customerParameterPanel, int n) {
        jPanel.add((Component)customerParameterPanel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 10, 4, 10), 0, 0));
    }

    public void setLogicalNameParameter(CustomerParameter customerParameter) {
        if (this.logicalNameComponent == null) {
            this.logicalNameComponent = new CustomerParameterTextField(customerParameter);
            this.logicalNamePanel = new CustomerParameterPanel(LOGICAL_NAME, this.logicalNameComponent);
            this.addSubComponent(this.siteInfoDataPanel, this.logicalNamePanel, 1);
        }
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (string.equals("logicalName")) {
            this.logicalNameComponent.requestFocus();
        } else if (string.equals("siteName")) {
            this.siteNameComponent.requestFocus();
        } else if (string.equals("latitude")) {
            this.latitudeComponent.requestFocus();
        } else if (string.equals("longitude")) {
            this.longitudeComponent.requestFocus();
        } else if (string.equals("altitude")) {
            this.altitudeComponent.requestFocus();
        } else if (string.equals("tolerance")) {
            this.toleranceComponent.requestFocus();
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = "";
        if (string.equals("logicalName")) {
            string2 = LOGICAL_NAME;
        } else if (string.equals("siteName")) {
            string2 = SITE_NAME;
        } else if (string.equals("latitude")) {
            string2 = LATITUDE_NAME;
        } else if (string.equals("longitude")) {
            string2 = LONGITUDE_NAME;
        } else if (string.equals("altitude")) {
            string2 = ALTITUDE_NAME;
        } else if (string.equals("tolerance")) {
            string2 = TOLERANCE_NAME;
        }
        return string2;
    }
}

