/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionConstants;
import se.ericsson.wcdma.rbs.bem.common.gui.EasyPopUp;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.wcdma.support.gui.guilib.comp.IconHelper;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractRequest;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.wcdma.support.gui.guilib.infra.BrowserHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.ComponentSniffer;
import se.ericsson.wcdma.support.gui.guilib.infra.DialogModalPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.DialogPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.HelpManager;
import se.ericsson.wcdma.support.gui.guilib.infra.LanguageManager;
import se.ericsson.wcdma.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.wcdma.support.gui.guilib.infra.RequestHandler;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardModalPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.WizardPresenter;

public abstract class AbstractController
implements EasyPopUp.Parent,
ExceptionConstants {
    private AbstractPresenter presenter;
    private JDialog dialog;
    private final EasyPopUp easyPopUps = new EasyPopUp(this);

    void init(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    void dispose() {
        this.presenter = null;
    }

    boolean isDisposed() {
        return this.presenter == null;
    }

    public AbstractApplication getApplication() {
        return this.presenter.getApplication();
    }

    protected Hashtable getExternalApplications() {
        return null;
    }

    public Vector getApplications() {
        Vector vector = new Vector();
        Enumeration enumeration = this.getApplication().getApplicationManager().getAllApplications();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public ApplicationManager getApplicationManager() {
        return this.getApplication().getApplicationManager();
    }

    public AbstractController getParentController() {
        AbstractController abstractController = null;
        AbstractPresenter abstractPresenter = this.presenter.getParentPresenter();
        if (abstractPresenter != null) {
            abstractController = abstractPresenter.getController();
        }
        return abstractController;
    }

    public String getProperty(String string) {
        return this.presenter.getApplication().getEnvironment().getProperty(string);
    }

    public AbstractView getView() {
        if (this.presenter != null) {
            return this.presenter.getView();
        }
        Nal.getFactory().getLog().nalTrace(2, this.getClass(), "presenter is null, when getview");
        return null;
    }

    protected abstract void init();

    protected void beforeVisible() {
    }

    protected void afterVisible() {
    }

    void viewClosing() {
    }

    public boolean verifyUserExiting() {
        Object[] objectArray = new Object[]{this.getApplication().getTitle()};
        String string = this.getString("GSL_EXIT_MSG", null);
        String string2 = this.getString("GSL_EXIT_TITLE", null);
        String string3 = MessageFormat.format(string, objectArray);
        String string4 = MessageFormat.format(string2, objectArray);
        int n = JOptionPane.showConfirmDialog(this.presenter.getView(), string3, string4, 0, 1, null);
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        return false;
    }

    protected boolean canStop() {
        return true;
    }

    protected void stop() {
    }

    public void addLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        this.presenter.addLocaleChangeListener(localeChangeListener);
    }

    public void removeLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        this.presenter.removeLocaleChangeListener(localeChangeListener);
    }

    public AbstractApplication startApplication(String string, Object[][] objectArray) {
        return this.startApplication(string, objectArray, true);
    }

    public AbstractApplication startApplication(String string, Object[][] objectArray, boolean bl) {
        return this.getApplicationManager().startApplication(string, objectArray, BemLaunchable.UNKNOWN, false, bl);
    }

    public void stopApplication() {
        this.getApplication().stopApplication();
    }

    public int showConfirmDialog(String string, Object[] objectArray, String string2, Object[] objectArray2, int n, int n2, String string3) {
        Icon icon = IconHelper.createIcon(string3);
        String string4 = this.getString(string, objectArray);
        String string5 = this.getString(string2, objectArray2);
        if (n == 0) {
            Object[] objectArray3 = new String[]{this.getString("GSL_YES", objectArray), this.getString("GSL_NO", objectArray)};
            int n3 = JOptionPane.showOptionDialog(this.presenter.getView(), string4, string5, 0, n2, null, objectArray3, objectArray3[1]);
            return n3;
        }
        return JOptionPane.showConfirmDialog(this.presenter.getView(), string4, string5, n, n2, icon);
    }

    public Object showInputDialog(String string, Object[] objectArray, String string2, Object[] objectArray2, int n, String string3, Object[] objectArray3, Object object) {
        Icon icon = IconHelper.createIcon(string3);
        String string4 = this.getString(string, objectArray);
        String string5 = this.getString(string2, objectArray2);
        return JOptionPane.showInputDialog(this.presenter.getView(), string4, string5, n, icon, objectArray3, object);
    }

    public void showMessageDialog(String string, Object[] objectArray, String string2, Object[] objectArray2, int n, String string3) {
        JTextArea jTextArea = new JTextArea(this.getString(string, objectArray));
        jTextArea.setEditable(false);
        jTextArea.setBackground(this.getView().getBackground());
        jTextArea.setFont(this.getView().getFont());
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(400, 120));
        JOptionPane jOptionPane = new JOptionPane(jScrollPane, n);
        this.dialog = jOptionPane.createDialog(this.getView(), this.getString(string2, objectArray2));
        this.dialog.setResizable(true);
        this.dialog.show();
    }

    protected JDialog getMessageDialog() {
        return this.dialog;
    }

    public void showOptionDialog(String string, Object[] objectArray, String string2, Object[] objectArray2, int n, int n2, String string3, Object[] objectArray3, Object object) {
        Icon icon = IconHelper.createIcon(string3);
        String string4 = this.getString(string, objectArray);
        String string5 = this.getString(string2, objectArray2);
        JOptionPane.showOptionDialog(this.presenter.getView(), string4, string5, n, n2, icon, objectArray3, object);
    }

    public synchronized AbstractDialogController startDialog(boolean bl, String string, Object[] objectArray, Class clazz, Class clazz2) {
        return this.startDialog(bl, string, objectArray, clazz, clazz2, null);
    }

    public synchronized AbstractDialogController startDialog(boolean bl, String string, Object[] objectArray, Class clazz, Class clazz2, Object[][] objectArray2) {
        AbstractPresenter abstractPresenter = bl ? AbstractPresenter.createPresenter(this.presenter, this.getApplication(), DialogModalPresenter.class, clazz, clazz2, objectArray2) : AbstractPresenter.createPresenter(this.presenter, this.getApplication(), DialogPresenter.class, clazz, clazz2, objectArray2);
        abstractPresenter.setTitle(string, objectArray);
        abstractPresenter.setVisible(true);
        return (AbstractDialogController)abstractPresenter.getController();
    }

    public void setLocation(int n, int n2) {
        this.presenter.setLocation(n, n2);
    }

    public Point getLocation() {
        return this.presenter.getLocation();
    }

    public Object getParameter(String string) {
        return this.presenter.getParameter(string);
    }

    public synchronized void startWizard(boolean bl, String string, Object[] objectArray, Class clazz, Class clazz2) {
        this.startWizard(bl, string, objectArray, clazz, clazz2, null);
    }

    public synchronized void startWizard(boolean bl, String string, Object[] objectArray, Class clazz, Class clazz2, Object[][] objectArray2) {
        AbstractPresenter abstractPresenter = bl ? AbstractPresenter.createPresenter(this.presenter, this.getApplication(), WizardModalPresenter.class, clazz, clazz2, objectArray2) : AbstractPresenter.createPresenter(this.presenter, this.getApplication(), WizardPresenter.class, clazz, clazz2, objectArray2);
        abstractPresenter.setTitle();
        abstractPresenter.setVisible(true);
    }

    protected String getHelpId() {
        return "GSL_DEFAULTMENU_HELPMENU_ONWINDOW";
    }

    public void showWebPage(URL uRL) {
        BrowserHelp browserHelp = (BrowserHelp)this.presenter.getHelp();
        browserHelp.startBrowser(uRL);
    }

    public void bindObject(String string, Object object) {
        this.getApplicationManager().getObjectNamingService().put(string, object);
    }

    public void unbindObject(String string) {
        this.getApplicationManager().getObjectNamingService().remove(string);
    }

    public Object resolveObject(String string) {
        return this.getApplicationManager().getObjectNamingService().get(string);
    }

    public void invokeRequest(AbstractRequest abstractRequest) {
        new RequestHandler(this, abstractRequest).invokeRequest();
    }

    public void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        LanguageManager languageManager = (LanguageManager)this.presenter.createHandler(LanguageManager.class);
        languageManager.stripShortCut(true);
        ComponentSniffer componentSniffer = new ComponentSniffer(jPopupMenu);
        componentSniffer.addComponentHandler(languageManager);
        HelpManager helpManager = (HelpManager)this.presenter.createHandler(HelpManager.class);
        componentSniffer.addComponentHandler(helpManager);
        componentSniffer.sniff();
        componentSniffer.updateLocale(this.getApplication().getLocale());
        ComponentToolkit.updateLookAndFeel(jPopupMenu);
        jPopupMenu.show(component, n, n2);
    }

    public String getString(String string, Object[] objectArray) {
        String string2 = "";
        if (string != null && !string.equals("")) {
            string2 = this.getString(string, true);
            if (objectArray != null) {
                string2 = MessageFormat.format(string2, objectArray);
            }
        }
        return string2;
    }

    public String getFormattedValueTooltip(Object object, Object object2) {
        return MessageFormat.format(this.getString("GSL_FORMATTED_VALUE_TOOLTIP", true), object, object2);
    }

    public EasyPopUp getEasyPopUp() {
        return this.easyPopUps;
    }

    public void displayCustomerParameterWarning(CustomerParameterException customerParameterException) {
        this.easyPopUps.displayCustomerParameterWarning(customerParameterException);
    }

    public String getPageSubTitle() {
        return "";
    }

    private String getString(String string, boolean bl) {
        return this.presenter.getLanguageManager().getString(string, bl);
    }

    Class getClassForName(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            String string2 = "Could not create class: " + string;
            Log.logError(string2, throwable);
            Log.assertion(false, string2);
        }
        return clazz;
    }
}

