/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import se.ericsson.wcdma.support.gui.guilib.comp.IconHelper;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationView;

public class ApplicationDefaultView
extends AbstractApplicationView {
    Icon cut_Icon = null;
    Icon copy_Icon = null;
    Icon paste_Icon = null;
    Icon contextHelp_Icon = null;
    CutAbstractAction cutAction = null;
    CopyAbstractAction copyAction = null;
    PasteAbstractAction pasteAction = null;
    JMenu fileMenu;
    JMenuItem closeMenuItem = null;
    JMenuItem exitMenuItem = null;
    JMenu editMenu;
    JMenuItem cutMenuItem = null;
    JMenuItem copyMenuItem = null;
    JMenuItem pasteMenuItem = null;
    JMenu optionsMenu;
    JMenuItem logOptionsMenuItem;
    JMenu helpMenu;
    JMenuItem onWindowHelpMenuItem;
    JMenuItem howToHelpMenuItem;
    JMenuItem contentsHelpMenuItem;
    JMenuItem aboutMenuItem;
    JButton cutButton = null;
    JButton copyButton = null;
    JButton pasteButton = null;

    protected void init() {
        this.fileMenu = new JMenu("GSL_FILE");
        if (this.isInitialApplication()) {
            this.exitMenuItem = new JMenuItem("GSL_EXIT");
        } else {
            this.closeMenuItem = new JMenuItem("GSL_CLOSE");
        }
        this.optionsMenu = new JMenu("GSL_OPTIONS");
        this.logOptionsMenuItem = new JMenuItem("GSL_LOGOPTIONS", IconHelper.LOGOPTIONS);
        this.helpMenu = new JMenu("GSL_HELP");
        this.onWindowHelpMenuItem = new JMenuItem("GSL_ON_WINDOW_HELP", IconHelper.WINDOW_DESCRIPTION);
        this.howToHelpMenuItem = new JMenuItem("Using Help");
        this.howToHelpMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.howToHelpMenuItem.setMnemonic('u');
        this.contentsHelpMenuItem = new JMenuItem("GSL_CONTENTS_HELP", IconHelper.CONTENTS);
        this.aboutMenuItem = new JMenuItem("About " + this.getApplication().getBemLaunchable().getApplName());
        this.aboutMenuItem.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.aboutMenuItem.setMnemonic('a');
        this.initEditActions();
    }

    protected void dispose() {
        super.dispose();
    }

    Action[] getEditActions() {
        return new Action[]{this.cutAction, this.copyAction, this.pasteAction};
    }

    void initEditActions() {
        this.cut_Icon = IconHelper.CUT;
        this.cutAction = new CutAbstractAction("GSL_CUT", this.cut_Icon);
        this.copy_Icon = IconHelper.COPY;
        this.copyAction = new CopyAbstractAction("GSL_COPY", this.copy_Icon);
        this.paste_Icon = IconHelper.PASTE;
        this.pasteAction = new PasteAbstractAction("GSL_PASTE", this.paste_Icon);
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
    }

    void initEditButtons() {
        JToolBar jToolBar = new JToolBar();
        this.cutButton = jToolBar.add(this.cutAction);
        this.cutButton.setText("");
        this.cutButton.setToolTipText("GSL_CUT");
        this.copyButton = jToolBar.add(this.copyAction);
        this.copyButton.setText("");
        this.copyButton.setToolTipText("GSL_COPY");
        this.pasteButton = jToolBar.add(this.pasteAction);
        this.pasteButton.setText("");
        this.pasteButton.setToolTipText("GSL_PASTE");
        jToolBar.removeAll();
    }

    private JMenu createFileMenu() {
        JMenu jMenu = null;
        JMenuItem[] jMenuItemArray = this.getApplicationView().getFileMenuItems();
        if (jMenuItemArray != null) {
            this.fileMenu.removeAll();
            for (int i = 0; i < jMenuItemArray.length; ++i) {
                if (jMenuItemArray[i] == null) {
                    this.fileMenu.addSeparator();
                    continue;
                }
                this.fileMenu.add(jMenuItemArray[i]);
            }
            if (jMenuItemArray.length != 0) {
                this.fileMenu.addSeparator();
            }
            if (this.closeMenuItem != null) {
                this.fileMenu.add(this.closeMenuItem);
            }
            if (this.exitMenuItem != null) {
                this.fileMenu.add(this.exitMenuItem);
            }
            jMenu = this.fileMenu;
            jMenu = this.fileMenu;
        }
        return jMenu;
    }

    private JMenu createOptionsMenu() {
        JMenu jMenu = null;
        JMenuItem[] jMenuItemArray = this.getApplicationView().getOptionsMenuItems();
        if (jMenuItemArray != null) {
            this.optionsMenu.removeAll();
            for (int i = 0; i < jMenuItemArray.length; ++i) {
                if (jMenuItemArray[i] == null) {
                    this.optionsMenu.addSeparator();
                    continue;
                }
                this.optionsMenu.add(jMenuItemArray[i]);
            }
            if (this.isInitialApplication()) {
                if (jMenuItemArray.length != 0) {
                    this.optionsMenu.addSeparator();
                }
                this.optionsMenu.add(this.logOptionsMenuItem);
                jMenu = this.optionsMenu;
            } else if (jMenuItemArray.length != 0) {
                jMenu = this.optionsMenu;
            }
        }
        return jMenu;
    }

    private JMenu createHelpMenu() {
        JMenu jMenu = null;
        JMenuItem[] jMenuItemArray = this.getApplicationView().getHelpMenuItems();
        if (jMenuItemArray != null) {
            this.helpMenu.removeAll();
            String string = this.getProperty("gsl.help.helphandler.class");
            if (string != null && !string.equals("")) {
                this.onWindowHelpMenuItem.putClientProperty("HELP_ENABLE", "");
                this.onWindowHelpMenuItem.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_ONWINDOW");
                this.onWindowHelpMenuItem.putClientProperty("HELP_KEY", this.getPresenter().getController().getHelpId());
                this.contentsHelpMenuItem.putClientProperty("HELP_ENABLE", "");
                this.contentsHelpMenuItem.putClientProperty("HELP_KEY", "GSL_DEFAULTMENU_HELPMENU_TOC");
            } else {
                this.onWindowHelpMenuItem.setEnabled(false);
                this.howToHelpMenuItem.setEnabled(false);
                this.contentsHelpMenuItem.setEnabled(false);
            }
            this.helpMenu.add(this.onWindowHelpMenuItem);
            this.helpMenu.add(this.contentsHelpMenuItem);
            this.helpMenu.add(this.howToHelpMenuItem);
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.aboutMenuItem);
            jMenu = this.helpMenu;
        }
        return jMenu;
    }

    protected JMenu[] getMenus() {
        JMenu[] jMenuArray = this.getApplicationView().getMenus();
        if (jMenuArray == null) {
            jMenuArray = new JMenu[]{};
        }
        JMenu[] jMenuArray2 = new JMenu[4 + jMenuArray.length];
        int n = 0;
        jMenuArray2[n++] = this.createFileMenu();
        for (int i = 0; i < jMenuArray.length; ++i) {
            jMenuArray2[n++] = jMenuArray[i];
        }
        jMenuArray2[n++] = this.createOptionsMenu();
        jMenuArray2[n++] = this.createHelpMenu();
        return jMenuArray2;
    }

    protected JComponent[] getToolBarComponents() {
        JComponent[] jComponentArray = this.getApplicationView().getToolBarComponents();
        JComponent[] jComponentArray2 = new JComponent[jComponentArray.length];
        int n = 0;
        for (int i = 0; i < jComponentArray.length; ++i) {
            jComponentArray2[n++] = jComponentArray[i];
        }
        return jComponentArray2;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getOptionsMenu() {
        return this.optionsMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public JComponent getCutButton() {
        return this.cutButton;
    }

    public JComponent getCopyButton() {
        return this.copyButton;
    }

    public JComponent getPasteButton() {
        return this.pasteButton;
    }

    private AbstractApplicationView getApplicationView() {
        return (AbstractApplicationView)this.getPresenter().getView();
    }

    private boolean isInitialApplication() {
        return this.getPresenter().getApplication().getApplicationManager().isInitialApplication(this.getPresenter().getApplication());
    }

    public static class ToolBarButton
    extends JButton {
        public ToolBarButton(Icon icon) {
            super(icon);
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    public class PasteAbstractAction
    extends AbstractAction {
        PasteAbstractAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).paste();
            }
        }
    }

    public class CopyAbstractAction
    extends AbstractAction {
        CopyAbstractAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).copy();
            }
        }
    }

    public class CutAbstractAction
    extends AbstractAction {
        CutAbstractAction(String string, Icon icon) {
            super(string, icon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = ApplicationDefaultView.this.getPresenter().getViewContainer().getFocusOwner();
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).cut();
                ApplicationDefaultView.this.copyAction.setEnabled(false);
                ApplicationDefaultView.this.cutAction.setEnabled(false);
            }
        }
    }
}

