/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationDefaultView;

class ApplicationMenuBar
extends JMenuBar {
    private Vector menuVector = new Vector();
    private ApplicationDefaultView defaultView;

    ApplicationMenuBar(ApplicationDefaultView applicationDefaultView) {
        this.defaultView = applicationDefaultView;
        JMenu[] jMenuArray = applicationDefaultView.getMenus();
        for (int i = 0; i < jMenuArray.length; ++i) {
            if (jMenuArray[i] == null) continue;
            this.menuVector.add(new TopMenu(jMenuArray[i], true));
        }
        this.buildMenu();
    }

    void setMenusVisible(JMenu[] jMenuArray, boolean bl) {
        block0: for (int i = 0; i < jMenuArray.length; ++i) {
            Enumeration enumeration = this.menuVector.elements();
            while (enumeration.hasMoreElements()) {
                TopMenu topMenu = (TopMenu)enumeration.nextElement();
                if (topMenu.getMenu() != jMenuArray[i]) continue;
                topMenu.setVisible(bl);
                continue block0;
            }
        }
        this.buildMenu();
    }

    private void buildMenu() {
        this.removeAll();
        Enumeration enumeration = this.menuVector.elements();
        while (enumeration.hasMoreElements()) {
            TopMenu topMenu = (TopMenu)enumeration.nextElement();
            if (!topMenu.isVisible()) continue;
            this.add(topMenu.getMenu());
        }
    }

    JMenu getFileMenu() {
        return this.defaultView.getFileMenu();
    }

    JMenu getEditMenu() {
        return this.defaultView.getEditMenu();
    }

    JMenu getOptionsMenu() {
        return this.defaultView.getOptionsMenu();
    }

    JMenu getTheHelpMenu() {
        return this.defaultView.getHelpMenu();
    }

    private void closeDisplayedMenu(JMenu jMenu) {
        JPopupMenu jPopupMenu = jMenu.getPopupMenu();
        if (jPopupMenu.isVisible()) {
            MenuElement[] menuElementArray = jPopupMenu.getSubElements();
            for (int i = menuElementArray.length; i > 0; --i) {
                if (menuElementArray[i - 1].getComponent() instanceof JMenu) {
                    this.closeDisplayedMenu((JMenu)menuElementArray[i - 1]);
                }
                menuElementArray[i - 1].getComponent().setVisible(false);
            }
            jMenu.setPopupMenuVisible(false);
        }
    }

    void dispose() {
        Enumeration enumeration = this.menuVector.elements();
        while (enumeration.hasMoreElements()) {
            TopMenu topMenu = (TopMenu)enumeration.nextElement();
            JMenu jMenu = topMenu.getMenu();
            this.closeDisplayedMenu(jMenu);
        }
        this.menuVector.clear();
        this.defaultView = null;
    }

    private static class TopMenu {
        private JMenu menu;
        private boolean visible;

        public TopMenu(JMenu jMenu, boolean bl) {
            this.menu = jMenu;
            this.visible = bl;
        }

        public JMenu getMenu() {
            return this.menu;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }
    }
}

